/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy;

import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetsConfig;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy.DocValuesOrdinalsReader;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy.OrdinalsReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.BinaryDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FilterBinaryDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FilterLeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FilterSortedNumericDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedNumericDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.internal.hppc.IntArrayList;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IntsRef;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class OrdinalMappingLeafReader
extends FilterLeafReader {
    private final int[] ordinalMap;
    private final InnerFacetsConfig facetsConfig;
    private final Set<String> facetFields;

    public OrdinalMappingLeafReader(LeafReader in, int[] ordinalMap, FacetsConfig srcConfig) {
        super(in);
        this.ordinalMap = ordinalMap;
        this.facetsConfig = new InnerFacetsConfig();
        this.facetFields = new HashSet<String>();
        for (FacetsConfig.DimConfig dc : srcConfig.getDimConfigs().values()) {
            this.facetFields.add(dc.indexFieldName);
        }
        this.facetFields.add(FacetsConfig.DEFAULT_DIM_CONFIG.indexFieldName);
    }

    @Deprecated
    protected BytesRef encode(IntsRef ordinals) {
        return this.facetsConfig.dedupAndEncode(ordinals);
    }

    @Deprecated
    protected OrdinalsReader getOrdinalsReader(String field) {
        return new DocValuesOrdinalsReader(field);
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        BinaryDocValues original = this.in.getBinaryDocValues(field);
        if (original != null && this.facetFields.contains(field)) {
            OrdinalsReader ordsReader = this.getOrdinalsReader(field);
            return new OrdinalMappingBinaryDocValues(ordsReader.getReader(this.in.getContext()), original);
        }
        return original;
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        SortedNumericDocValues original = this.in.getSortedNumericDocValues(field);
        if (original != null && this.facetFields.contains(field)) {
            return new OrdinalMappingSortedNumericDocValues(original);
        }
        return original;
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private class OrdinalMappingSortedNumericDocValues
    extends FilterSortedNumericDocValues {
        private final IntArrayList currentValues;
        private int currIndex;

        OrdinalMappingSortedNumericDocValues(SortedNumericDocValues in) {
            super(in);
            this.currentValues = new IntArrayList(32);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            boolean result = this.in.advanceExact(target);
            if (result) {
                this.reloadValues();
            }
            return result;
        }

        @Override
        public int advance(int target) throws IOException {
            int result = this.in.advance(target);
            if (result != Integer.MAX_VALUE) {
                this.reloadValues();
            }
            return result;
        }

        @Override
        public int nextDoc() throws IOException {
            int result = this.in.nextDoc();
            if (result != Integer.MAX_VALUE) {
                this.reloadValues();
            }
            return result;
        }

        @Override
        public int docValueCount() {
            return this.currentValues.elementsCount;
        }

        private void reloadValues() throws IOException {
            this.currIndex = 0;
            this.currentValues.clear();
            for (int i = 0; i < this.in.docValueCount(); ++i) {
                int originalOrd = Math.toIntExact(this.in.nextValue());
                this.currentValues.add(OrdinalMappingLeafReader.this.ordinalMap[originalOrd]);
            }
            Arrays.sort(this.currentValues.buffer, 0, this.currentValues.elementsCount);
        }

        @Override
        public long nextValue() {
            assert (this.currIndex < this.currentValues.size());
            int actual = this.currentValues.get(this.currIndex);
            ++this.currIndex;
            return actual;
        }
    }

    private class OrdinalMappingBinaryDocValues
    extends FilterBinaryDocValues {
        private final IntsRef ordinals;
        private final OrdinalsReader.OrdinalsSegmentReader ordsReader;

        OrdinalMappingBinaryDocValues(OrdinalsReader.OrdinalsSegmentReader ordsReader, BinaryDocValues in) throws IOException {
            super(in);
            this.ordinals = new IntsRef(32);
            this.ordsReader = ordsReader;
        }

        @Override
        public BytesRef binaryValue() {
            try {
                this.ordsReader.get(this.docID(), this.ordinals);
                for (int i = 0; i < this.ordinals.length; ++i) {
                    this.ordinals.ints[i] = OrdinalMappingLeafReader.this.ordinalMap[this.ordinals.ints[i]];
                }
                return OrdinalMappingLeafReader.this.encode(this.ordinals);
            }
            catch (IOException e) {
                throw new RuntimeException("error reading category ordinals for doc " + this.docID(), e);
            }
        }
    }

    private static class InnerFacetsConfig
    extends FacetsConfig {
        InnerFacetsConfig() {
        }

        @Override
        public BytesRef dedupAndEncode(IntsRef ordinals) {
            return super.dedupAndEncode(ordinals);
        }
    }
}

