/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.PostingsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermStates;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Terms;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.search.AbstractMultiTermQueryConstantScoreWrapper;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MultiTermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import com.dataiku.dss.shadelib.org.apache.lucene.util.DocIdSetBuilder;
import java.io.IOException;
import java.util.List;

final class MultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends AbstractMultiTermQueryConstantScoreWrapper<Q> {
    MultiTermQueryConstantScoreWrapper(Q query) {
        super(query);
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new AbstractMultiTermQueryConstantScoreWrapper.RewritingWeight(this.query, boost, scoreMode, searcher){

            @Override
            protected AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator rewriteInner(LeafReaderContext context, int fieldDocCount, Terms terms, TermsEnum termsEnum, List<AbstractMultiTermQueryConstantScoreWrapper.TermAndState> collectedTerms) throws IOException {
                DocIdSetBuilder builder = new DocIdSetBuilder(context.reader().maxDoc(), terms);
                PostingsEnum docs = null;
                if (!collectedTerms.isEmpty()) {
                    TermsEnum termsEnum2 = terms.iterator();
                    for (AbstractMultiTermQueryConstantScoreWrapper.TermAndState t2 : collectedTerms) {
                        termsEnum2.seekExact(t2.term, t2.state);
                        docs = termsEnum2.postings(docs, 0);
                        builder.add(docs);
                    }
                }
                do {
                    docs = termsEnum.postings(docs, 0);
                    int docFreq = termsEnum.docFreq();
                    if (fieldDocCount == docFreq) {
                        TermStates termStates = new TermStates(searcher.getTopReaderContext());
                        termStates.register(termsEnum.termState(), context.ord, docFreq, termsEnum.totalTermFreq());
                        ConstantScoreQuery q = new ConstantScoreQuery(new TermQuery(new Term(MultiTermQueryConstantScoreWrapper.this.query.field, termsEnum.term()), termStates));
                        Weight weight = searcher.rewrite(q).createWeight(searcher, scoreMode, this.score());
                        return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(weight);
                    }
                    builder.add(docs);
                } while (termsEnum.next() != null);
                return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(builder.build().iterator());
            }
        };
    }
}

