/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util;

import com.dataiku.dss.shadelib.org.apache.lucene.store.Directory;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Constants;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class IOUtils {
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    private IOUtils() {
    }

    public static void close(Closeable ... objects) throws IOException {
        IOUtils.close(Arrays.asList(objects));
    }

    public static void close(Iterable<? extends Closeable> objects) throws IOException {
        Throwable th = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable t2) {
                th = IOUtils.useOrSuppress(th, t2);
            }
        }
        if (th != null) {
            throw IOUtils.rethrowAlways(th);
        }
    }

    public static void closeWhileHandlingException(Closeable ... objects) {
        IOUtils.closeWhileHandlingException(Arrays.asList(objects));
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> objects) {
        Throwable firstError = null;
        Throwable firstThrowable = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (VirtualMachineError e) {
                firstError = IOUtils.useOrSuppress(firstError, e);
            }
            catch (Throwable t2) {
                firstThrowable = IOUtils.useOrSuppress(firstThrowable, t2);
            }
        }
        if (firstError != null) {
            if (firstThrowable != null) {
                firstError.addSuppressed(firstThrowable);
            }
            throw firstError;
        }
    }

    public static Reader getDecodingReader(InputStream stream, Charset charSet) {
        CharsetDecoder charSetDecoder = charSet.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader(stream, charSetDecoder));
    }

    public static <T> T requireResourceNonNull(T resource, String name) throws IOException {
        if (resource == null) {
            throw new FileNotFoundException("The resource '" + name + "' was not found.");
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true, since="9.1")
    public static Reader getDecodingReader(Class<?> clazz, String resource, Charset charSet) throws IOException {
        Reader reader;
        block4: {
            Module argModule = clazz.getModule();
            if (argModule.isNamed() && argModule != IOUtils.class.getModule()) {
                throw new UnsupportedOperationException("getDecodingReader(class,...) does not work when Java Module System is enabled.");
            }
            InputStream stream = IOUtils.requireResourceNonNull(clazz.getResourceAsStream(resource), resource);
            boolean success = false;
            try {
                Reader reader2 = IOUtils.getDecodingReader(stream, charSet);
                success = true;
                reader = reader2;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close(stream);
                }
                throw throwable;
            }
            IOUtils.close(stream);
        }
        return reader;
    }

    public static void deleteFilesIgnoringExceptions(Directory dir, Collection<String> files) {
        for (String name : files) {
            try {
                dir.deleteFile(name);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void deleteFilesIgnoringExceptions(Directory dir, String ... files) {
        IOUtils.deleteFilesIgnoringExceptions(dir, Arrays.asList(files));
    }

    public static void deleteFiles(Directory dir, Collection<String> names) throws IOException {
        Throwable th = null;
        for (String name : names) {
            if (name == null) continue;
            try {
                dir.deleteFile(name);
            }
            catch (Throwable t2) {
                th = IOUtils.useOrSuppress(th, t2);
            }
        }
        if (th != null) {
            throw IOUtils.rethrowAlways(th);
        }
    }

    public static void deleteFilesIgnoringExceptions(Path ... files) {
        IOUtils.deleteFilesIgnoringExceptions(Arrays.asList(files));
    }

    public static void deleteFilesIgnoringExceptions(Collection<? extends Path> files) {
        for (Path path : files) {
            if (path == null) continue;
            try {
                Files.delete(path);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void deleteFilesIfExist(Path ... files) throws IOException {
        IOUtils.deleteFilesIfExist(Arrays.asList(files));
    }

    public static void deleteFilesIfExist(Collection<? extends Path> files) throws IOException {
        Throwable th = null;
        for (Path path : files) {
            try {
                if (path == null) continue;
                Files.deleteIfExists(path);
            }
            catch (Throwable t2) {
                th = IOUtils.useOrSuppress(th, t2);
            }
        }
        if (th != null) {
            throw IOUtils.rethrowAlways(th);
        }
    }

    public static void rm(Path ... locations) throws IOException {
        LinkedHashMap<Path, Throwable> unremoved = IOUtils.rm(new LinkedHashMap<Path, Throwable>(), locations);
        if (!unremoved.isEmpty()) {
            StringBuilder b = new StringBuilder("Could not remove the following files (in the order of attempts):\n");
            for (Map.Entry<Path, Throwable> kv : unremoved.entrySet()) {
                b.append("   ").append(kv.getKey().toAbsolutePath()).append(": ").append(kv.getValue()).append("\n");
            }
            throw new IOException(b.toString());
        }
    }

    private static LinkedHashMap<Path, Throwable> rm(final LinkedHashMap<Path, Throwable> unremoved, Path ... locations) {
        if (locations != null) {
            for (Path location : locations) {
                if (location == null || !Files.exists(location, new LinkOption[0])) continue;
                try {
                    Files.walkFileTree(location, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException impossible) throws IOException {
                            assert (impossible == null);
                            try {
                                Files.delete(dir);
                            }
                            catch (IOException e) {
                                unremoved.put(dir, e);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            try {
                                Files.delete(file);
                            }
                            catch (IOException exc) {
                                unremoved.put(file, exc);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            if (exc != null) {
                                unremoved.put(file, exc);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException impossible) {
                    throw new AssertionError("visitor threw exception", impossible);
                }
            }
        }
        return unremoved;
    }

    public static Error rethrowAlways(Throwable th) throws IOException, RuntimeException {
        if (th == null) {
            throw new AssertionError((Object)"rethrow argument must not be null.");
        }
        if (th instanceof IOException) {
            throw (IOException)th;
        }
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof Error) {
            throw (Error)th;
        }
        throw new RuntimeException(th);
    }

    public static void fsync(Path fileToSync, boolean isDir) throws IOException {
        if (isDir && Constants.WINDOWS) {
            if (!Files.exists(fileToSync, new LinkOption[0])) {
                throw new NoSuchFileException(fileToSync.toString());
            }
            return;
        }
        try (FileChannel file = FileChannel.open(fileToSync, isDir ? StandardOpenOption.READ : StandardOpenOption.WRITE);){
            try {
                file.force(true);
            }
            catch (IOException e) {
                if (isDir) {
                    assert (!(Constants.LINUX || Constants.MAC_OS_X)) : "On Linux and MacOSX fsyncing a directory should not throw IOException, we just don't want to rely on that in production (undocumented). Got: " + e;
                    if (file != null) {
                        file.close();
                    }
                    return;
                }
                throw e;
            }
        }
    }

    public static <T extends Throwable> T useOrSuppress(T first, T second) {
        if (first == null) {
            return second;
        }
        first.addSuppressed(second);
        return first;
    }

    public static <T> void applyToAll(Collection<T> collection, IOConsumer<T> consumer) throws IOException {
        IOUtils.close(collection.stream().filter(Objects::nonNull).map(t2 -> () -> consumer.accept(t2))::iterator);
    }

    @FunctionalInterface
    @Deprecated(forRemoval=true, since="9.1")
    public static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    @FunctionalInterface
    @Deprecated(forRemoval=true, since="9.1")
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

