/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.bytes;

import com.dataiku.dss.shadelib.org.apache.parquet.bytes.ByteBufferAllocator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ByteBufferReleaser
implements AutoCloseable {
    final ByteBufferAllocator allocator;
    private final List<ByteBuffer> toRelease = new ArrayList<ByteBuffer>();

    public ByteBufferReleaser(ByteBufferAllocator allocator) {
        this.allocator = allocator;
    }

    public void releaseLater(ByteBuffer buffer) {
        this.toRelease.add(buffer);
    }

    @Override
    public void close() {
        for (ByteBuffer buf : this.toRelease) {
            this.allocator.release(buf);
        }
        this.toRelease.clear();
    }
}

