/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.column.impl;

import com.dataiku.dss.shadelib.org.apache.parquet.bytes.BytesInput;
import com.dataiku.dss.shadelib.org.apache.parquet.column.ColumnDescriptor;
import com.dataiku.dss.shadelib.org.apache.parquet.column.Encoding;
import com.dataiku.dss.shadelib.org.apache.parquet.column.ParquetProperties;
import com.dataiku.dss.shadelib.org.apache.parquet.column.impl.ColumnWriterBase;
import com.dataiku.dss.shadelib.org.apache.parquet.column.page.PageWriter;
import com.dataiku.dss.shadelib.org.apache.parquet.column.statistics.SizeStatistics;
import com.dataiku.dss.shadelib.org.apache.parquet.column.statistics.Statistics;
import com.dataiku.dss.shadelib.org.apache.parquet.column.statistics.geospatial.GeospatialStatistics;
import com.dataiku.dss.shadelib.org.apache.parquet.column.values.ValuesWriter;
import com.dataiku.dss.shadelib.org.apache.parquet.column.values.bitpacking.DevNullValuesWriter;
import com.dataiku.dss.shadelib.org.apache.parquet.column.values.bloomfilter.BloomFilterWriter;
import com.dataiku.dss.shadelib.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import com.dataiku.dss.shadelib.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import com.dataiku.dss.shadelib.org.apache.parquet.io.ParquetEncodingException;
import java.io.IOException;

final class ColumnWriterV2
extends ColumnWriterBase {
    private static final ValuesWriter NULL_WRITER = new DevNullValuesWriter();

    ColumnWriterV2(ColumnDescriptor path, PageWriter pageWriter, ParquetProperties props) {
        super(path, pageWriter, props);
    }

    ColumnWriterV2(ColumnDescriptor path, PageWriter pageWriter, BloomFilterWriter bloomFilterWriter, ParquetProperties props) {
        super(path, pageWriter, bloomFilterWriter, props);
    }

    @Override
    ValuesWriter createRLWriter(ParquetProperties props, ColumnDescriptor path) {
        return path.getMaxRepetitionLevel() == 0 ? NULL_WRITER : new RLEWriterForV2(props.newRepetitionLevelEncoder(path));
    }

    @Override
    ValuesWriter createDLWriter(ParquetProperties props, ColumnDescriptor path) {
        return path.getMaxDefinitionLevel() == 0 ? NULL_WRITER : new RLEWriterForV2(props.newDefinitionLevelEncoder(path));
    }

    @Override
    void writePage(int rowCount, int valueCount, Statistics<?> statistics, SizeStatistics sizeStatistics, GeospatialStatistics geospatialStatistics, ValuesWriter repetitionLevels, ValuesWriter definitionLevels, ValuesWriter values2) throws IOException {
        BytesInput bytes = values2.getBytes();
        Encoding encoding = values2.getEncoding();
        this.pageWriter.writePageV2(rowCount, Math.toIntExact(statistics.getNumNulls()), valueCount, repetitionLevels.getBytes(), definitionLevels.getBytes(), encoding, bytes, statistics, sizeStatistics, geospatialStatistics);
    }

    private static class RLEWriterForV2
    extends RunLengthBitPackingHybridValuesWriter {
        public RLEWriterForV2(RunLengthBitPackingHybridEncoder encoder) {
            super(encoder);
        }

        @Override
        public BytesInput getBytes() {
            try {
                return this.encoder.toBytes();
            }
            catch (IOException e) {
                throw new ParquetEncodingException(e);
            }
        }
    }
}

