/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.variant;

import com.dataiku.dss.shadelib.org.apache.parquet.variant.Metadata;
import com.dataiku.dss.shadelib.org.apache.parquet.variant.VariantBuilder;
import java.util.ArrayList;

public class VariantObjectBuilder
extends VariantBuilder {
    private final ArrayList<VariantBuilder.FieldEntry> fields = new ArrayList();
    protected long numValues = 0L;

    VariantObjectBuilder(Metadata metadata) {
        super(metadata);
    }

    public void appendKey(String key) {
        if ((long)this.fields.size() > this.numValues) {
            throw new IllegalStateException("Cannot call appendKey() before appending a value for the previous key.");
        }
        this.updateLastValueSize();
        this.fields.add(new VariantBuilder.FieldEntry(key, this.addDictionaryKey(key), this.writePos));
    }

    void dropLastKey() {
        if ((long)this.fields.size() != this.numValues + 1L) {
            throw new IllegalStateException("Can only drop the last added key with no corresponding value.");
        }
        this.fields.remove(this.fields.size() - 1);
    }

    ArrayList<VariantBuilder.FieldEntry> validateAndGetFields() {
        if ((long)this.fields.size() != this.numValues) {
            throw new IllegalStateException(String.format("Number of object keys (%d) do not match the number of values (%d).", this.fields.size(), this.numValues));
        }
        this.checkMultipleNested("Cannot call endObject() while a nested object/array is still open.");
        this.updateLastValueSize();
        return this.fields;
    }

    @Override
    protected void onAppend() {
        this.checkAppendWhileNested();
        if (this.numValues != (long)(this.fields.size() - 1)) {
            throw new IllegalStateException("Cannot append an object value before calling appendKey()");
        }
        ++this.numValues;
    }

    @Override
    protected void onStartNested() {
        this.checkMultipleNested("Cannot call startObject()/startArray() without calling endObject()/endArray() first.");
        ++this.numValues;
    }

    private void updateLastValueSize() {
        if (!this.fields.isEmpty()) {
            VariantBuilder.FieldEntry lastField = this.fields.get(this.fields.size() - 1);
            lastField.updateValueSize(this.writePos() - lastField.offset);
        }
    }
}

