/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.conn;

import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpHost;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.Contract;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.SchemePortResolver;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.UnsupportedSchemeException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) throws UnsupportedSchemeException {
        Args.notNull(host, "HTTP host");
        int port = host.getPort();
        if (port > 0) {
            return port;
        }
        String name = host.getSchemeName();
        if (name.equalsIgnoreCase("http")) {
            return 80;
        }
        if (name.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(name + " protocol is not supported");
    }
}

