/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonCreator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonProperty;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dataiku.dss.shadelib.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.CheckReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.javax.annotation.ParametersAreNonnullByDefault;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.Immutable;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.NotThreadSafe;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.GrantType;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.PasswordTokenRequest;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.PublicClientRequest;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.TokenRequestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PasswordTokenRequest", generator="Immutables")
@Immutable
final class ImmutablePasswordTokenRequest
implements PasswordTokenRequest {
    @Nullable
    private final String scope;
    private final Map<String, String> extraParameters;
    @Nullable
    private final String clientId;
    private final transient GrantType grantType;
    private final String username;
    private final String password;

    private ImmutablePasswordTokenRequest(@Nullable String scope, Map<String, String> extraParameters, @Nullable String clientId, String username, String password) {
        this.scope = scope;
        this.extraParameters = extraParameters;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.grantType = Objects.requireNonNull(PasswordTokenRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="extraParameters")
    @JsonAnyGetter
    public Map<String, String> extraParameters() {
        return this.extraParameters;
    }

    @Override
    @JsonProperty(value="client_id")
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @Override
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public final ImmutablePasswordTokenRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutablePasswordTokenRequest(value, this.extraParameters, this.clientId, this.username, this.password);
    }

    public final ImmutablePasswordTokenRequest withExtraParameters(Map<String, ? extends String> entries) {
        if (this.extraParameters == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutablePasswordTokenRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutablePasswordTokenRequest(this.scope, newValue, this.clientId, this.username, this.password);
    }

    public final ImmutablePasswordTokenRequest withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutablePasswordTokenRequest(this.scope, this.extraParameters, value, this.username, this.password);
    }

    public final ImmutablePasswordTokenRequest withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutablePasswordTokenRequest(this.scope, this.extraParameters, this.clientId, newValue, this.password);
    }

    public final ImmutablePasswordTokenRequest withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return new ImmutablePasswordTokenRequest(this.scope, this.extraParameters, this.clientId, this.username, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePasswordTokenRequest && this.equalsByValue((ImmutablePasswordTokenRequest)another);
    }

    private boolean equalsByValue(ImmutablePasswordTokenRequest another) {
        return Objects.equals(this.scope, another.scope) && this.extraParameters.equals(another.extraParameters) && Objects.equals(this.clientId, another.clientId) && this.grantType.equals((Object)another.grantType) && this.username.equals(another.username) && this.password.equals(another.password);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        h2 += (h2 << 5) + this.extraParameters.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.clientId);
        h2 += (h2 << 5) + this.grantType.hashCode();
        h2 += (h2 << 5) + this.username.hashCode();
        h2 += (h2 << 5) + this.password.hashCode();
        return h2;
    }

    public String toString() {
        return "PasswordTokenRequest{scope=" + this.scope + ", extraParameters=" + String.valueOf(this.extraParameters) + ", clientId=" + this.clientId + ", grantType=" + String.valueOf((Object)this.grantType) + ", username=" + this.username + ", password=" + this.password + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePasswordTokenRequest fromJson(Json json) {
        Builder builder = ImmutablePasswordTokenRequest.builder();
        if (json._scope != null) {
            builder.scope(json._scope);
        }
        if (json._extraParameters != null) {
            builder.putAllExtraParameters(json._extraParameters);
        }
        if (json._clientId != null) {
            builder.clientId(json._clientId);
        }
        if (json._username != null) {
            builder.username(json._username);
        }
        if (json._password != null) {
            builder.password(json._password);
        }
        return builder.build();
    }

    public static ImmutablePasswordTokenRequest copyOf(PasswordTokenRequest instance) {
        if (instance instanceof ImmutablePasswordTokenRequest) {
            return (ImmutablePasswordTokenRequest)instance;
        }
        return ImmutablePasswordTokenRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="PasswordTokenRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements PasswordTokenRequest.Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private long initBits = 3L;
        private String scope;
        private Map<String, String> extraParameters = new LinkedHashMap<String, String>();
        private String clientId;
        private String username;
        private String password;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PasswordTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String scopeValue;
            String clientIdValue;
            Object instance;
            long bits = 0L;
            if (object instanceof PasswordTokenRequest) {
                instance = (PasswordTokenRequest)object;
                if ((bits & 4L) == 0L) {
                    this.putAllExtraParameters(instance.extraParameters());
                    bits |= 4L;
                }
                this.password(instance.getPassword());
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
                this.username(instance.getUsername());
            }
            if (object instanceof PublicClientRequest) {
                instance = (PublicClientRequest)object;
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TokenRequestBase) {
                instance = (TokenRequestBase)object;
                if ((bits & 4L) == 0L) {
                    this.putAllExtraParameters(instance.extraParameters());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putExtraParameter(String key, String value) {
            this.extraParameters.put(Objects.requireNonNull(key, "extraParameters key"), Objects.requireNonNull(value, value == null ? "extraParameters value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraParameter(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "extraParameters value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="extraParameters")
        @CanIgnoreReturnValue
        public final Builder extraParameters(Map<String, ? extends String> entries) {
            this.extraParameters.clear();
            return this.putAllExtraParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraParameters(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "extraParameters value for key: " + k : null));
            }
            return this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        @JsonProperty(value="username")
        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="password")
        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutablePasswordTokenRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePasswordTokenRequest(this.scope, ImmutablePasswordTokenRequest.createUnmodifiableMap(false, false, this.extraParameters), this.clientId, this.username, this.password);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build PasswordTokenRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated(from="PasswordTokenRequest", generator="Immutables")
    static final class Json
    implements PasswordTokenRequest {
        @JsonIgnore
        String _scope;
        @JsonIgnore
        String _clientId;
        @JsonIgnore
        String _username;
        @JsonIgnore
        String _password;
        @JsonIgnore
        final Map<String, String> _extraParameters = new HashMap<String, String>();

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this._scope = scope;
        }

        @JsonProperty(value="client_id")
        public void setClientId(@Nullable String clientId) {
            this._clientId = clientId;
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this._username = username;
        }

        @JsonProperty(value="password")
        public void setPassword(String password) {
            this._password = password;
        }

        @JsonAnySetter
        public void setExtraParameters(String key, String value) {
            this._extraParameters.put(key, value);
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> extraParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPassword() {
            throw new UnsupportedOperationException();
        }
    }
}

