/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2;

import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.ImpersonationConfig;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.TokenExchangeFlow;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.Tokens;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpAuthentication;
import java.net.URI;
import java.util.Optional;

class ImpersonationFlow
extends TokenExchangeFlow {
    private final ImpersonationConfig impersonationConfig;

    ImpersonationFlow(OAuth2ClientConfig config) {
        super(config);
        this.impersonationConfig = config.getImpersonationConfig();
    }

    @Override
    public Tokens fetchNewTokens(Tokens currentTokens) {
        Tokens newTokens = super.fetchNewTokens(currentTokens);
        return Tokens.of(newTokens.getAccessToken(), currentTokens.getRefreshToken());
    }

    @Override
    Optional<String> getScope() {
        if (!this.impersonationConfig.getScopes().equals(ImpersonationConfig.SCOPES_INHERIT)) {
            return this.impersonationConfig.getScopes().stream().reduce((a, b) -> a + " " + b);
        }
        return super.getScope();
    }

    @Override
    URI getResolvedTokenEndpoint() {
        return this.config.getResolvedImpersonationTokenEndpoint().orElseGet(() -> super.getResolvedTokenEndpoint());
    }

    @Override
    String getClientId() {
        return this.impersonationConfig.getClientId().orElseGet(() -> super.getClientId());
    }

    @Override
    boolean isPublicClient() {
        return this.config.isImpersonationPublicClient().orElseGet(() -> super.isPublicClient());
    }

    @Override
    Optional<HttpAuthentication> getBasicAuthentication() {
        return this.config.getImpersonationBasicAuthentication().or(() -> super.getBasicAuthentication());
    }
}

