/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.ErrorResponse;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.OAuth2Exception;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClientException;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClientResponseException;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.ResponseContext;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.ResponseFilter;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.Status;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.io.CapturingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

class OAuth2ResponseFilter
implements ResponseFilter {
    private final ObjectMapper objectMapper;

    OAuth2ResponseFilter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void filter(ResponseContext responseContext) {
        block13: {
            try {
                URI uri = responseContext.getRequestedUri();
                Status status = responseContext.getStatus();
                if (status == Status.OK || status == Status.FOUND) break block13;
                String body = null;
                IOException decodeError = null;
                if (responseContext.getInputStream() != null) {
                    try (CapturingInputStream capturing = new CapturingInputStream(responseContext.getInputStream());){
                        if (responseContext.isJsonCompatibleResponse()) {
                            try {
                                ErrorResponse errorResponse = this.objectMapper.readValue((InputStream)capturing, ErrorResponse.class);
                                String message = OAuth2ResponseFilter.createJsonErrorMessage(uri, status, errorResponse);
                                throw new OAuth2Exception(message, status, errorResponse);
                            }
                            catch (IOException e) {
                                decodeError = e;
                            }
                        }
                        body = capturing.capture();
                    }
                }
                String message = OAuth2ResponseFilter.createGenericErrorMessage(uri, status, body);
                HttpClientResponseException exception = new HttpClientResponseException(message, status);
                if (decodeError != null) {
                    exception.addSuppressed(decodeError);
                }
                throw exception;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HttpClientException(e);
            }
        }
    }

    private static String createJsonErrorMessage(URI uri, Status status, ErrorResponse errorResponse) {
        StringBuilder builder = new StringBuilder().append("Request to ").append(uri).append(" failed with HTTP/").append(status.getCode()).append(" and error code \"").append(errorResponse.getErrorCode()).append("\"");
        if (errorResponse.getErrorDescription() != null) {
            builder.append(": ").append(errorResponse.getErrorDescription());
        }
        return builder.toString();
    }

    private static String createGenericErrorMessage(URI uri, Status status, String body) {
        StringBuilder builder = new StringBuilder().append("Request to ").append(uri).append(" failed with HTTP/").append(status.getCode());
        if (body != null && !body.isEmpty()) {
            builder.append(" and unparseable response body: ").append(body);
        } else {
            builder.append(" (response body was empty)");
        }
        return builder.toString();
    }
}

