/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.http;

import com.dataiku.dss.shadelib.org.projectnessie.client.http.ExecutableHttpRequest;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClientException;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpResponse;
import java.util.function.Supplier;

class HttpRequestWrapper<E1 extends Throwable, E2 extends Throwable>
implements ExecutableHttpRequest<E1, E2> {
    private final ExecutableHttpRequest<HttpClientException, RuntimeException> delegate;
    private final Class<E1> ex1;
    private final Class<E2> ex2;

    HttpRequestWrapper(ExecutableHttpRequest<HttpClientException, RuntimeException> delegate, Class<E1> ex1, Class<E2> ex2) {
        this.delegate = delegate;
        this.ex1 = ex1;
        this.ex2 = ex2;
    }

    @Override
    public HttpResponse get() throws E1, E2 {
        return this.unwrap(this.delegate::get);
    }

    @Override
    public HttpResponse delete() throws E1, E2 {
        return this.unwrap(this.delegate::delete);
    }

    @Override
    public HttpResponse post(Object obj) throws E1, E2 {
        return this.unwrap(() -> this.delegate.post(obj));
    }

    @Override
    public HttpResponse put(Object obj) throws E1, E2 {
        return this.unwrap(() -> this.delegate.put(obj));
    }

    private HttpResponse unwrap(Supplier<HttpResponse> action) throws E1, E2 {
        try {
            return action.get();
        }
        catch (HttpClientException e) {
            Throwable cause = e.getCause();
            if (this.ex1.isInstance(cause)) {
                throw (Throwable)this.ex1.cast(cause);
            }
            if (this.ex2.isInstance(cause)) {
                throw (Throwable)this.ex2.cast(cause);
            }
            throw e;
        }
    }
}

