/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.http;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClient;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClientException;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpResponse;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.NessieApiCompatibilityException;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.RequestContext;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.RequestFilter;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.Status;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieApiCompatibilityFilter
implements RequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieApiCompatibilityFilter.class);
    private static final String MIN_API_VERSION = "minSupportedApiVersion";
    private static final String MAX_API_VERSION = "maxSupportedApiVersion";
    private static final String ACTUAL_API_VERSION = "actualApiVersion";
    private final int clientApiVersion;
    private final AtomicBoolean checkDone = new AtomicBoolean(false);
    private HttpClient httpClient;

    NessieApiCompatibilityFilter(int clientApiVersion) {
        this.clientApiVersion = clientApiVersion;
    }

    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void filter(RequestContext context) {
        if (this.httpClient != null && this.checkDone.compareAndSet(false, true)) {
            NessieApiCompatibilityFilter.check(this.clientApiVersion, this.httpClient);
        }
    }

    static void check(int clientApiVersion, HttpClient httpClient) throws NessieApiCompatibilityException {
        int actualServerApiVersion;
        JsonNode config;
        try {
            HttpResponse response = httpClient.newRequest().bypassFilters().path("config").get();
            if (response.getStatus() != Status.OK) {
                LOGGER.warn("API compatibility check: config endpoint replied with status {}, proceeding without check", (Object)response.getStatus());
                return;
            }
            config = response.readEntity(JsonNode.class);
        }
        catch (HttpClientException e) {
            LOGGER.warn("API compatibility check: failed to contact config endpoint, proceeding without check: {}", (Object)e.toString());
            return;
        }
        catch (CancellationException e) {
            return;
        }
        catch (Exception e) {
            LOGGER.warn("API compatibility check: failed to contact config endpoint, proceeding without check", (Throwable)e);
            return;
        }
        int minServerApiVersion = config.hasNonNull(MIN_API_VERSION) ? config.get(MIN_API_VERSION).asInt() : 1;
        int maxServerApiVersion = config.get(MAX_API_VERSION).asInt();
        int n = actualServerApiVersion = config.hasNonNull(ACTUAL_API_VERSION) ? config.get(ACTUAL_API_VERSION).asInt() : 1;
        if (clientApiVersion < minServerApiVersion || clientApiVersion > maxServerApiVersion || clientApiVersion != actualServerApiVersion) {
            throw new NessieApiCompatibilityException(clientApiVersion, minServerApiVersion, maxServerApiVersion, actualServerApiVersion);
        }
    }
}

