/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.error;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonDeserializer;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieBackendThrottledException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieBadRequestException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieContentNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieError;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieForbiddenException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceNotEmptyException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceAlreadyExistsException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceConflictException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieUnavailableException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieUnsupportedMediaTypeException;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;

public enum ErrorCode {
    UNKNOWN(500, null),
    SERVICE_UNAVAILABLE(503, NessieUnavailableException::new),
    REFERENCE_NOT_FOUND(404, NessieReferenceNotFoundException::new),
    REFERENCE_ALREADY_EXISTS(409, NessieReferenceAlreadyExistsException::new),
    CONTENT_NOT_FOUND(404, NessieContentNotFoundException::new),
    REFERENCE_CONFLICT(409, NessieReferenceConflictException::new),
    BAD_REQUEST(400, NessieBadRequestException::new),
    FORBIDDEN(403, NessieForbiddenException::new),
    TOO_MANY_REQUESTS(429, NessieBackendThrottledException::new),
    NAMESPACE_NOT_FOUND(404, NessieNamespaceNotFoundException::new),
    NAMESPACE_ALREADY_EXISTS(409, NessieNamespaceAlreadyExistsException::new),
    NAMESPACE_NOT_EMPTY(409, NessieNamespaceNotEmptyException::new),
    UNSUPPORTED_MEDIA_TYPE(415, NessieUnsupportedMediaTypeException::new);

    private final int httpStatus;
    private final Function<NessieError, ? extends Exception> exceptionBuilder;

    private <T extends Exception> ErrorCode(int status, Function<NessieError, T> exceptionBuilder) {
        this.httpStatus = status;
        this.exceptionBuilder = exceptionBuilder;
    }

    public int httpStatus() {
        return this.httpStatus;
    }

    public static Optional<Exception> asException(NessieError error) {
        return Optional.ofNullable(error.getErrorCode()).flatMap(e -> Optional.ofNullable(e.exceptionBuilder)).map(b -> (Exception)b.apply(error));
    }

    public static ErrorCode parse(String errorCode) {
        try {
            if (errorCode != null) {
                return ErrorCode.valueOf(errorCode.toUpperCase(Locale.ROOT));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    public static final class Deserializer
    extends JsonDeserializer<ErrorCode> {
        @Override
        public ErrorCode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String name = p.readValueAs(String.class);
            return name != null ? ErrorCode.parse(name) : null;
        }
    }
}

