/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.model;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonView;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.dataiku.dss.shadelib.org.projectnessie.model.Content;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableEntriesResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableEntry;
import com.dataiku.dss.shadelib.org.projectnessie.model.PaginatedResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.Reference;
import com.dataiku.dss.shadelib.org.projectnessie.model.ser.Views;
import jakarta.annotation.Nullable;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableEntriesResponse.class)
@JsonDeserialize(as=ImmutableEntriesResponse.class)
@Value.Immutable
public interface EntriesResponse
extends PaginatedResponse {
    public static ImmutableEntriesResponse.Builder builder() {
        return ImmutableEntriesResponse.builder();
    }

    @NotNull
    @jakarta.validation.constraints.NotNull
    public List<Entry> getEntries();

    @com.dataiku.dss.shadelib.javax.annotation.Nullable
    @Nullable
    @JsonView(value={Views.V2.class})
    public Reference getEffectiveReference();

    @JsonSerialize(as=ImmutableEntry.class)
    @JsonDeserialize(as=ImmutableEntry.class)
    @Value.Immutable
    public static interface Entry {
        public static ImmutableEntry.Builder builder() {
            return ImmutableEntry.builder();
        }

        @NotNull
        @jakarta.validation.constraints.NotNull
        @Schema(ref="#/components/schemas/Type")
        @Value.Parameter(order=2)
        public Content.Type getType();

        @NotNull
        @jakarta.validation.constraints.NotNull
        @Value.Parameter(order=1)
        public ContentKey getName();

        @JsonView(value={Views.V2.class})
        @com.dataiku.dss.shadelib.javax.annotation.Nullable
        @Nullable
        @Value.Parameter(order=3)
        public String getContentId();

        @JsonView(value={Views.V2.class})
        @com.dataiku.dss.shadelib.javax.annotation.Nullable
        @Nullable
        @Value.Parameter(order=4)
        public Content getContent();

        @Value.Check
        default public void verify() {
            Content content = this.getContent();
            if (content == null) {
                return;
            }
            if (!content.getType().equals(this.getType())) {
                throw new IllegalArgumentException("Content type '" + String.valueOf(this.getType()) + "' does not match actual type of content: " + String.valueOf(content));
            }
            if (!content.getId().equals(this.getContentId())) {
                throw new IllegalArgumentException("Content id '" + this.getContentId() + "' does not match actual id of content: " + String.valueOf(content));
            }
        }

        public static Entry entry(ContentKey name, Content.Type type) {
            return Entry.entry(name, type, (String)null);
        }

        public static Entry entry(ContentKey name, Content.Type type, String contentId) {
            return ImmutableEntry.of(name, type, contentId, null);
        }

        public static Entry entry(ContentKey name, Content.Type type, Content content) {
            return ImmutableEntry.of(name, type, content.getId(), content);
        }
    }
}

