/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.model;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonInclude;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonSubTypes;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.dataiku.dss.shadelib.org.projectnessie.model.Base;
import com.dataiku.dss.shadelib.org.projectnessie.model.Branch;
import com.dataiku.dss.shadelib.org.projectnessie.model.Detached;
import com.dataiku.dss.shadelib.org.projectnessie.model.ReferenceMetadata;
import com.dataiku.dss.shadelib.org.projectnessie.model.Tag;
import com.dataiku.dss.shadelib.org.projectnessie.model.Util;
import com.dataiku.dss.shadelib.org.projectnessie.model.Validation;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;

@Schema(type=SchemaType.OBJECT, title="Reference", oneOf={Branch.class, Tag.class, Detached.class}, discriminatorMapping={@DiscriminatorMapping(value="TAG", schema=Tag.class), @DiscriminatorMapping(value="BRANCH", schema=Branch.class), @DiscriminatorMapping(value="DETACHED", schema=Detached.class)}, discriminatorProperty="type", properties={@SchemaProperty(name="name", pattern="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$"), @SchemaProperty(name="hash", pattern="^[0-9a-fA-F]{8,64}$"), @SchemaProperty(name="metadata", nullable=true)})
@JsonSubTypes(value={@JsonSubTypes.Type(value=Branch.class), @JsonSubTypes.Type(value=Tag.class), @JsonSubTypes.Type(value=Detached.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface Reference
extends Base {
    @javax.validation.constraints.NotBlank
    @NotBlank
    @javax.validation.constraints.Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    public @javax.validation.constraints.NotBlank @NotBlank @javax.validation.constraints.Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String getName();

    @javax.validation.constraints.Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}([.][0-9]{1,9})?Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.")
    @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}([.][0-9]{1,9})?Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.")
    public @javax.validation.constraints.Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}([.][0-9]{1,9})?Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}([.][0-9]{1,9})?Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String getHash();

    @Value.Check
    default public void checkHash() {
        String hash = this.getHash();
        if (hash != null) {
            Validation.validateHashOrRelativeSpec(hash);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @com.dataiku.dss.shadelib.javax.annotation.Nullable
    @Nullable
    public ReferenceMetadata getMetadata();

    @JsonIgnore
    @Value.Redacted
    public ReferenceType getType();

    default public String toPathString() {
        return Reference.toPathString(this.getName(), this.getHash());
    }

    public static String toPathString(String name, String hash) {
        return Util.toPathStringRef(name, hash);
    }

    @Schema(enumeration={"branch", "tag"})
    public static enum ReferenceType {
        BRANCH,
        TAG;

    }
}

