/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.spec;

import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.JsonProcessingException;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.FileContent;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.FileWithBytes;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.FileWithUri;
import java.io.IOException;

public class FileContentDeserializer
extends StdDeserializer<FileContent> {
    public FileContentDeserializer() {
        this((Class<?>)null);
    }

    public FileContentDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public FileContent deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode mimeType = node.get("mimeType");
        JsonNode name = node.get("name");
        JsonNode bytes = node.get("bytes");
        if (bytes != null) {
            return new FileWithBytes(mimeType != null ? mimeType.asText() : null, name != null ? name.asText() : null, bytes.asText());
        }
        if (node.has("uri")) {
            return new FileWithUri(mimeType != null ? mimeType.asText() : null, name != null ? name.asText() : null, node.get("uri").asText());
        }
        throw new IOException("Invalid file format: missing 'bytes' or 'uri'");
    }
}

