/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.util;

public class MathUtils {
    static int EXP2F_TABLE_BITS = 5;
    static int N = 32;
    static double InvLn2N = 1.4426950408889634 * (double)N;
    protected static long[] T = new long[]{0x3FF0000000000000L, 4607140297302181236L, 4607100335213349135L, 4607062579818421073L, 4607027079437701499L, 4606993883449571754L, 4606963042313658936L, 4606934607594512097L, 4606908631985796885L, 4606885169335019979L, 4606864274668794914L, 4606846004218661165L, 4606830415447468583L, 4606817567076339586L, 4606807519112221737L, 4606800332876043653L, 4606796071031487437L, 4606794797614391156L, 4606796578062795143L, 4606801479247646227L, 4606809569504174299L, 4606820918663955941L, 4606835598087680144L, 4606853680698631517L, 4606875241016906669L, 4606900355194379847L, 4606929101050434204L, 4606961558108475497L, 4606997807633245319L, 4607037932668951391L, 4607082018078232794L, 4607130150581978432L};
    protected static double[] C = new double[]{0.05550361559341535 / (double)N / (double)N / (double)N, 0.2402284522445722 / (double)N / (double)N, 0.6931471806916203 / (double)N};

    public static float expf(float x) {
        double z = InvLn2N * (double)x;
        double kd = Math.round(z);
        long ki = (long)kd;
        double r = z - kd;
        int index = ki % (long)N >= 0L ? (int)(ki % (long)N) : (int)(ki % (long)N) + N;
        long t = T[index];
        double s = Double.longBitsToDouble(t += ki << 52 - EXP2F_TABLE_BITS);
        z = C[0] * r + C[1];
        double r2 = r * r;
        double y = C[2] * r + 1.0;
        y = z * r2 + y;
        return (float)(y *= s);
    }

    public static int argmax(double[] d) {
        int argmax = 0;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < d.length; ++i) {
            if (!(max < d[i])) continue;
            max = d[i];
            argmax = i;
        }
        return argmax;
    }

    public static double[] softmax(double[] x) {
        int i;
        double norm = 0.0;
        double infiniteExpCount = 0.0;
        for (i = 0; i < x.length; ++i) {
            x[i] = Math.exp(x[i]);
            if (Double.isInfinite(x[i])) {
                infiniteExpCount += 1.0;
            }
            norm += x[i];
        }
        if (infiniteExpCount > 0.0) {
            for (i = 0; i < x.length; ++i) {
                x[i] = Double.isInfinite(x[i]) ? 1.0 / infiniteExpCount : 0.0;
            }
        } else {
            i = 0;
            while (i < x.length) {
                int n = i++;
                x[n] = x[n] / norm;
            }
        }
        return x;
    }

    public static double[] softmax32(double[] x) {
        int i;
        float max = (float)x[0];
        double norm = 0.0;
        for (i = 1; i < x.length; ++i) {
            max = Math.max((float)x[i], max);
        }
        for (i = 0; i < x.length; ++i) {
            x[i] = MathUtils.expf((float)x[i] - max);
            norm += (double)((float)x[i]);
        }
        for (i = 0; i < x.length; ++i) {
            x[i] = (float)x[i] / (float)norm;
        }
        return x;
    }

    public static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static float sigmoid32(double x) {
        return 1.0f / (1.0f + MathUtils.expf(-((float)x)));
    }
}

