/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.rpc;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpRequest;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.auth.AuthenticationException;
import com.dataiku.dss.shadelib.org.apache.http.auth.Credentials;
import com.dataiku.dss.shadelib.org.apache.http.auth.UsernamePasswordCredentials;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPut;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.impl.auth.BasicScheme;
import com.google.common.base.Preconditions;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;

public class APIKeyAuthAPIClient
extends InternalAPIClient {
    protected final String apiKey;
    private static Logger logger = Logger.getLogger((String)"dku.api.intercom.client");

    public APIKeyAuthAPIClient(String baseURI, String apiKey, boolean trustAllSSLCertificates) {
        super(baseURI, null, trustAllSSLCertificates);
        this.apiKey = (String)Preconditions.checkNotNull((Object)StringUtils.nullIfBlank((String)apiKey), (Object)"API key is missing");
    }

    public APIKeyAuthAPIClient(String baseURI, String apiKey, boolean trustAllSSLCertificates, ProxySettings proxySettings, int connectTimeout, int socketTimeout) {
        super(baseURI, null, trustAllSSLCertificates, proxySettings, connectTimeout, socketTimeout);
        this.apiKey = (String)Preconditions.checkNotNull((Object)StringUtils.nullIfBlank((String)apiKey), (Object)"API key is missing");
    }

    protected void setAuth(HttpRequest method) {
        try {
            method.setHeader(new BasicScheme().authenticate((Credentials)new UsernamePasswordCredentials(this.apiKey, ""), method, null));
        }
        catch (AuthenticationException e) {
            throw new Error("impossible", e);
        }
    }

    @Override
    protected HttpGet newGet(String path) {
        HttpGet get = new HttpGet(this.baseURI + "/" + path);
        this.setAuth((HttpRequest)get);
        this.setAdditionalHeadersInRequest((HttpRequestBase)get);
        return get;
    }

    @Override
    protected HttpPost newPost(String path) {
        HttpPost post = new HttpPost(this.baseURI + "/" + path);
        this.setAuth((HttpRequest)post);
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    @Override
    protected HttpPut newPut(String path) {
        HttpPut post = new HttpPut(this.baseURI + "/" + path);
        this.setAuth((HttpRequest)post);
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    @Override
    protected HttpDelete newDelete(String path) {
        HttpDelete post = new HttpDelete(this.baseURI + "/" + path);
        this.setAuth((HttpRequest)post);
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    protected String getPossibleBadInfraHint() {
        return "";
    }

    private IOException handle404or405(HttpResponse resp, int code) throws IOException {
        logger.warn((Object)("Got response code " + code));
        String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        return new IOException("Unexpected error " + code + " on command" + this.getPossibleBadInfraHint() + "\n---\nError :" + s);
    }

    private IOException handleJsonParseException(Exception e, int code) {
        logger.error((Object)("Got response code " + code + " but incorrect JSON"), (Throwable)e);
        return new IOException("Command returned unexpected JSON data" + this.getPossibleBadInfraHint(), e);
    }

    @Override
    public <T> T handleJSONResp(HttpResponse resp, Class<T> ofClazz) throws IOException {
        return this.handleJSONResp(resp, ofClazz, HTTPClientUtils::handleAPIError);
    }

    @Override
    public <T> T handleJSONResp(HttpResponse resp, Class<T> ofClazz, HTTPClientUtils.ApiErrorHandler errorHandler) throws IOException {
        int code = resp.getStatusLine().getStatusCode();
        if (code == 404 || code == 405) {
            throw this.handle404or405(resp, code);
        }
        try {
            return super.handleJSONResp(resp, ofClazz, errorHandler);
        }
        catch (com.dataiku.dss.shadelib.com.google.gson.JsonSyntaxException | JsonSyntaxException e) {
            throw this.handleJsonParseException((Exception)e, code);
        }
    }

    @Override
    public <T> T handleJSONResp(HttpResponse resp, TypeToken<T> ofClazz) throws IOException {
        int code = resp.getStatusLine().getStatusCode();
        if (code == 404 || code == 405) {
            throw this.handle404or405(resp, code);
        }
        try {
            return super.handleJSONResp(resp, ofClazz);
        }
        catch (com.dataiku.dss.shadelib.com.google.gson.JsonSyntaxException | JsonSyntaxException e) {
            throw this.handleJsonParseException((Exception)e, code);
        }
    }

    @Override
    public String handleStringResp(HttpResponse resp) throws IOException {
        int code = resp.getStatusLine().getStatusCode();
        if (code == 404 || code == 405) {
            throw this.handle404or405(resp, code);
        }
        return super.handleStringResp(resp);
    }
}

