/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DkuBackendProfilingService;
import com.dataiku.dip.utils.DKULogger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class CleanPerformanceProfiles
implements Job {
    @Autowired
    private DkuBackendProfilingService<?> backendProfilingService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.maintenance.profiling");

    public CleanPerformanceProfiles() {
        SpringUtils.getInstance().autowire(this);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        logger.info((Object)"Cleaning old performance profiles");
        long cleanProfilesAfterMs = 1000L * (long)DKUApp.getParams().getIntParam("dku.maintenance.profiling.cleanAfterSeconds", Integer.valueOf(604800));
        this.backendProfilingService.listProfiles().stream().filter(profile -> !profile.active).filter(profile -> profile.date + cleanProfilesAfterMs < System.currentTimeMillis()).forEach(profile -> {
            try {
                this.backendProfilingService.deleteProfile(profile.id);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to delete profile " + profile.id), (Throwable)e);
            }
        });
    }
}

