/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.SanityCheckDAO;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureServiceBase;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SanityCheckService {
    @Autowired
    FutureServiceBase futureService;
    @Autowired
    SanityCheckDAO sanityCheckDAO;
    @Autowired
    List<SanityCheckDetectorBase> detectors;
    private Set<String> exclusionList;
    private AuthCtx owner;
    public FutureResponse<InfoMessage.InfoMessages> runningJob;
    public static DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck");

    public SanityCheckDAO.SanityCheckFile getLatestRun() {
        return this.sanityCheckDAO.readIfExists().orElse(new SanityCheckDAO.SanityCheckFile());
    }

    public FutureResponse<InfoMessage.InfoMessages> run(AuthCtx owner, Set<String> exclusionList) throws Exception {
        this.exclusionList = exclusionList;
        this.owner = owner;
        this.runningJob = this.futureService.runFuture(new SanityCheckFutureThread(null, "SanityCheckThread"), 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
        return this.runningJob;
    }

    public List<InfoMessage.MessageCode> getCodes() {
        return this.detectors.stream().flatMap(detector -> detector.getCodes().stream()).collect(Collectors.toList());
    }

    class SanityCheckFutureThread
    extends FutureThreadBase<InfoMessage.InfoMessages> {
        private final InfoMessage.InfoMessages messages;
        private final List<Future<InfoMessage.InfoMessages>> futures;

        public SanityCheckFutureThread(String tenantId, String jobIdPrefix) {
            super(tenantId, jobIdPrefix);
            this.messages = new InfoMessage.InfoMessages();
            this.futures = new ArrayList<Future<InfoMessage.InfoMessages>>();
        }

        @Override
        public FuturePayload getPayload() {
            return FuturePayload.newSimple("instance-sanity-check", "Instance sanity check");
        }

        @Override
        public double getDangerosity() {
            return 0.0;
        }

        @Override
        public InfoMessage.InfoMessages getResult() {
            return this.messages;
        }

        @Override
        public void execute() throws Exception {
            ExecutorService es = Executors.newFixedThreadPool(DKUApp.getParams().getIntParam("dku.sanitycheck.maxConcurrentThreads", Integer.valueOf(4)));
            try (FutureAborter.AutoCloseableAbortHook aborting = FutureAborter.pushAutoCloseableHook(es::shutdownNow);){
                SanityCheckService.this.detectors.forEach(detector -> this.futures.add(es.submit(() -> {
                    logger.debugV("Starting analysis of detector %s", new Object[]{detector.getClass().getSimpleName()});
                    InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
                    try {
                        infoMessages.mergeFrom((InfoMessage.InfoMessages)detector.runAnalysis(SanityCheckService.this.exclusionList));
                    }
                    catch (Exception e) {
                        try {
                            logger.errorV((Throwable)e, "Detector %s failed with an exception", new Object[]{detector.getClass().getSimpleName()});
                            infoMessages.addMessage(detector.createFatalMessage(e));
                        }
                        catch (Throwable throwable) {
                            logger.debugV("Finished analysis of detector %s", new Object[]{detector.getClass().getSimpleName()});
                            throw throwable;
                        }
                        logger.debugV("Finished analysis of detector %s", new Object[]{detector.getClass().getSimpleName()});
                    }
                    logger.debugV("Finished analysis of detector %s", new Object[]{detector.getClass().getSimpleName()});
                    return infoMessages;
                })));
                for (Future<InfoMessage.InfoMessages> f : this.futures) {
                    this.messages.mergeFrom(f.get());
                }
                es.shutdown();
                SanityCheckService.this.runningJob = null;
                SanityCheckService.this.sanityCheckDAO.writeResult(this.messages);
            }
        }

        @Override
        public String getOwnerIdentifier() {
            return SanityCheckService.this.owner.getIdentifier();
        }

        @Override
        public void preExecute() {
        }

        @Override
        public SmartLogTail getLog() {
            SmartLogTail smartLogTail = new SmartLogTail();
            long ended = new ArrayList<Future<InfoMessage.InfoMessages>>(this.futures).stream().filter(Future::isDone).count();
            smartLogTail.appendLine("Detectors in progress: " + ((long)this.futures.size() - ended));
            smartLogTail.appendLine("Finished detectors: " + ended);
            return smartLogTail;
        }
    }
}

