/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.ui;

import com.dataiku.common.server.APIError;
import com.dataiku.gh.core.models.ui.UploadedFileDescException;
import com.dataiku.gh.core.models.uploaded_files.UploadedFileDesc;
import com.dataiku.gh.core.utils.Either;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.List;
import java.util.stream.Collectors;

@UIModel
public class UIGetUploadedFileDescsResult {
    public final List<UploadedFileDesc> uploadedFileDescs;
    public final List<UploadedFileDescAPIError> errors;

    private UIGetUploadedFileDescsResult(List<UploadedFileDesc> uiArtifacts, List<UploadedFileDescAPIError> errors) {
        this.uploadedFileDescs = uiArtifacts;
        this.errors = errors;
    }

    public static <E extends Exception> UIGetUploadedFileDescsResult build(List<Either<UploadedFileDescException, UploadedFileDesc>> uploadedFileDescOrExceptions) {
        List<UploadedFileDesc> uiArtifacts = uploadedFileDescOrExceptions.stream().filter(Either::isRight).map(Either::getRight).collect(Collectors.toList());
        List<UploadedFileDescAPIError> errors = uploadedFileDescOrExceptions.stream().filter(Either::isLeft).map(item -> UploadedFileDescAPIError.build((UploadedFileDescException)item.getLeft())).collect(Collectors.toList());
        return new UIGetUploadedFileDescsResult(uiArtifacts, errors);
    }

    public static class UploadedFileDescAPIError {
        public final String uploadedFileId;
        public final APIError error;

        private UploadedFileDescAPIError(String uploadedFileId, Exception exception) {
            this.uploadedFileId = uploadedFileId;
            this.error = new APIError((Throwable)exception, false);
        }

        public static UploadedFileDescAPIError build(UploadedFileDescException uploadedFileDescException) {
            return new UploadedFileDescAPIError(uploadedFileDescException.uploadedFileId, uploadedFileDescException.exception);
        }
    }
}

