/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.actions;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.actions.InstanceAction;
import com.dataiku.gh.core.models.blueprints.Action;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.services.actions.IActionService;
import com.dataiku.gh.core.services.actions.IInstanceActionsDataService;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionService;
import com.dataiku.gh.core.services.python_execution.artifact_action.ArtifactActionScriptResponse;
import com.dataiku.gh.core.services.python_execution.artifact_action.ArtifactActionScriptSuccess;
import com.dataiku.gh.core.services.python_execution.instance_action.ActionScriptResponse;
import com.dataiku.gh.core.services.python_execution.instance_action.ActionScriptSuccess;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActionService
implements IActionService {
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IPythonExecutionService pythonExecutionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IInstanceActionsDataService instanceActionsDataService;

    @Override
    @GHReadonlyTransaction
    public ArtifactActionScriptSuccess runArtifactAction(AuthCtx authCtx, String artifactId, String actionId, JsonObject params) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact);
        this.checkPermissionsService.checkArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, artifactId);
        Action potentialAction = enrichedArtifact.blueprintVersion.actions.get(actionId);
        if (potentialAction == null) {
            throw new ValidationException("Requested artifact action id `" + actionId + "` on artifact id `" + enrichedArtifact.artifact.id + "` not found");
        }
        ArtifactActionScriptResponse response = this.pythonExecutionService.applyArtifactAction(actionId, potentialAction, enrichedArtifact, authCtx.getIdentifier(), params);
        return new ArtifactActionScriptSuccess(response.message);
    }

    @Override
    @GHReadonlyTransaction
    public ActionScriptSuccess runInstanceAction(AuthCtx authCtx, String actionId, JsonObject params) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        InstanceAction potentialAction = this.instanceActionsDataService.getInstanceActionOrNull(actionId);
        if (potentialAction == null) {
            throw new ValidationException("Requested action id `" + actionId + "` not found");
        }
        ActionScriptResponse response = this.pythonExecutionService.applyInstanceAction(potentialAction, authCtx.getIdentifier(), params);
        return new ActionScriptSuccess(response.message);
    }

    @Override
    @GHReadonlyTransaction
    public List<InstanceAction> listInstanceActions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        List<InstanceAction> actions = this.instanceActionsDataService.getInstanceActions();
        if (!this.permissionsService.isGovernArchitect(authCtx)) {
            actions.forEach(ac -> {
                ac.script = "";
            });
        }
        return actions;
    }
}

