/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.configuration;

import com.dataiku.gh.core.models.configuration.GovernConfiguration;
import com.dataiku.gh.core.services.configuration.IGovernConfigurationDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.configuration.IGovernConfigurationDAO;
import java.io.IOException;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GovernConfigurationDataService
implements IGovernConfigurationDataService {
    @Autowired
    private IGovernConfigurationDAO governConfigurationDAO;

    @Override
    @GHMandatoryTransaction
    public GovernConfiguration getConfigurationItem(String itemId) throws IOException {
        return (GovernConfiguration)this.governConfigurationDAO.getMandatory(itemId);
    }

    @Override
    @GHMandatoryTransaction
    @Nullable
    public GovernConfiguration getConfigurationItemOrNull(String itemId) throws IOException {
        return (GovernConfiguration)this.governConfigurationDAO.getOrNull(itemId);
    }

    @Override
    @GHMandatoryTransaction
    public GovernConfiguration upsertConfigurationItem(GovernConfiguration governConfiguration) throws IOException {
        GovernConfiguration oldValue = (GovernConfiguration)this.governConfigurationDAO.getOrNull(governConfiguration.getId());
        if (oldValue != null) {
            this.governConfigurationDAO.save(governConfiguration);
        } else {
            this.governConfigurationDAO.create(governConfiguration);
        }
        return (GovernConfiguration)this.governConfigurationDAO.getMandatory(governConfiguration.getId());
    }

    @Override
    @GHMandatoryTransaction
    public void lockConfigurationItem(String itemId) throws IOException {
        this.governConfigurationDAO.lock(itemId);
    }
}

