/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.notifications;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.DkuGroup;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.base.Stopwatch;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.notifications.NotificationContext;
import com.dataiku.gh.core.models.notifications.common.ArtifactTemplateContext;
import com.dataiku.gh.core.models.roles.permissions.EffectivePermissionsItem;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.mail.IEmailService;
import com.dataiku.gh.core.services.notifications.INotificationsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsService;
import com.dataiku.gh.core.services.utils.ITransactionHandler;
import com.dataiku.gh.core.services.utils.ITransactionScope;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.server.services.GeneralSettingsService;
import com.dataiku.gh.server.services.UsersService;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationsService
implements INotificationsService {
    public static final String DATE_FORMAT = "MMM dd, yyyy";
    public static final String DATE_TIME_FORMAT = "MMM dd, yyyy hh:mma (z)";
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_30);
    private final ExecutorService threadPool = Executors.newCachedThreadPool();
    @Autowired
    private ITransactionHandler transactionHandler;
    @Autowired
    private IEmailService emailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private ISubscriptionsService subscriptionsService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.notifications");

    @PostConstruct
    public void init() throws IOException {
        this.cfg.setDirectoryForTemplateLoading(DKUApp.getResourceFile((String[])new String[]{"govern", "mails"}));
        this.cfg.setLocale(Locale.ENGLISH);
        this.cfg.setDateFormat(DATE_FORMAT);
        this.cfg.setDateTimeFormat(DATE_TIME_FORMAT);
    }

    @Override
    public void sendEmailToUsers(AuthCtx authCtx, NotificationContext notificationContext, Set<String> userLogins) throws IOException {
        if (this.emailService.emailChannelActivated()) {
            ExplicitSender sender = new ExplicitSender(authCtx, notificationContext, userLogins);
            this.threadPool.submit(sender);
        } else {
            logger.debug(() -> "Email channel disabled or not configured, no mail sent");
        }
    }

    @Override
    public void sendEmailToSubscribers(AuthCtx authCtx, NotificationContext notificationContext, String artifactId, Set<String> userBlacklist) throws IOException {
        if (this.emailService.emailChannelActivated()) {
            SubscriberSender sender = new SubscriberSender(authCtx, notificationContext, artifactId, userBlacklist);
            this.threadPool.submit(sender);
        } else {
            logger.debug(() -> "Email channel disabled or not configured, no mail sent");
        }
    }

    private void sendEmail(AuthCtx authCtx, Template template, NotificationContext context, String to) throws Exception {
        StringWriter w = new StringWriter();
        template.process((Object)context.buildTemplateModel(), (Writer)w);
        String[] email = w.toString().split("\n", 2);
        String subject = email[0];
        String body = email[1];
        this.emailService.send(authCtx, to, subject, body);
        logger.debug(() -> "Email sent: " + to);
    }

    private Map<String, Pair<UsersDAO.User, Boolean>> loadUserLoginToUserMap() throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            List<? extends DkuGroup> groups = this.usersService.listGroups();
            Map<String, Pair<UsersDAO.User, Boolean>> map = this.usersService.listUsersInternalUnsafeEnabledOnly().stream().map(u -> {
                UsersDAO.GroupPermissions computed = UsersDAO.GroupPermissions.baseGroupPermissionsForUnion();
                for (DkuGroup group : groups) {
                    if (!u.groups.contains(group.getName())) continue;
                    computed = computed.union((UsersDAO.Group)group);
                }
                return new Pair(u, (Object)computed.isGovernArchitect());
            }).collect(Collectors.toMap(p -> ((UsersDAO.User)p.first).login, Function.identity()));
            return map;
        }
    }

    private String loadGhExternalUrlOrNull() throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            String string = (String)StringUtils.defaultIfBlank((CharSequence)this.generalSettingsService.read().studioExternalUrl, null);
            return string;
        }
    }

    private class ExplicitSender
    extends Sender {
        ExplicitSender(AuthCtx authCtx, NotificationContext notificationContext, Set<String> recipientsLogins) {
            super(authCtx, notificationContext);
            this.recipientsLogins = recipientsLogins;
        }

        @Override
        void prepareSending() {
        }
    }

    private class SubscriberSender
    extends Sender {
        String artifactId;
        Set<String> userBlacklist;
        Map<String, EnrichedArtifact> subscribersWithReason;

        SubscriberSender(AuthCtx authCtx, NotificationContext notificationContext, String artifactId, Set<String> userBlacklist) {
            super(authCtx, notificationContext);
            this.artifactId = artifactId;
            this.userBlacklist = userBlacklist;
        }

        @Override
        void prepareSending() throws IOException {
            Stopwatch stopwatch = Stopwatch.createStarted();
            logger.debug(() -> "Notification preparation started");
            this.subscribersWithReason = NotificationsService.this.subscriptionsService.getSubscribersAndReason(this.artifactId);
            this.recipientsLogins = this.subscribersWithReason.keySet().stream().filter(user -> !this.userBlacklist.contains(user)).collect(Collectors.toSet());
            this.notificationContext.enrichWithSubscriptionReasons(this.subscribersWithReason);
            this.notificationContext.setNotificationArtifact(NotificationsService.this.artifactsDataService.getArtifact(this.artifactId));
            logger.debug(() -> String.format("Notification preparation lasted %s ms", stopwatch.elapsed().toMillis()));
        }
    }

    private abstract class Sender
    implements Runnable {
        AuthCtx authCtx;
        NotificationContext notificationContext;
        Set<String> recipientsLogins;

        Sender(AuthCtx authCtx, NotificationContext notificationContext) {
            this.notificationContext = notificationContext;
            this.authCtx = authCtx;
        }

        @Override
        public void run() {
            try (ITransactionScope ts = NotificationsService.this.transactionHandler.openNewReadTransaction();){
                this.prepareSending();
                this.enrichAndSend();
                ts.commit();
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to send the notification email to users", e);
            }
        }

        abstract void prepareSending() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void enrichAndSend() throws IOException {
            Stopwatch stopwatch = Stopwatch.createStarted();
            logger.debug(() -> "Notification sending started");
            try {
                Template template = NotificationsService.this.cfg.getTemplate(this.notificationContext.getEmailTemplatePath());
                List<String> notificationArtifactIds = this.notificationContext.getArtifactContextsToEnrichWithBreadcrumb().stream().map(context -> context.getAssociatedEnrichedArtifact().artifact.id).toList();
                logger.debug(() -> "Enriching notification with information coming from artifacts: " + String.join((CharSequence)",", notificationArtifactIds));
                List<ArtifactTemplateContext> artifactsToGetBreadcrumbsFor = this.notificationContext.getArtifactContextsToEnrichWithBreadcrumb();
                for (ArtifactTemplateContext artifactContext : artifactsToGetBreadcrumbsFor) {
                    artifactContext.setBreadcrumb(NotificationsService.this.artifactsDataService.getArtifactAndAncestry(artifactContext.getAssociatedEnrichedArtifact().artifact.id));
                }
                String ghUrl = NotificationsService.this.loadGhExternalUrlOrNull();
                if (ghUrl != null) {
                    this.notificationContext.setGhUrl(ghUrl);
                }
                Map<String, Pair<UsersDAO.User, Boolean>> loginToUserMapping = NotificationsService.this.loadUserLoginToUserMap();
                Map recipientsMapping = this.recipientsLogins.stream().filter(loginToUserMapping::containsKey).map(loginToUserMapping::get).filter(u -> StringUtils.isNotBlank((CharSequence)((UsersDAO.User)u.first).email)).collect(Collectors.toMap(u -> ((UsersDAO.User)u.first).login, Function.identity()));
                this.notificationContext.enrichWithUsers(loginToUserMapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (UsersDAO.User)((Pair)e.getValue()).first)));
                HashMap<String, Map<String, EffectivePermissionsItem>> permissionMapping = new HashMap<String, Map<String, EffectivePermissionsItem>>();
                for (EnrichedArtifact enrichedArtifact : this.notificationContext.retrieveAllEnrichedArtifactChildren()) {
                    if (permissionMapping.containsKey(enrichedArtifact.artifact.id)) continue;
                    permissionMapping.put(enrichedArtifact.artifact.id, NotificationsService.this.rolesAndPermissionsService.computeAllUsersEffectivePermissionsItemAtExistingArtifactLevel(enrichedArtifact, recipientsMapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Boolean)((Pair)e.getValue()).second))));
                }
                this.notificationContext.enrichWithPermissions(permissionMapping);
                logger.debug(() -> String.format("Sending notification to %s users", recipientsMapping.values().size()));
                for (Pair userInfo : recipientsMapping.values()) {
                    UsersDAO.User user = (UsersDAO.User)userInfo.first;
                    try {
                        String userEmail = user.getEmail();
                        if (StringUtils.isBlank((CharSequence)userEmail)) {
                            logger.warnV("User '%s' does not have an email address set", new Object[]{user.getLogin()});
                            continue;
                        }
                        this.notificationContext.enrichWithCurrentUserLogin(user.getLogin());
                        if (this.notificationContext.userShouldReceiveNotification()) {
                            NotificationsService.this.sendEmail(this.authCtx, template, this.notificationContext, userEmail);
                            continue;
                        }
                        logger.warnV("User '%s' does not have read permission on artifact", new Object[]{user.getLogin()});
                    }
                    catch (Exception e2) {
                        logger.errorV((Throwable)e2, "Unable to send an email to user '%s'", new Object[]{user.getLogin()});
                    }
                }
            }
            finally {
                logger.debug(() -> String.format("Notification sending lasted %s ms", stopwatch.elapsed().toMillis()));
            }
        }
    }
}

