/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.time_series.relationships;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.relationships.TimeSeriesRelationship;
import com.dataiku.gh.core.storage.sql.AbstractSQLRelationshipDAO;
import com.dataiku.gh.core.storage.sql.model.QTimeSeries;
import com.dataiku.gh.core.storage.sql.model.QTimeSeriesRelationships;
import com.dataiku.gh.core.storage.sql.model.QTimeSeriesRelationshipsHistory;
import com.dataiku.gh.core.storage.sql.time_series.relationships.TimeSeriesRelationshipsRowMapper;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.dataiku.gh.core.storage.time_series.ITimeSeriesRelationshipDAO;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLInsertClause;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class TimeSeriesRelationshipDAO
extends AbstractSQLRelationshipDAO<TimeSeriesRelationship>
implements ITimeSeriesRelationshipDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.time-series.relationships");
    @Autowired
    private TimeSeriesRelationshipsRowMapper timeSeriesRelationshipsRowMapper;

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected EntityType getEntityType() {
        return EntityType.TIME_SERIES_RELATIONSHIP;
    }

    @Override
    protected void sqlCreateRevision(TimeSeriesRelationship timeSeriesRelationship, HistoryRevision revision) throws DataStoreIOException {
        SQLInsertClause insertHistory = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QTimeSeriesRelationshipsHistory.timeSeriesRelationshipsHistory).set(QTimeSeriesRelationshipsHistory.timeSeriesRelationshipsHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QTimeSeriesRelationshipsHistory.timeSeriesRelationshipsHistory.timeSeriesRelationshipJson, QueryBuilderUtils.toJsonb(timeSeriesRelationship));
        int ret = this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insertHistory);
        if (ret != 1) {
            throw new DataStoreIOException("Cannot create history item");
        }
    }

    @Override
    protected RelationalPath<?> getRelationshipTable() {
        return QTimeSeriesRelationships.timeSeriesRelationships;
    }

    @Override
    protected RelationalPath<?> getEntityTable() {
        return QTimeSeries.timeSeries;
    }

    @Override
    protected StringExpression getEntityKey() {
        return QTimeSeries.timeSeries.timeSeriesId;
    }

    @Override
    protected StringExpression getRelationshipEntityKey() {
        return QTimeSeriesRelationships.timeSeriesRelationships.timeSeriesRelationshipTimeSeriesId;
    }

    @Override
    protected StringExpression getArtifactIdKey() {
        return QTimeSeriesRelationships.timeSeriesRelationships.timeSeriesRelationshipArtifactId;
    }

    @Override
    protected SimplePath<Object> getRelationshipJson() {
        return QTimeSeriesRelationships.timeSeriesRelationships.timeSeriesRelationshipJson;
    }

    @Override
    protected RowMapper<TimeSeriesRelationship> getRowMapper() {
        return this.timeSeriesRelationshipsRowMapper;
    }
}

