/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.reports;

import com.dataiku.dip.reports.ReportsManagementService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.activity.GlobalUsageSummaryBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UsageSummaryReportsBuilder {
    @Autowired
    private TransactionService transactionService;
    private static final Logger logger = Logger.getLogger((String)"dku.server.datasets");

    public UsageSummaryReportsBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public List<ReportsManagementService.ReadyReport> getReports() throws IOException {
        ArrayList<ReportsManagementService.ReadyReport> ret = new ArrayList<ReportsManagementService.ReadyReport>();
        GlobalUsageSummaryBuilder gusb = new GlobalUsageSummaryBuilder();
        logger.info((Object)"Building global report");
        try {
            ret.add(new ReportsManagementService.ReadyReport("global-usage-summary", JSON.toJsonObject((Object)gusb.buildGlobalSummary(false), (String[])new String[0])));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to build global report", (Throwable)e);
        }
        return ret;
    }

    private static ReportsManagementService.ReadyReport buildReadyReport(String type, String key, JsonObject reportData) {
        logger.info((Object)("Building " + type + " report for " + key));
        return new ReportsManagementService.ReadyReport(type + "-usage-summary", type + "-usage-summary-" + key, type + "-usage-summary-" + DKUtils.md5Base64((String)key), reportData);
    }
}

