/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.security;

import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.NotLoggedInException;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.UserBasicService;
import com.dataiku.gh.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.gh.security.model.ConfigurablePublicAPIKey;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKeyWithGroups;
import com.dataiku.gh.security.model.LegacyGlobalScopePublicAPIKey;
import com.dataiku.gh.security.model.PersonalPublicAPIKey;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import com.dataiku.gh.server.services.UsersService;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GHAuthCtx
extends AuthCtx {
    public static final String PERMISSION_DENIED_USER_DISABLED_MESSAGE = "Permission denied: user '%s' is disabled";
    public static final String INTERNAL_COLLECTION_AUTH_NAME = "dku-internal-collection";
    public static final String NO_AUTH_IDENTIFIER = "no:auth";
    private UsersDAO.GroupPermissions userGroupLevelPermissions;

    private GHAuthCtx(AuthCtx.AuthSource authSource) {
        super(authSource);
    }

    public GHAuthCtx() {
    }

    public GHAuthCtx(GHAuthCtx authCtx) {
        super((AuthCtx)authCtx);
        this.userGroupLevelPermissions = authCtx.userGroupLevelPermissions != null ? authCtx.userGroupLevelPermissions.deepCopy() : null;
    }

    public GHAuthCtx deepCopy() {
        return new GHAuthCtx(this);
    }

    public PublicAPIKey getAsPublicAPIKey() {
        assert (this.authSource == AuthCtx.AuthSource.PERSONAL_API_KEY || this.isConfigurableAPIKey());
        return (PublicAPIKey)this.apiKey;
    }

    private void setAndSanitizeKey(PublicAPIKey apiKey) {
        this.apiKey = (APIKeyBase)JSON.deepCopy((Object)apiKey);
        this.apiKey.key = null;
    }

    public GHAuthCtx refresh() throws IOException, DKUSecurityException {
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();){
            GHAuthCtx newAuthCtx;
            switch (this.getAuthSource()) {
                case USER_FROM_UI: {
                    newAuthCtx = GHAuthCtx.forUserFromUI((UsersService)SpringUtils.getBean(UsersService.class), this.getAssociatedDSSUserMand(), this.userAccessToken);
                    break;
                }
                case CONFIGURABLE_API_KEY_PROJECT: {
                    throw new Error("unreachable");
                }
                case PERSONAL_API_KEY: 
                case CONFIGURABLE_API_KEY_GLOBAL: 
                case GLOBAL_API_KEY_WITH_GROUPS: {
                    if (this.apiKey == null) {
                        throw new NotLoggedInException("Invalid API key");
                    }
                    PublicAPIKeysService apiKeysService = (PublicAPIKeysService)SpringUtils.getBean(PublicAPIKeysService.class);
                    PublicAPIKey refreshedApiKey = apiKeysService.getKeyById(this.apiKey.id);
                    if (refreshedApiKey == null) {
                        throw new NotLoggedInException("Invalid API key");
                    }
                    newAuthCtx = GHAuthCtx.forAPIKey(refreshedApiKey);
                    break;
                }
                default: {
                    GHAuthCtx gHAuthCtx = this;
                    return gHAuthCtx;
                }
            }
            newAuthCtx.via = new ArrayList(this.via);
            newAuthCtx.parentUser = this.parentUser;
            newAuthCtx.immediateParent = this.immediateParent != null ? this.immediateParent.refresh() : null;
            GHAuthCtx gHAuthCtx = newAuthCtx;
            return gHAuthCtx;
        }
    }

    public ConfigurablePublicAPIKey getAsConfigurableAPIKey() {
        assert (this.isConfigurableAPIKey());
        return (ConfigurablePublicAPIKey)this.apiKey;
    }

    public boolean isConfigurableAPIKey() {
        return this.authSource == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_GLOBAL || this.authSource == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_PROJECT || this.authSource == AuthCtx.AuthSource.GLOBAL_API_KEY_WITH_GROUPS;
    }

    public String getAssociatedDSSUser() {
        switch (this.authSource) {
            case CONFIGURABLE_API_KEY_PROJECT: 
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case GLOBAL_API_KEY_WITH_GROUPS: 
            case NONE: {
                return null;
            }
            case PERSONAL_API_KEY: {
                assert (this.apiKey != null);
                assert (this.apiKey instanceof PersonalPublicAPIKey);
                PersonalPublicAPIKey ppkey = (PersonalPublicAPIKey)this.apiKey;
                assert (ppkey.user != null);
                return ppkey.user;
            }
            case USER_FROM_UI: {
                assert (this.realUserLogin != null);
                return this.realUserLogin;
            }
        }
        throw new Error("unreachable");
    }

    public String getAssociatedDSSUserMand() throws DKUSecurityException {
        String a = this.getAssociatedDSSUser();
        if (a == null) {
            throw new DKUSecurityException("No associated user in this authentication context (source=" + String.valueOf(this.authSource) + ")");
        }
        return a;
    }

    public String getAssociatedDSSUserMandNoExc() {
        String a = this.getAssociatedDSSUser();
        if (a == null) {
            throw new Error("No associated user in this authentication context (source=" + String.valueOf(this.authSource) + ")");
        }
        return a;
    }

    public String getDSSUserForImpersonation() {
        switch (this.authSource) {
            case CONFIGURABLE_API_KEY_PROJECT: 
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case GLOBAL_API_KEY_WITH_GROUPS: {
                return this.getAsConfigurableAPIKey().dssUserForImpersonation;
            }
            case PERSONAL_API_KEY: {
                PersonalPublicAPIKey ppkey = (PersonalPublicAPIKey)this.apiKey;
                assert (ppkey.user != null);
                return ppkey.user;
            }
            case USER_FROM_UI: {
                assert (this.realUserLogin != null);
                return this.realUserLogin;
            }
            case NONE: {
                throw new Error("should not try to impersonate for NONE auth context");
            }
        }
        throw new Error("unreachable");
    }

    public static GHAuthCtx fakeForTests(String login) {
        return new GHAuthCtx(AuthCtx.AuthSource.NONE);
    }

    public static GHAuthCtx newNone() {
        return new GHAuthCtx(AuthCtx.AuthSource.NONE);
    }

    public static GHAuthCtx migrationProcess() {
        return GHAuthCtx.newNone();
    }

    public static GHAuthCtx forUserFromUI(UsersService service, String login, String accessToken) throws IOException {
        UsersDAO.User user = service.getInternalUserOrNullUnsafe(login);
        if (user == null || !user.enabled) {
            throw new NotLoggedInException(String.format(PERMISSION_DENIED_USER_DISABLED_MESSAGE, login));
        }
        GHAuthCtx authCtx = new GHAuthCtx(AuthCtx.AuthSource.USER_FROM_UI);
        authCtx.realUserLogin = login;
        authCtx.realUserEmail = user.email;
        authCtx.userAccessToken = accessToken;
        authCtx.userGroups = Sets.newHashSet(user.groups);
        authCtx.userGroupLevelPermissions = service.getUserEffectiveGroupPermissions(user);
        authCtx.userProfile = user.userProfile;
        return authCtx;
    }

    public static GHAuthCtx forUserLogin(UsersDAO.User user) throws IOException {
        if (!user.enabled) {
            throw new NotLoggedInException(String.format(PERMISSION_DENIED_USER_DISABLED_MESSAGE, user.login));
        }
        GHAuthCtx authCtx = new GHAuthCtx(AuthCtx.AuthSource.USER_FROM_UI);
        authCtx.realUserLogin = user.login;
        authCtx.realUserEmail = user.email;
        authCtx.userGroups = Sets.newHashSet(user.groups);
        authCtx.userGroupLevelPermissions = ((UserBasicService)SpringUtils.getBean(UserBasicService.class)).getUserEffectiveGroupPermissions(user);
        authCtx.userProfile = user.userProfile;
        return authCtx;
    }

    public static GHAuthCtx forUserLoginWithoutPermissionsForTests(UsersDAO.User user) throws IOException {
        GHAuthCtx authCtx = new GHAuthCtx(AuthCtx.AuthSource.USER_FROM_UI);
        authCtx.realUserLogin = user.login;
        authCtx.realUserEmail = user.email;
        authCtx.userGroupLevelPermissions = ((UserBasicService)SpringUtils.getBean(UserBasicService.class)).getEffectiveGroupPermissions(user.groups);
        authCtx.userGroups = Sets.newHashSet(user.groups);
        authCtx.userProfile = user.userProfile;
        return authCtx;
    }

    public static GHAuthCtx forTestsWithoutInfo(String login) {
        GHAuthCtx authCtx = new GHAuthCtx(AuthCtx.AuthSource.USER_FROM_UI);
        authCtx.realUserLogin = login;
        authCtx.userGroupLevelPermissions = new UsersDAO.GroupPermissions();
        authCtx.userGroups = new HashSet();
        return authCtx;
    }

    public static GHAuthCtx fakeAdminForTests(String login) {
        GHAuthCtx authCtx = new GHAuthCtx(AuthCtx.AuthSource.USER_FROM_UI);
        authCtx.realUserLogin = login;
        authCtx.userGroupLevelPermissions = new UsersDAO.GroupPermissions().withAdmin(true);
        return authCtx;
    }

    public static GHAuthCtx internalCollectionAuth() {
        GHAuthCtx authCtx = new GHAuthCtx(AuthCtx.AuthSource.CONFIGURABLE_API_KEY_GLOBAL);
        authCtx.userGroupLevelPermissions = new UsersDAO.GroupPermissions().withAdmin(true);
        LegacyGlobalScopePublicAPIKey apiKey = new LegacyGlobalScopePublicAPIKey();
        apiKey.setGlobalPermissions(new UsersDAO.GroupPermissions().withAdmin(true));
        apiKey.id = INTERNAL_COLLECTION_AUTH_NAME;
        apiKey.label = INTERNAL_COLLECTION_AUTH_NAME;
        apiKey.description = "Internal use";
        apiKey.createdOn = System.currentTimeMillis();
        apiKey.createdBy = "Internal";
        authCtx.apiKey = apiKey;
        return authCtx;
    }

    public static GHAuthCtx internalAdminAuthWithInMemoryAPIKey() {
        GHAuthCtx authCtx = new GHAuthCtx(AuthCtx.AuthSource.CONFIGURABLE_API_KEY_GLOBAL);
        authCtx.userGroupLevelPermissions = new UsersDAO.GroupPermissions().withAdmin(true);
        authCtx.apiKey = ((PublicAPIKeysService)SpringUtils.getBean(PublicAPIKeysService.class)).getInMemoryAPIKey("Internal", INTERNAL_COLLECTION_AUTH_NAME, "");
        return authCtx;
    }

    public static GHAuthCtx forAPIKey(PublicAPIKey apiKey) throws IOException {
        if (apiKey instanceof PersonalPublicAPIKey) {
            PersonalPublicAPIKey ppkey = (PersonalPublicAPIKey)apiKey;
            GHAuthCtx authCtx = new GHAuthCtx(AuthCtx.AuthSource.PERSONAL_API_KEY);
            authCtx.setAndSanitizeKey(apiKey);
            assert (ppkey.user != null);
            UsersDAO.User user = ((UsersDAO)SpringUtils.getBean(UsersDAO.class)).getMandatoryUnsafe(ppkey.user);
            if (!user.enabled) {
                throw new NotLoggedInException(String.format(PERMISSION_DENIED_USER_DISABLED_MESSAGE, user.login));
            }
            authCtx.realUserLogin = user.login;
            authCtx.realUserEmail = user.email;
            authCtx.userGroups = Sets.newHashSet(user.groups);
            authCtx.userGroupLevelPermissions = ((UserBasicService)SpringUtils.getBean(UserBasicService.class)).getUserEffectiveGroupPermissions(user);
            authCtx.userProfile = user.userProfile;
            return authCtx;
        }
        if (apiKey instanceof LegacyGlobalScopePublicAPIKey) {
            LegacyGlobalScopePublicAPIKey globalApiKey = (LegacyGlobalScopePublicAPIKey)apiKey;
            GHAuthCtx authCtx = new GHAuthCtx(AuthCtx.AuthSource.CONFIGURABLE_API_KEY_GLOBAL);
            authCtx.setAndSanitizeKey(apiKey);
            authCtx.userGroupLevelPermissions = globalApiKey.getGlobalPermissions().deepCopy();
            return authCtx;
        }
        if (apiKey instanceof GlobalScopePublicAPIKeyWithGroups) {
            GlobalScopePublicAPIKeyWithGroups globalApiKey = (GlobalScopePublicAPIKeyWithGroups)apiKey;
            GHAuthCtx authCtx = new GHAuthCtx(AuthCtx.AuthSource.GLOBAL_API_KEY_WITH_GROUPS);
            authCtx.setAndSanitizeKey(apiKey);
            authCtx.userGroupLevelPermissions = ((UserBasicService)SpringUtils.getBean(UserBasicService.class)).getEffectiveGroupPermissions(globalApiKey.getGroups());
            authCtx.userGroups = new HashSet<String>(globalApiKey.getGroups());
            return authCtx;
        }
        throw new Error("unreachable");
    }

    public String getIdentifier() {
        switch (this.authSource) {
            case CONFIGURABLE_API_KEY_PROJECT: 
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case GLOBAL_API_KEY_WITH_GROUPS: {
                return "api:" + this.apiKey.id;
            }
            case NONE: {
                return NO_AUTH_IDENTIFIER;
            }
            case USER_FROM_UI: 
            case PERSONAL_API_KEY: {
                return this.getAssociatedDSSUser();
            }
        }
        throw new Error("unreachable");
    }

    public String getAssociatedDSSUserOrIdentifier() {
        String associated = this.getAssociatedDSSUser();
        return associated != null ? associated : this.getIdentifier();
    }

    public Set<String> getGroups() throws DKUSecurityException {
        if (!this.isGroupsAware()) {
            throw new DKUSecurityException("User needs to be able to belong to some groups");
        }
        assert (this.userGroups != null);
        return this.userGroups;
    }

    public UsersDAO.GroupPermissions getPermissions() {
        assert (this.authSource != AuthCtx.AuthSource.NONE);
        assert (this.userGroupLevelPermissions != null);
        return this.userGroupLevelPermissions;
    }

    public boolean isInGroup(String group) {
        assert (this.authSource == AuthCtx.AuthSource.USER_FROM_UI || this.authSource == AuthCtx.AuthSource.PERSONAL_API_KEY || this.authSource == AuthCtx.AuthSource.GLOBAL_API_KEY_WITH_GROUPS);
        assert (this.userGroups != null);
        return this.userGroups.contains(group);
    }

    public boolean isAdmin() {
        switch (this.authSource) {
            case CONFIGURABLE_API_KEY_PROJECT: {
                return this.getAsConfigurableAPIKey().isGlobalAdmin();
            }
            case NONE: {
                throw new SecurityException("A NONE context cannot be admin");
            }
            case USER_FROM_UI: 
            case PERSONAL_API_KEY: 
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case GLOBAL_API_KEY_WITH_GROUPS: {
                return this.getPermissions().isAdmin();
            }
        }
        throw new Error("unreachable");
    }

    public boolean isUnsafeCodeAllowed() {
        throw new Error("unreachable");
    }

    public boolean isSafeCodeAllowed() {
        throw new Error("unreachable");
    }

    public void failIfNoUnsafeCode(String reason) throws UnauthorizedException {
        throw new Error("unreachable");
    }

    public void failIfNoSafeCode(String reason) throws UnauthorizedException {
        throw new Error("unreachable");
    }

    static {
        JSON.registerAdapter(GHAuthCtx.class, (Object)new JSON.Adapter<GHAuthCtx>(){

            public GHAuthCtx deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                AuthCtx.AuthSource authSrc = (AuthCtx.AuthSource)jsonDeserializationContext.deserialize(jsonObj.get("authSource"), AuthCtx.AuthSource.class);
                GHAuthCtx base = new GHAuthCtx(authSrc);
                base.realUserLogin = (String)jsonDeserializationContext.deserialize(jsonObj.get("realUserLogin"), String.class);
                base.realUserEmail = (String)jsonDeserializationContext.deserialize(jsonObj.get("realUserEmail"), String.class);
                base.userGroups = (Set)jsonDeserializationContext.deserialize(jsonObj.get("userGroups"), new TypeToken<Set<String>>(){}.getType());
                base.userGroupLevelPermissions = (UsersDAO.GroupPermissions)jsonDeserializationContext.deserialize(jsonObj.get("userGroupLevelPermissions"), UsersDAO.GroupPermissions.class);
                base.userProfile = (String)jsonDeserializationContext.deserialize(jsonObj.get("userProfile"), String.class);
                base.via = (List)jsonDeserializationContext.deserialize(jsonObj.get("via"), JSON.StringList.class);
                base.parentUser = (String)jsonDeserializationContext.deserialize(jsonObj.get("parentUser"), String.class);
                switch (base.authSource) {
                    case PERSONAL_API_KEY: {
                        base.apiKey = (APIKeyBase)jsonDeserializationContext.deserialize(jsonObj.get("apiKey"), PersonalPublicAPIKey.class);
                        break;
                    }
                    case CONFIGURABLE_API_KEY_GLOBAL: 
                    case GLOBAL_API_KEY_WITH_GROUPS: {
                        base.apiKey = (APIKeyBase)jsonDeserializationContext.deserialize(jsonObj.get("apiKey"), AbstractGlobalScopePublicAPIKey.class);
                        break;
                    }
                    case CONFIGURABLE_API_KEY_PROJECT: {
                        throw new Error("unreachable");
                    }
                }
                return base;
            }

            public JsonElement serialize(GHAuthCtx task, Type type, JsonSerializationContext ctx) {
                return new Gson().toJsonTree((Object)task);
            }
        });
    }

    public static class CanUseAndReason {
        public boolean ok;
        public String reason;

        public static CanUseAndReason ok() {
            CanUseAndReason ret = new CanUseAndReason();
            ret.ok = true;
            return ret;
        }

        public static CanUseAndReason nok(String reason) {
            CanUseAndReason ret = new CanUseAndReason();
            ret.ok = false;
            ret.reason = reason;
            return ret;
        }
    }
}

