/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.api.admin;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.UserLastActivity;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.NoRemoteFutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.ExternalUser;
import com.dataiku.dip.security.auth.GroupDiff;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.futures.GovernActionSimpleFutureThread;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.futures.SimpleFutureThread;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.SecurityAuditService;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.dataiku.gh.server.services.UsersService;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIUsersController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private SecurityAuditService auditService;
    @Autowired
    private UserAuthenticationService userAuthenticationService;
    @Autowired
    private NoRemoteFutureService futureService;

    @AuditedCall(value={"msgType", "security-admin-users-list"})
    @RequestMapping(value={"/publicapi/admin/users"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UsersService.APIUser> listUsers(HttpServletRequest req, @RequestParam(defaultValue="false") boolean connected, @RequestParam(defaultValue="false") boolean includeSettings) throws Exception {
        List<UsersService.APIUser> allUsers;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            allUsers = this.usersService.listAPIUsers_RestrictionCheck_WithSensitive(authCtx, null, true, true, includeSettings);
        }
        ArrayList<UsersService.APIUser> users = new ArrayList<UsersService.APIUser>();
        for (UsersService.APIUser user : allUsers) {
            if (connected && user.activeWebSocketSesssions <= 0) continue;
            users.add(user);
        }
        return users;
    }

    @AuditedCall(value={"msgType", "security-admin-users-list-activity"})
    @RequestMapping(value={"/publicapi/admin/users-activity"}, method={RequestMethod.GET})
    public void listUsersActivity(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean enabledUsersOnly) throws Exception {
        List<UsersService.UIUser> uiUsers;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            uiUsers = enabledUsersOnly ? this.usersService.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx) : this.usersService.listUsersWithDisabled_RestrictionCheck_NoLeak(authCtx);
        }
        Set<String> logins = uiUsers.stream().map(uiUser -> uiUser.login).collect(Collectors.toSet());
        Map<String, UserLastActivity> usersActivity = this.usersService.getAllUsersActivity(false);
        logins.forEach(login -> {
            if (!usersActivity.containsKey(login)) {
                usersActivity.put((String)login, new UserLastActivity(login));
            }
        });
        List filteredActivity = usersActivity.entrySet().stream().filter(entry -> logins.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, filteredActivity);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/users"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.USER_CREATE)
    public void addUser(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        UsersService.UIUser user = (UsersService.UIUser)this.getRequestBodyAs(req, UsersService.UIUser.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
        }
        this.usersService.addUserAdmin_NT(user, authCtx);
        this.auditTrailService.generic("security-admin-user-create").with("login", user.login).emit();
        resp.setStatus(201);
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Created user " + user.login);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/users/actions/bulk"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.USERS_CREATE)
    public void addUsers(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        UsersService.UIUser[] users = (UsersService.UIUser[])this.getRequestBodyAs(req, UsersService.UIUser[].class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
        }
        ArrayList<UserStatus> userCreationStatuses = new ArrayList<UserStatus>();
        for (UsersService.UIUser user : users) {
            try {
                this.usersService.addUserAdmin_NT(user, authCtx);
                this.auditTrailService.generic("security-admin-user-create").with("login", user.login).emit();
                userCreationStatuses.add(new UserStatus(user.login));
            }
            catch (Exception e) {
                userCreationStatuses.add(new UserStatus(user.login, e.getMessage()));
            }
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, userCreationStatuses);
        resp.setStatus(201);
    }

    @AuditedCall(value={"msgType", "security-admin-user-get", "login", "${login}"})
    @RequestMapping(value={"/publicapi/admin/users/{login:.+}"}, method={RequestMethod.GET})
    public void getUser(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        UsersService.APIUser user;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            user = this.usersService.getUserForAPI_NoCheck_WithSensitive(authCtx, login, true);
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)user);
    }

    @AuditedCall(value={"msgType", "security-admin-user-exists", "login", "${login}"})
    @RequestMapping(value={"/publicapi/admin/user-exists/{login:.+}"}, method={RequestMethod.GET})
    public void userExists(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        UsersDAO.User user;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            user = this.usersService.getInternalUserOrNullUnsafe(login);
        }
        UserAuthenticationService.UserAuthInfo userAuthInfo = new UserAuthenticationService.UserAuthInfo();
        if (user != null) {
            userAuthInfo.exists = true;
            if (user.enabled) {
                userAuthInfo.enabled = true;
            }
        }
        userAuthInfo.provisioningAtLogin = !this.userAuthenticationService.getSuppliersForProvisioningAtLoginTime().isEmpty();
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)userAuthInfo);
    }

    @AuditedCall(value={"msgType", "security-admin-user-edit", "login", "${login}"})
    @RequestMapping(value={"/publicapi/admin/users/{login:.+}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.USER_SAVE)
    public void adminEditUser(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        UsersService.APIUser user = (UsersService.APIUser)this.getRequestBodyAs(req, UsersService.APIUser.class);
        if (!StringUtils.equals((String)login, (String)user.login)) {
            throw new DKUControllerBase.MalformedRequestException("User login does not match requested URL");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            this.usersService.getUser_NoLeak(login);
            UserDiff userDiff = this.usersService.editUserFromAPI_NoCheck(user, authCtx);
            this.auditTrailService.generic("security-admin-user-start-trial").with("login", user.login).withAll(userDiff.getDiff()).emit();
            t.commit("Edited user " + user.login);
        }
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Edited user " + login);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-admin-user-edit-bulk"})
    @RequestMapping(value={"/publicapi/admin/users/actions/bulk"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.USERS_SAVE)
    public void adminEditUsers(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        UsersService.APIUser[] userModifications = (UsersService.APIUser[])this.getRequestBodyAs(req, UsersService.APIUser[].class);
        ArrayList<UserStatus> userEditionStatuses = new ArrayList<UserStatus>();
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            for (UsersService.APIUser userModification : userModifications) {
                try {
                    if (userModification.login == null) {
                        throw new DKUControllerBase.MalformedRequestException("Cannot update user not identified by login");
                    }
                    UserDiff userDiff = this.usersService.editUserFromAPIDiff_NoCheck(userModification, authCtx);
                    this.auditTrailService.generic("security-admin-user-edit").with("login", userModification.login).withAll(userDiff.getDiff()).emit();
                    userEditionStatuses.add(new UserStatus(userModification.login));
                }
                catch (Exception e) {
                    userEditionStatuses.add(new UserStatus(userModification.login, e.getMessage()));
                }
            }
            t.commit("Bulk edited users");
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, userEditionStatuses);
    }

    @AuditedCall(value={"msgType", "security-admin-user-delete", "login", "${login}"})
    @RequestMapping(value={"/publicapi/admin/users/{login:.+}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.USER_DELETE)
    public void adminDeleteUser(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login, @RequestParam(name="allowSelfDeletion", required=false, defaultValue="false") boolean allowSelfDeletion) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            String currentUserLogin = authCtx.getAssociatedDSSUser();
            if (currentUserLogin != null && currentUserLogin.equals(login) && !allowSelfDeletion) {
                PublicAPIUsersController.sendErrorExplicit((int)403, (String)"Forbidden", (String)"You cannot delete your own account. Please log in with a different user to delete this account or set allowSelfDeletion to true.", (HttpServletResponse)resp);
                return;
            }
            this.usersService.getUser_NoLeak(login);
            this.usersService.deleteUserAdmin(login);
            t.commit("Deleted user " + login);
        }
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Deleted user " + login);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-admin-user-delete-bulk"})
    @RequestMapping(value={"/publicapi/admin/users/actions/bulk"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.USERS_DELETE)
    public void adminDeleteUsers(HttpServletRequest req, HttpServletResponse resp, @RequestParam(name="allowSelfDeletion", required=false, defaultValue="false") boolean allowSelfDeletion) throws Exception {
        String[] logins = (String[])this.getRequestBodyAs(req, String[].class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        ArrayList<UserStatus> userDeletionStatuses = new ArrayList<UserStatus>();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            String currentUserLogin = authCtx.getAssociatedDSSUser();
            for (String login : logins) {
                try {
                    if (currentUserLogin != null && currentUserLogin.equals(login) && !allowSelfDeletion) {
                        throw new IllegalArgumentException("By default, you cannot delete your own account using bulk delete. Set allowSelfDeletion to true if you are certain you want to.");
                    }
                    this.usersService.getUser_NoLeak(login);
                    this.usersService.deleteUserAdmin(login);
                    userDeletionStatuses.add(new UserStatus(login));
                }
                catch (Exception e) {
                    userDeletionStatuses.add(new UserStatus(login, e.getMessage()));
                }
            }
            t.commit("Bulk deleted users");
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, userDeletionStatuses);
    }

    @AuditedCall(value={"msgType", "security-admin-user-activity", "login", "${login}"})
    @RequestMapping(value={"/publicapi/admin/users/{login}/activity"}, method={RequestMethod.GET})
    public void getUserActivity(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)this.usersService.getUserLastActivity(login));
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/users/{login:.+}/actions/resync"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.USERS_SYNC)
    public FutureResponse<InfoMessage.InfoMessages> resyncUser(HttpServletRequest req, final @PathVariable String login) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
        }
        return this.futureService.runFuture((FutureThreadBase)new GovernActionSimpleFutureThread<InfoMessage.InfoMessages>(authCtx, ActionType.USERS_SYNC){

            @Override
            protected InfoMessage.InfoMessages compute() throws Exception {
                return PublicAPIUsersController.this.userAuthenticationService.explicitOnDemandSync(Collections.singletonList(login));
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"syncUsers", (String)"Sync users from external sources");
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/users/actions/resync-multi"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.USERS_SYNC)
    public FutureResponse<InfoMessage.InfoMessages> resyncUsers(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
        }
        final List logins = (List)this.getRequestBodyAsOrNull(req, (TypeToken)new TypeToken<List<String>>(){});
        return this.futureService.runFuture((FutureThreadBase)new GovernActionSimpleFutureThread<InfoMessage.InfoMessages>(authCtx, ActionType.USERS_SYNC){

            @Override
            protected InfoMessage.InfoMessages compute() throws Exception {
                return PublicAPIUsersController.this.userAuthenticationService.explicitOnDemandSync(logins);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"syncUsers", (String)"Sync users from external sources");
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    @AuditedCall(value={"msgType", "security-admin-external-users-get", "userSourceType", "${userSourceType}"})
    @RequestMapping(method={RequestMethod.GET}, value={"/publicapi/admin/external-users"})
    @ResponseBody
    public FutureResponse<Set<ExternalUser>> fetchUsers(HttpServletRequest req, final @RequestParam UserSourceType userSourceType, final @RequestParam(required=false) String login, final @RequestParam(required=false) String email, final @RequestParam(required=false) String groupName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<Set<ExternalUser>>(authCtx){

            @Override
            protected Set<ExternalUser> compute() throws ServerAuthenticationFailure {
                return PublicAPIUsersController.this.userAuthenticationService.fetchUsers((UserSourceType)userSourceType, (UserQueryFilter)new UserQueryFilter((String)groupName, (String)login, (String)email)).users;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"fetchUsers", (String)"Fetch users from external sources");
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<Set<ExternalUser>>>(){});
    }

    @AuditedCall(value={"msgType", "security-admin-external-groups-get", "userSourceType", "${userSourceType}"})
    @RequestMapping(method={RequestMethod.GET}, value={"/publicapi/admin/external-groups"})
    @ResponseBody
    public FutureResponse<List<String>> fetchGroups(HttpServletRequest req, final @RequestParam UserSourceType userSourceType) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<List<String>>(authCtx){

            @Override
            protected List<String> compute() throws ServerAuthenticationFailure {
                return PublicAPIUsersController.this.userAuthenticationService.fetchGroups(userSourceType);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"fetchGroups", (String)"Fetch groups from external sources");
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<List<String>>>(){});
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/users/actions/provision"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.USERS_PROVISION)
    public FutureResponse<InfoMessage.InfoMessages> provisionUsers(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
        }
        final ProvisionUsersRequest request = (ProvisionUsersRequest)this.getRequestBodyAs(req, ProvisionUsersRequest.class);
        return this.futureService.runFuture((FutureThreadBase)new GovernActionSimpleFutureThread<InfoMessage.InfoMessages>(authCtx, ActionType.USERS_PROVISION){

            @Override
            protected InfoMessage.InfoMessages compute() throws InterruptedException {
                return PublicAPIUsersController.this.userAuthenticationService.provisionUsers(request.userSourceType, request.users);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"provisionUsers", (String)"Provision users");
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    @AuditedCall(value={"msgType", "security-admin-groups-list"})
    @RequestMapping(value={"/publicapi/admin/groups"}, method={RequestMethod.GET})
    public void listGroups(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            List<UsersDAO.Group> ret = this.usersService.listGroupsFull();
            PublicAPIUsersController.writeJSON((HttpServletResponse)resp, ret);
        }
    }

    @AuditedCall(value={"msgType", "security-admin-group-get", "groupName", "${groupName}"})
    @RequestMapping(value={"/publicapi/admin/groups/{groupName:.+}"}, method={RequestMethod.GET})
    public void getGroup(HttpServletRequest req, HttpServletResponse resp, @PathVariable String groupName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            UsersDAO.Group ret = this.usersService.getGroupMandatory(groupName);
            PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/groups"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.GROUP_CREATE)
    public void addGroup(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        UsersDAO.Group group = (UsersDAO.Group)this.getRequestBodyAs(req, UsersDAO.Group.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            if (this.usersService.getGroup(group.name) != null) {
                throw new DKUControllerBase.MalformedRequestException("Group " + group.name + " already exists. To edit a group, use PUT /groups/{groupName}");
            }
            this.usersService.addGroup(group);
            t.commit("Created group " + group.name);
            this.auditTrailService.generic("group-created").with("groupName", group.name).with("isAdmin", "" + group.isAdmin()).emit();
        }
        resp.setStatus(201);
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Created group " + group.name);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-admin-group-edit", "groupName", "${groupName}"})
    @RequestMapping(value={"/publicapi/admin/groups/{groupName:.+}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.GROUP_SAVE)
    public void editGroup(HttpServletRequest req, HttpServletResponse resp, @PathVariable String groupName) throws Exception {
        GroupDiff groupDiff;
        UsersDAO.Group group = (UsersDAO.Group)this.getRequestBodyAs(req, UsersDAO.Group.class);
        if (!StringUtils.equals((String)groupName, (String)group.name)) {
            throw new DKUControllerBase.MalformedRequestException("Group name does not match requested URL");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            this.usersService.getGroupMandatory(group.name);
            groupDiff = this.usersService.updateGroup(group);
            t.commit("Modified group " + group.name);
        }
        this.auditTrailService.generic("security-admin-group-edit").with("group", group.name).withAll(groupDiff.getDiff()).emit();
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Modified group " + group.name);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-admin-group-delete", "groupName", "${groupName}"})
    @RequestMapping(value={"/publicapi/admin/groups/{groupName:.+}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.GROUP_DELETE)
    public void deleteGroup(HttpServletRequest req, HttpServletResponse resp, @PathVariable String groupName) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            this.usersService.getGroupMandatory(groupName);
            this.usersService.deleteGroup(null, groupName);
            t.commit("Deleted group " + groupName);
        }
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Deleted group " + groupName);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-own-user-get"})
    @RequestMapping(value={"/publicapi/current-user"}, method={RequestMethod.GET})
    public void getOwnUser(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        UsersService.APIUser user;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            if (authCtx.getAssociatedDSSUser() == null) {
                throw new UnauthorizedException("This authentication does not have an associated user", "no-associated-user");
            }
            user = this.usersService.getUserForAPI_NoCheck_WithUserSensitive(authCtx.getAssociatedDSSUserMand());
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)user);
    }

    @AuditedCall(value={"msgType", "security-own-user-edit"})
    @RequestMapping(value={"/publicapi/current-user"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.USER_SAVE)
    public void saveOwnUser(HttpServletRequest req, HttpServletResponse res) throws Exception {
        AuthCtx authCtx;
        UsersService.APIUser user = (UsersService.APIUser)this.getRequestBodyAs(req, UsersService.APIUser.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            if (authCtx.getAssociatedDSSUser() == null) {
                throw new UnauthorizedException("This authentication does not have an associated user", "no-associated-user");
            }
        }
        if (!authCtx.getAssociatedDSSUserMand().equals(user.login)) {
            throw new UnauthorizedException("Illegal user modification, cannot modify own login", "access-denied");
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            this.usersService.getUser_NoLeak(user.login);
            UserDiff userDiff = this.usersService.editUserFromAPI_AllowedFieldsOnly(user, authCtx);
            this.auditTrailService.generic("security-admin-user-start-trial").with("login", user.login).withAll(userDiff.getDiff()).emit();
            t.commit("Edited user " + user.login + " (self-edit)");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "security-get-authorization-matrix"})
    @RequestMapping(value={"/publicapi/admin/authorization-matrix"}, method={RequestMethod.GET})
    public void getAuthorizationMatrix(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)this.auditService.getAuthorizationMatrix());
        }
    }

    @AuditedCall(value={"msgType", "security-users-list"})
    @RequestMapping(value={"/publicapi/users"}, method={RequestMethod.GET})
    @ResponseBody
    public List<MinimalUserDTO> listUsersNonAdmin(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            List<UsersService.APIUser> apiUsers = this.usersService.listAPIUsers_RestrictionCheck_WithSensitive(authCtx, null, false, false, false);
            List<MinimalUserDTO> list = apiUsers.stream().map(MinimalUserDTO::new).toList();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "security-user-get-info", "login", "${login}"})
    @RequestMapping(value={"/publicapi/users/{login:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public MinimalUserDTO getUserInfoNonAdmin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            UsersService.APIUser apiUser = this.usersService.getUserForAPI_RestrictionCheck_NoSensitive(authCtx, login);
            MinimalUserDTO minimalUserDTO = new MinimalUserDTO(apiUser);
            return minimalUserDTO;
        }
    }

    @AuditedCall(value={"msgType", "security-groups-list"})
    @RequestMapping(value={"/publicapi/groups"}, method={RequestMethod.GET})
    @ResponseBody
    public List<MinimalGroupDTO> listGroupsNonAdmin(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            List<String> groupNames = this.usersService.listGroupNames(authCtx, false);
            List<MinimalGroupDTO> list = groupNames.stream().map(MinimalGroupDTO::new).toList();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "security-admin-list-trial-expired-users"})
    @RequestMapping(value={"/publicapi/admin/list-trial-expired-users"}, method={RequestMethod.GET})
    public void listTrialExpiredUsers(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<UsersService.UIUser> expiredTrialUsers;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            expiredTrialUsers = this.usersService.listExpiredTrialUsers(authCtx);
        }
        ArrayList<UsersService.APIUser> users = new ArrayList<UsersService.APIUser>();
        for (UsersService.UIUser user : expiredTrialUsers) {
            UsersService.APIUser eud = new UsersService.APIUser(user);
            users.add(eud);
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, users);
    }

    private static class UserStatus {
        public String login;
        public Status status;
        public String error;

        public UserStatus(String login) {
            this.login = login;
            this.status = Status.SUCCESS;
            this.error = "";
        }

        public UserStatus(String login, String errorMessage) {
            this.login = login;
            this.status = Status.FAILURE;
            this.error = errorMessage;
        }

        public static enum Status {
            SUCCESS,
            FAILURE;

        }
    }

    @UIModel
    private static class ProvisionUsersRequest {
        UserSourceType userSourceType;
        Set<UserAttributes> users;

        private ProvisionUsersRequest() {
        }
    }

    public static class MinimalUserDTO {
        public String login;
        public String displayName;
        public List<String> groups;
        public String email;
        public Boolean enabled;

        public MinimalUserDTO(UsersService.APIUser apiUser) {
            this.login = apiUser.login;
            this.displayName = apiUser.displayName;
            this.groups = apiUser.groups;
            this.email = apiUser.email;
            this.enabled = apiUser.enabled;
        }
    }

    public static class MinimalGroupDTO {
        public String name;

        public MinimalGroupDTO(String groupName) {
            this.name = groupName;
        }
    }
}

