/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ComplexType {
    public Type type;
    public List<ObjectField> objectFields;
    public ComplexType arrayItemType;
    public ComplexType mapKeysType;
    public ComplexType mapValuesType;
    public String originalSQLType;
    public int maxLength;

    public static ComplexType fromColumn(SchemaColumn column) {
        Preconditions.checkNotNull((Object)column, (Object)"column");
        ComplexType result = new ComplexType(column.getType());
        result.objectFields = ComplexType.fromColumns(column.objectFields);
        result.arrayItemType = column.arrayContent == null ? null : ComplexType.fromColumn(column.arrayContent);
        result.mapKeysType = column.mapKeys == null ? null : ComplexType.fromColumn(column.mapKeys);
        result.mapValuesType = column.mapValues == null ? null : ComplexType.fromColumn(column.mapValues);
        result.originalSQLType = column.originalSQLType;
        result.maxLength = column.getType() == Type.STRING ? column.maxLength : 0;
        return result;
    }

    public ComplexType(Type type) {
        this.type = type;
    }

    public SchemaColumn newColumn(String columnName) {
        SchemaColumn column = new SchemaColumn(columnName, this.type);
        column.originalSQLType = this.originalSQLType;
        if (this.maxLength > 0) {
            column.maxLength = this.maxLength;
        }
        if (this.type == Type.OBJECT) {
            column.objectFields = this.objectFields == null ? null : this.objectFields.stream().map(ObjectField::newColumn).collect(Collectors.toList());
        } else if (this.type == Type.ARRAY) {
            column.arrayContent = this.arrayItemType == null ? null : this.arrayItemType.newColumn("item");
        } else if (this.type == Type.MAP) {
            column.mapKeys = this.mapKeysType == null ? null : this.mapKeysType.newColumn("key");
            column.mapValues = this.mapValuesType == null ? null : this.mapValuesType.newColumn("value");
        }
        return column;
    }

    public void updateColumnWithType(SchemaColumn column) {
        column.setType(this.type);
        column.objectFields = this.objectFields == null ? null : this.objectFields.stream().map(ObjectField::newColumn).collect(Collectors.toList());
        column.arrayContent = this.arrayItemType == null ? null : this.arrayItemType.newColumn("");
        column.mapKeys = this.mapKeysType == null ? null : this.mapKeysType.newColumn("");
        column.mapValues = this.mapValuesType == null ? null : this.mapValuesType.newColumn("");
        column.originalSQLType = this.originalSQLType;
        if (this.maxLength > 0 && this.maxLength > column.maxLength) {
            column.maxLength = this.maxLength;
        }
    }

    @Nullable
    public ComplexType commonSuperType(@Nullable ComplexType other) {
        if (other == null) {
            return null;
        }
        if (this.type == other.type) {
            if (this.type == Type.STRING) {
                ComplexType biggest = new ComplexType(this.type);
                biggest.maxLength = Math.max(this.maxLength, other.maxLength);
                return biggest;
            }
            if (this.type == Type.OBJECT) {
                return Objects.equals(this.objectFields, other.objectFields) ? this : null;
            }
            if (this.type == Type.ARRAY) {
                return Objects.equals(this.arrayItemType, other.arrayItemType) ? this : null;
            }
            if (this.type == Type.MAP) {
                return Objects.equals(this.mapKeysType, other.mapKeysType) && Objects.equals(this.mapValuesType, other.mapValuesType) ? this : null;
            }
            return this;
        }
        Type commonType = this.type.commonSuperType(other.type);
        return commonType == null ? null : new ComplexType(commonType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexType that = (ComplexType)o;
        if (this.type != that.type) {
            return false;
        }
        switch (this.type) {
            case OBJECT: {
                return Objects.equals(this.objectFields, that.objectFields);
            }
            case ARRAY: {
                return Objects.equals(this.arrayItemType, that.arrayItemType);
            }
            case MAP: {
                return Objects.equals(this.mapKeysType, that.mapKeysType) && Objects.equals(this.mapValuesType, that.mapValuesType);
            }
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.objectFields, this.arrayItemType, this.mapKeysType, this.mapValuesType});
    }

    private static List<ObjectField> fromColumns(List<SchemaColumn> objectFields) {
        if (objectFields == null) {
            return null;
        }
        return objectFields.stream().map(ObjectField::fromColumn).collect(Collectors.toList());
    }

    public static class ObjectField {
        public final String name;
        public final ComplexType type;

        public ObjectField(String name, Type type) {
            Preconditions.checkNotNull((Object)((Object)type));
            this.name = name;
            this.type = new ComplexType(type);
        }

        public ObjectField(String name, ComplexType type) {
            Preconditions.checkNotNull((Object)type);
            this.name = name;
            this.type = type;
        }

        public SchemaColumn newColumn() {
            return this.type.newColumn(this.name);
        }

        public static ObjectField fromColumn(@Nullable SchemaColumn column) {
            if (column == null) {
                return null;
            }
            return new ObjectField(column.getName(), ComplexType.fromColumn(column));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectField that = (ObjectField)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }
}

