/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.types;

import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.delta.kernel.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BasePrimitiveType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTypeJsonSerDe {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule(new SimpleModule().addSerializer(StructType.class, new StructTypeSerializer()));
    private static String FIXED_DECIMAL_REGEX = "decimal\\(\\s*(\\d+)\\s*,\\s*(\\-?\\d+)\\s*\\)";
    private static Pattern FIXED_DECIMAL_PATTERN = Pattern.compile(FIXED_DECIMAL_REGEX);

    private DataTypeJsonSerDe() {
    }

    public static String serializeStructType(StructType structType) {
        try {
            return OBJECT_MAPPER.writeValueAsString(structType);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new KernelException("Could not serialize StructType to JSON", jsonProcessingException);
        }
    }

    public static String serializeDataType(DataType dataType) {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonGenerator jsonGenerator = OBJECT_MAPPER.createGenerator(stringWriter);
            DataTypeJsonSerDe.writeDataType(jsonGenerator, dataType);
            jsonGenerator.flush();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new KernelException("Could not serialize DataType to JSON", iOException);
        }
    }

    public static StructType deserializeStructType(String string) {
        try {
            DataType dataType = DataTypeJsonSerDe.parseDataType(OBJECT_MAPPER.reader().readTree(string), "", new FieldMetadata.Builder().build());
            if (dataType instanceof StructType) {
                return (StructType)dataType;
            }
            throw new IllegalArgumentException(String.format("Could not parse the following JSON as a valid StructType:\n%s", string));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new KernelException(String.format("Could not parse schema given as JSON string: %s", string), jsonProcessingException);
        }
    }

    static DataType parseDataType(JsonNode jsonNode, String string, FieldMetadata fieldMetadata) {
        switch (jsonNode.getNodeType()) {
            case STRING: {
                return DataTypeJsonSerDe.nameToType(jsonNode.textValue(), string, fieldMetadata);
            }
            case OBJECT: {
                String string2;
                switch (string2 = DataTypeJsonSerDe.getStringField(jsonNode, "type")) {
                    case "struct": {
                        DataTypeJsonSerDe.assertValidTypeForCollations(string, "struct", fieldMetadata);
                        return DataTypeJsonSerDe.parseStructType(jsonNode);
                    }
                    case "array": {
                        DataTypeJsonSerDe.assertValidTypeForCollations(string, "array", fieldMetadata);
                        return DataTypeJsonSerDe.parseArrayType(jsonNode, string, fieldMetadata);
                    }
                    case "map": {
                        DataTypeJsonSerDe.assertValidTypeForCollations(string, "map", fieldMetadata);
                        return DataTypeJsonSerDe.parseMapType(jsonNode, string, fieldMetadata);
                    }
                }
            }
        }
        throw new IllegalArgumentException(String.format("Could not parse the following JSON as a valid Delta data type:\n%s", jsonNode));
    }

    private static ArrayType parseArrayType(JsonNode jsonNode, String string, FieldMetadata fieldMetadata) {
        Preconditions.checkArgument(jsonNode.isObject() && jsonNode.size() == 3, "Expected JSON object with 3 fields for array data type but got:\n%s", jsonNode);
        boolean bl = DataTypeJsonSerDe.getBooleanField(jsonNode, "containsNull");
        DataType dataType = DataTypeJsonSerDe.parseDataType(DataTypeJsonSerDe.getNonNullField(jsonNode, "elementType"), string + ".element", fieldMetadata);
        return new ArrayType(dataType, bl);
    }

    private static MapType parseMapType(JsonNode jsonNode, String string, FieldMetadata fieldMetadata) {
        Preconditions.checkArgument(jsonNode.isObject() && jsonNode.size() == 4, "Expected JSON object with 4 fields for map data type but got:\n%s", jsonNode);
        boolean bl = DataTypeJsonSerDe.getBooleanField(jsonNode, "valueContainsNull");
        DataType dataType = DataTypeJsonSerDe.parseDataType(DataTypeJsonSerDe.getNonNullField(jsonNode, "keyType"), string + ".key", fieldMetadata);
        DataType dataType2 = DataTypeJsonSerDe.parseDataType(DataTypeJsonSerDe.getNonNullField(jsonNode, "valueType"), string + ".value", fieldMetadata);
        return new MapType(dataType, dataType2, bl);
    }

    private static StructType parseStructType(JsonNode jsonNode) {
        Preconditions.checkArgument(jsonNode.isObject() && jsonNode.size() == 2, "Expected JSON object with 2 fields for struct data type but got:\n%s", jsonNode);
        JsonNode jsonNode2 = DataTypeJsonSerDe.getNonNullField(jsonNode, "fields");
        Preconditions.checkArgument(jsonNode2.isArray(), "Expected array for fieldName=%s in:\n%s", "fields", jsonNode);
        Iterator<JsonNode> iterator = jsonNode2.elements();
        ArrayList<StructField> arrayList = new ArrayList<StructField>();
        while (iterator.hasNext()) {
            arrayList.add(DataTypeJsonSerDe.parseStructField(iterator.next()));
        }
        return new StructType(arrayList);
    }

    private static StructField parseStructField(JsonNode jsonNode) {
        Preconditions.checkArgument(jsonNode.isObject(), "Expected JSON object for struct field");
        String string = DataTypeJsonSerDe.getStringField(jsonNode, "name");
        FieldMetadata fieldMetadata = DataTypeJsonSerDe.parseFieldMetadata(jsonNode.get("metadata"), false);
        DataType dataType = DataTypeJsonSerDe.parseDataType(DataTypeJsonSerDe.getNonNullField(jsonNode, "type"), string, DataTypeJsonSerDe.getCollationsMetadata(jsonNode.get("metadata")));
        boolean bl = DataTypeJsonSerDe.getBooleanField(jsonNode, "nullable");
        return new StructField(string, dataType, bl, fieldMetadata);
    }

    private static FieldMetadata parseFieldMetadata(JsonNode jsonNode) {
        return DataTypeJsonSerDe.parseFieldMetadata(jsonNode, true);
    }

    private static FieldMetadata parseFieldMetadata(JsonNode jsonNode2, boolean bl) {
        if (jsonNode2 == null || jsonNode2.isNull()) {
            return FieldMetadata.empty();
        }
        Preconditions.checkArgument(jsonNode2.isObject(), "Expected JSON object for struct field metadata");
        Iterator<Map.Entry<String, JsonNode>> iterator = jsonNode2.fields();
        FieldMetadata.Builder builder = FieldMetadata.builder();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            JsonNode jsonNode3 = entry.getValue();
            String string = entry.getKey();
            if (!bl && string.equals("__COLLATIONS")) continue;
            if (jsonNode3.isNull()) {
                builder.putNull(string);
                continue;
            }
            if (jsonNode3.isIntegralNumber()) {
                builder.putLong(string, jsonNode3.longValue());
                continue;
            }
            if (jsonNode3.isDouble()) {
                builder.putDouble(string, jsonNode3.doubleValue());
                continue;
            }
            if (jsonNode3.isBoolean()) {
                builder.putBoolean(string, jsonNode3.booleanValue());
                continue;
            }
            if (jsonNode3.isTextual()) {
                builder.putString(string, jsonNode3.textValue());
                continue;
            }
            if (jsonNode3.isObject()) {
                builder.putFieldMetadata(string, DataTypeJsonSerDe.parseFieldMetadata(jsonNode3));
                continue;
            }
            if (jsonNode3.isArray()) {
                Iterator<JsonNode> iterator2 = jsonNode3.elements();
                if (!iterator2.hasNext()) {
                    builder.putLongArray(string, new Long[0]);
                    continue;
                }
                JsonNode jsonNode4 = iterator2.next();
                if (jsonNode4.isInt()) {
                    builder.putLongArray(string, DataTypeJsonSerDe.buildList(jsonNode3, jsonNode -> jsonNode.intValue()).toArray(new Long[0]));
                    continue;
                }
                if (jsonNode4.isDouble()) {
                    builder.putDoubleArray(string, DataTypeJsonSerDe.buildList(jsonNode3, JsonNode::doubleValue).toArray(new Double[0]));
                    continue;
                }
                if (jsonNode4.isBoolean()) {
                    builder.putBooleanArray(string, DataTypeJsonSerDe.buildList(jsonNode3, JsonNode::booleanValue).toArray(new Boolean[0]));
                    continue;
                }
                if (jsonNode4.isTextual()) {
                    builder.putStringArray(string, DataTypeJsonSerDe.buildList(jsonNode3, JsonNode::textValue).toArray(new String[0]));
                    continue;
                }
                if (jsonNode4.isObject()) {
                    builder.putFieldMetadataArray(string, DataTypeJsonSerDe.buildList(jsonNode3, DataTypeJsonSerDe::parseFieldMetadata).toArray(new FieldMetadata[0]));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Unsupported type for Array as field metadata value: %s", jsonNode3));
            }
            throw new IllegalArgumentException(String.format("Unsupported type for field metadata value: %s", jsonNode3));
        }
        return builder.build();
    }

    private static <T> List<T> buildList(JsonNode jsonNode, Function<JsonNode, T> function) {
        ArrayList<T> arrayList = new ArrayList<T>();
        Iterator<JsonNode> iterator = jsonNode.elements();
        while (iterator.hasNext()) {
            arrayList.add(function.apply(iterator.next()));
        }
        return arrayList;
    }

    private static DataType nameToType(String string, String string2, FieldMetadata fieldMetadata) {
        if (BasePrimitiveType.isPrimitiveType(string)) {
            if (fieldMetadata.contains(string2)) {
                DataTypeJsonSerDe.assertValidTypeForCollations(string2, string, fieldMetadata);
                return new StringType(fieldMetadata.getString(string2));
            }
            return BasePrimitiveType.createPrimitive(string);
        }
        if (string.equals("decimal")) {
            return DecimalType.USER_DEFAULT;
        }
        if ("void".equalsIgnoreCase(string)) {
            throw DeltaErrors.voidTypeEncountered();
        }
        Matcher matcher = FIXED_DECIMAL_PATTERN.matcher(string);
        if (matcher.matches()) {
            int n = Integer.parseInt(matcher.group(1));
            int n2 = Integer.parseInt(matcher.group(2));
            return new DecimalType(n, n2);
        }
        throw new IllegalArgumentException(String.format("%s is not a supported delta data type", string));
    }

    private static JsonNode getNonNullField(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || jsonNode2.isNull()) {
            throw new IllegalArgumentException(String.format("Expected non-null for fieldName=%s in:\n%s", string, jsonNode));
        }
        return jsonNode2;
    }

    private static String getStringField(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = DataTypeJsonSerDe.getNonNullField(jsonNode, string);
        Preconditions.checkArgument(jsonNode2.isTextual(), "Expected string for fieldName=%s in:\n%s", string, jsonNode);
        return jsonNode2.textValue();
    }

    private static void assertValidTypeForCollations(String string, String string2, FieldMetadata fieldMetadata) {
        if (fieldMetadata.contains(string) && !string2.equals("string")) {
            throw new IllegalArgumentException(String.format("Invalid data type for collations: \"%s\"", string2));
        }
    }

    private static FieldMetadata getCollationsMetadata(JsonNode jsonNode) {
        if (jsonNode == null || !jsonNode.has("__COLLATIONS")) {
            return new FieldMetadata.Builder().build();
        }
        return DataTypeJsonSerDe.parseFieldMetadata(jsonNode.get("__COLLATIONS"));
    }

    private static boolean getBooleanField(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = DataTypeJsonSerDe.getNonNullField(jsonNode, string);
        Preconditions.checkArgument(jsonNode2.isBoolean(), "Expected boolean for fieldName=%s in:\n%s", string, jsonNode);
        return jsonNode2.booleanValue();
    }

    private static void writeDataType(JsonGenerator jsonGenerator, DataType dataType) throws IOException {
        if (dataType instanceof StructType) {
            DataTypeJsonSerDe.writeStructType(jsonGenerator, (StructType)dataType);
        } else if (dataType instanceof ArrayType) {
            DataTypeJsonSerDe.writeArrayType(jsonGenerator, (ArrayType)dataType);
        } else if (dataType instanceof MapType) {
            DataTypeJsonSerDe.writeMapType(jsonGenerator, (MapType)dataType);
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            jsonGenerator.writeString(String.format("decimal(%d,%d)", decimalType.getPrecision(), decimalType.getScale()));
        } else {
            jsonGenerator.writeString(dataType.toString());
        }
    }

    private static void writeArrayType(JsonGenerator jsonGenerator, ArrayType arrayType) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", "array");
        jsonGenerator.writeFieldName("elementType");
        DataTypeJsonSerDe.writeDataType(jsonGenerator, arrayType.getElementType());
        jsonGenerator.writeBooleanField("containsNull", arrayType.containsNull());
        jsonGenerator.writeEndObject();
    }

    private static void writeMapType(JsonGenerator jsonGenerator, MapType mapType) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", "map");
        jsonGenerator.writeFieldName("keyType");
        DataTypeJsonSerDe.writeDataType(jsonGenerator, mapType.getKeyType());
        jsonGenerator.writeFieldName("valueType");
        DataTypeJsonSerDe.writeDataType(jsonGenerator, mapType.getValueType());
        jsonGenerator.writeBooleanField("valueContainsNull", mapType.isValueContainsNull());
        jsonGenerator.writeEndObject();
    }

    private static void writeStructType(JsonGenerator jsonGenerator, StructType structType) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", "struct");
        jsonGenerator.writeArrayFieldStart("fields");
        for (StructField structField : structType.fields()) {
            DataTypeJsonSerDe.writeStructField(jsonGenerator, structField);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    private static void writeStructField(JsonGenerator jsonGenerator, StructField structField) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("name", structField.getName());
        jsonGenerator.writeFieldName("type");
        DataTypeJsonSerDe.writeDataType(jsonGenerator, structField.getDataType());
        jsonGenerator.writeBooleanField("nullable", structField.isNullable());
        jsonGenerator.writeFieldName("metadata");
        DataTypeJsonSerDe.writeFieldMetadata(jsonGenerator, structField.getMetadata());
        jsonGenerator.writeEndObject();
    }

    private static void writeFieldMetadata(JsonGenerator jsonGenerator, FieldMetadata fieldMetadata) throws IOException {
        jsonGenerator.writeStartObject();
        for (Map.Entry<String, Object> entry : fieldMetadata.getEntries().entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            Object object = entry.getValue();
            if (object instanceof Long) {
                jsonGenerator.writeNumber((Long)object);
                continue;
            }
            if (object instanceof Double) {
                jsonGenerator.writeNumber((Double)object);
                continue;
            }
            if (object instanceof Boolean) {
                jsonGenerator.writeBoolean((Boolean)object);
                continue;
            }
            if (object instanceof String) {
                jsonGenerator.writeString((String)object);
                continue;
            }
            if (object instanceof FieldMetadata) {
                DataTypeJsonSerDe.writeFieldMetadata(jsonGenerator, (FieldMetadata)object);
                continue;
            }
            if (object instanceof Long[]) {
                jsonGenerator.writeStartArray();
                for (Serializable serializable : (Long[])object) {
                    jsonGenerator.writeNumber((Long)serializable);
                }
                jsonGenerator.writeEndArray();
                continue;
            }
            if (object instanceof Double[]) {
                jsonGenerator.writeStartArray();
                for (Double d : (Double[])object) {
                    jsonGenerator.writeNumber(d);
                }
                jsonGenerator.writeEndArray();
                continue;
            }
            if (object instanceof Boolean[]) {
                jsonGenerator.writeStartArray();
                for (Boolean bl : (Boolean[])object) {
                    jsonGenerator.writeBoolean(bl);
                }
                jsonGenerator.writeEndArray();
                continue;
            }
            if (object instanceof String[]) {
                jsonGenerator.writeStartArray();
                for (String string : (String[])object) {
                    jsonGenerator.writeString(string);
                }
                jsonGenerator.writeEndArray();
                continue;
            }
            if (object instanceof FieldMetadata[]) {
                jsonGenerator.writeStartArray();
                for (FieldMetadata fieldMetadata2 : (FieldMetadata[])object) {
                    DataTypeJsonSerDe.writeFieldMetadata(jsonGenerator, fieldMetadata2);
                }
                jsonGenerator.writeEndArray();
                continue;
            }
            if (object == null) {
                jsonGenerator.writeNull();
                continue;
            }
            throw new IllegalArgumentException(String.format("Unsupported type for field metadata value: %s", object));
        }
        jsonGenerator.writeEndObject();
    }

    protected static class StructTypeSerializer
    extends StdSerializer<StructType> {
        public StructTypeSerializer() {
            super(StructType.class);
        }

        @Override
        public void serialize(StructType structType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            DataTypeJsonSerDe.writeDataType(jsonGenerator, structType);
        }
    }
}

