/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.debug;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DebugSleeper {
    private static DKULogger logger = DKULogger.getLogger("dku.debug");

    private static File file() {
        return new File(System.getenv("DIP_HOME") + "/debugsleep.json");
    }

    private static boolean isEnabled() {
        return System.getenv("DSS_DEV") != null && DebugSleeper.file().isFile();
    }

    public static void sleepUninterruptible(String condition) {
        if (!DebugSleeper.isEnabled()) {
            return;
        }
        Map mapContent = null;
        try {
            mapContent = JSON.parseFile(DebugSleeper.file(), Map.class);
        }
        catch (IOException e) {
            logger.warn("Failed to sleep", e);
            return;
        }
        Double sleepTime = (Double)mapContent.get(condition);
        if (sleepTime != null) {
            logger.infoV("Sleeping for %d ms (condition: %s)", sleepTime.longValue(), condition);
            DKUtils.unsafeSleep(sleepTime.longValue());
        }
    }
}

