/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.activity.DSSUsageStatsInternalDB;
import com.dataiku.dip.activity.IDSSUsageStatsInternalDB;
import com.dataiku.dip.pivot.backend.dss.LongDataMatrix;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectActivitySummaryBuilder {
    @Autowired
    private DSSUsageStatsInternalDB dbService;
    private String projectKey;
    private final int timeSpan;
    private final int nbSpans;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.activity.projectactivity.summary");

    public ProjectActivitySummaryBuilder(String projectKey) {
        this(projectKey, 1);
    }

    public ProjectActivitySummaryBuilder(String projectKey, int timeSpan) {
        this(projectKey, 1, 1);
    }

    public ProjectActivitySummaryBuilder(String projectKey, int timeSpan, int nbSpans) {
        SpringUtils.getInstance().autowire((Object)this);
        this.projectKey = projectKey;
        assert (timeSpan == 0 || timeSpan == 1 || timeSpan == 2 || timeSpan == 4 || timeSpan == 3);
        this.timeSpan = timeSpan;
        this.nbSpans = nbSpans;
    }

    public ProjectActivitySummary build(boolean totalCommitsOnly) throws Exception {
        logger.debug((Object)("Starting to build ProjectActivitySummary for " + this.projectKey));
        ProjectActivitySummary snippet = new ProjectActivitySummary();
        Calendar c2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        switch (this.timeSpan) {
            case 0: {
                c2.setTimeInMillis(0L);
                break;
            }
            case 3: 
            case 4: {
                c2.add(5, -6 * this.nbSpans);
                break;
            }
            case 2: {
                c2.add(2, -1 * this.nbSpans);
                c2.add(5, 1);
                break;
            }
            case 1: {
                c2.add(1, -1 * this.nbSpans);
                c2.add(5, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported time span " + this.timeSpan);
            }
        }
        c2.set(11, 0);
        c2.set(12, 0);
        c2.set(13, 0);
        c2.set(14, 0);
        long since = c2.getTimeInMillis();
        long first = Math.max(this.dbService.getFirstDataTime_cached(this.projectKey), since);
        if (since < first) {
            c2.setTimeInMillis(first);
            c2.set(11, 0);
            c2.set(12, 0);
            c2.set(13, 0);
            c2.set(14, 0);
            since = c2.getTimeInMillis();
        }
        logger.info((Object)"Computing total commits");
        snippet.totalCommits = this.dbService.getGlobalCommits_cached(this.projectKey, since);
        if (!totalCommitsOnly) {
            logger.info((Object)"Computing total presence");
            snippet.totalPresence = this.dbService.getProjectPresenceData(this.projectKey, since);
            logger.info((Object)"Computing HWW");
            snippet.totalHoursWithWrites = this.dbService.getGlobalProjectHoursWithWrites(this.projectKey, since);
            logger.info((Object)"Computing CS");
            snippet.commitsSummary = this.dbService.getCommitsSummary(this.projectKey, since);
            logger.info((Object)"Computing CS2");
            snippet.contributorsSummary = this.dbService.getPerContributorSummary(this.projectKey, since);
            logger.info((Object)"Computing CS3");
            snippet.contributorsSummaryAllTime = this.dbService.getPerContributorSummary(this.projectKey, 0L);
            logger.info((Object)"Computing CS4");
            snippet.totalCommitsPerHour = this.dbService.getTotalCommitsPerHour(this.projectKey, 0L);
            logger.info((Object)"Computing CS5");
            snippet.contributorsChart = this.dbService.getContributorsChart(this.projectKey);
        }
        logger.info((Object)("Done computing summary for project " + this.projectKey));
        return snippet;
    }

    public static class ProjectActivitySummary {
        public IDSSUsageStatsInternalDB.TimeSeries totalPresence;
        public IDSSUsageStatsInternalDB.TimeSeries totalHoursWithWrites;
        public IDSSUsageStatsInternalDB.TimeSeries totalCommits;
        public LongDataMatrix totalCommitsPerHour;
        public IDSSUsageStatsInternalDB.CommitsSummary commitsSummary;
        public List<IDSSUsageStatsInternalDB.ProjectContributor> contributorsSummary;
        public List<IDSSUsageStatsInternalDB.ProjectContributor> contributorsSummaryAllTime;
        public IDSSUsageStatsInternalDB.ContributorsChartData contributorsChart;
    }
}

