/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.blocks.custom;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.agents.blocks.custom.CustomBlocksGraphBlockDesc;
import com.dataiku.dip.agents.blocks.custom.CustomBlocksGraphBlockMeta;
import com.dataiku.dip.agents.blocks.custom.CustomBlocksGraphBlocksRegistry;
import com.dataiku.dip.agents.blocks.custom.LoadedCustomBlocksGraphBlock;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class CustomBlocksGraphBlocksService
extends AbstractElementService<CustomBlocksGraphBlockDesc, LoadedCustomBlocksGraphBlock> {
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.block");

    @Override
    public String getFolderName() {
        return "python-blocks-graph-blocks";
    }

    @Override
    public String getPrefix() {
        return "block";
    }

    @Override
    protected String getCodeExtension(LoadedCustomBlocksGraphBlock desc) {
        return "";
    }

    @Override
    public Class<CustomBlocksGraphBlockDesc> getDescClass() {
        return CustomBlocksGraphBlockDesc.class;
    }

    @Override
    public Class<LoadedCustomBlocksGraphBlock> getLoadedDescClass() {
        return LoadedCustomBlocksGraphBlock.class;
    }

    @Override
    protected void removeElement(LoadedCustomBlocksGraphBlock desc) {
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "blocks_graph_block_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedCustomBlocksGraphBlock load(String elementType, String pluginId, String elementId, File file) throws IOException {
        CustomBlocksGraphBlockDesc desc = (CustomBlocksGraphBlockDesc)JSON.parseFile((File)file, CustomBlocksGraphBlockDesc.class);
        desc.id = elementType;
        LoadedCustomBlocksGraphBlock loaded = new LoadedCustomBlocksGraphBlock(elementType, pluginId, elementId, desc);
        CustomBlocksGraphBlockMeta meta = new CustomBlocksGraphBlockMeta(loaded);
        CustomBlocksGraphBlocksRegistry.register(meta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomBlocksGraphBlockDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomBlocksGraphBlocksService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }

    public String getPythonLibFolder(String elementType) {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        LoadedCustomBlocksGraphBlock loadedDesc = (LoadedCustomBlocksGraphBlock)this.loadedDescs.get(elementType);
        File libDir = this.pluginsService.getPluginPythonlibFolder(loadedDesc.getOwnerPluginId());
        return libDir.getAbsolutePath();
    }
}

