/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class FeatureReductionNameExtractor
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (!(model instanceof ClassicalPredictionModelDetails)) {
            throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
        }
        ClassicalPredictionModelDetails predictionModel = (ClassicalPredictionModelDetails)model;
        String method = predictionModel.preprocessing.feature_selection_params.method.name();
        for (FeatureReductionName featureReductionName : FeatureReductionName.values()) {
            if (!featureReductionName.name().equals(method)) continue;
            return featureReductionName.getUserFriendlyName();
        }
        return "No reduction";
    }

    public static enum FeatureReductionName {
        NONE("No reduction"),
        CORRELATION("Correlation with target"),
        RANDOM_FOREST("Tree-based"),
        PCA("Principal Component Analysis"),
        ICA("Independent Component Analysis"),
        LASSO("Lasso"),
        CUSTOM("Custom");

        private String userFriendlyName;

        private FeatureReductionName(String userFriendlyName) {
            this.userFriendlyName = userFriendlyName;
        }

        String getUserFriendlyName() {
            return this.userFriendlyName;
        }
    }
}

