/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.core.PostTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class GenericTimeseriesExtractor<T>
implements ModelExtractor<T> {
    protected static final List<PreTrainPredictionModelingParams.Algorithm> MODELS_WITH_COEFFICIENTS = Arrays.asList(PreTrainPredictionModelingParams.Algorithm.AUTO_ARIMA, PreTrainPredictionModelingParams.Algorithm.SEASONAL_LOESS, PreTrainPredictionModelingParams.Algorithm.PROPHET, PreTrainPredictionModelingParams.Algorithm.RIDGE_REGRESSION, PreTrainPredictionModelingParams.Algorithm.ARIMA, PreTrainPredictionModelingParams.Algorithm.ETS);
    protected static final List<PreTrainPredictionModelingParams.Algorithm> MODELS_WITH_INFORMATION_CRITERIA = Arrays.asList(PreTrainPredictionModelingParams.Algorithm.AUTO_ARIMA, PreTrainPredictionModelingParams.Algorithm.SEASONAL_LOESS, PreTrainPredictionModelingParams.Algorithm.ETS);

    void assertModelIsSupported(ModelDetailsBase model, List<PreTrainPredictionModelingParams.Algorithm> supportedAlgorithms) throws IOException {
        if (!this.isSupportedAlgorithm(model, supportedAlgorithms)) {
            PostTrainPredictionModelingParams predictionModelingParams = (PostTrainPredictionModelingParams)model.actualParams.resolved;
            throw new IOException(String.format("Extractor '%s' does not support algorithms of type '%s'", new Object[]{this.getClass().getSimpleName(), predictionModelingParams.algorithm}));
        }
    }

    boolean isSupportedAlgorithm(ModelDetailsBase model, List<PreTrainPredictionModelingParams.Algorithm> supportedAlgorithms) throws IOException {
        if (!(model instanceof TimeseriesForecastingModelDetails)) {
            throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
        }
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        PostTrainModelingParams postTrainModelingParams = timeseriesModelDetails.actualParams.resolved;
        if (!(postTrainModelingParams instanceof PostTrainPredictionModelingParams)) {
            throw new IOException(String.format("Extractor '%s' does not support PostTrainModelingParams of type '%s'", this.getClass().getSimpleName(), timeseriesModelDetails.actualParams.resolved.getClass().getSimpleName()));
        }
        PostTrainPredictionModelingParams predictionModelingParams = (PostTrainPredictionModelingParams)postTrainModelingParams;
        return supportedAlgorithms.contains((Object)predictionModelingParams.algorithm);
    }
}

