/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.GenericMultiTimeseriesExtractor;
import com.dataiku.dip.analysis.docgen.transform.Placeholder;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelIntrinsicPerf;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InformationCriteriaMultiExtractor
extends GenericMultiTimeseriesExtractor<List<List<String>>> {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        this.assertModelIsSupported(model, MODELS_WITH_INFORMATION_CRITERIA);
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        if (timeseriesModelDetails.getCoreParams().timeseriesIdentifiers.size() == 0) {
            throw new IOException(String.format("Wrong placeholder. Extractor '%s' does not support single time series. Use {{%s}} instead.", this.getClass().getSimpleName(), Placeholder.RESULT_INFORMATION_CRITERIA_SINGLE_TABLE.placeholderName));
        }
        List<TimeseriesForecastingModelIntrinsicPerf.InformationCriterion> informationCriteria = ((TimeseriesForecastingModelDetails)model).iperf.informationCriteria;
        if (informationCriteria == null) {
            throw new IOException(String.format("Information criteria was not computed on this model. Compute them to display it in your model report.", new Object[0]));
        }
        ArrayList<List<String>> output = new ArrayList<List<String>>();
        List<String> headerRow = this.extractHeadersFromMap(informationCriteria.get((int)0).values);
        informationCriteria.forEach(c2 -> headerRow.add(c2.displayName));
        output.add(headerRow);
        for (String timeseriesIdentifierString : informationCriteria.get((int)0).values.keySet()) {
            ArrayList<String> row = new ArrayList<String>();
            JsonObject tsIdentifiers = (JsonObject)JSON.parse((String)timeseriesIdentifierString, JsonObject.class);
            for (String identifier : tsIdentifiers.keySet()) {
                row.add(tsIdentifiers.get(identifier).getAsString());
            }
            informationCriteria.forEach(c2 -> row.add(c2.values.get(timeseriesIdentifierString).toString()));
            output.add(row);
        }
        return output;
    }
}

