/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.helpers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.docgen.model.DesignChangedException;
import com.dataiku.dip.analysis.docgen.transform.ParametrizedPlaceholder;
import com.dataiku.dip.analysis.docgen.transform.Placeholder;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.utils.Params;
import java.io.IOException;
import java.util.Map;

public class PlaceholderUtil {
    public static ParametrizedPlaceholder getParametrizedPlaceholder(String placeholderName, Map<String, Placeholder> placeholders) throws IOException {
        String parameterValue = null;
        if (placeholderName.contains("/")) {
            String[] split = placeholderName.split("/", 2);
            placeholderName = split[0];
            parameterValue = split[1];
        }
        if (placeholders.containsKey(placeholderName)) {
            Placeholder p = placeholders.get(placeholderName);
            return new ParametrizedPlaceholder(p, parameterValue);
        }
        throw new IOException("Unsupported placeholder name {{" + placeholderName + "}}, please check your input template and the documentation for the list of the available placeholders");
    }

    public static void validateParametrizedPlaceholder(ParametrizedPlaceholder paramPlaceholder, ModelDetailsBase model, MLTask mlTask, FullModelId fmi, boolean hasDesignChanged) throws IOException, DesignChangedException {
        Placeholder placeholder = paramPlaceholder.placeholder;
        placeholder.supportMLTaskType(mlTask);
        if (placeholder.placeholderName.startsWith("design.") && !Placeholder.DESIGN_PREDICTION_TYPE_NAME.equals((Object)placeholder) && hasDesignChanged && !fmi.isExternalMLflowModelVersion() && !PlaceholderUtil.acceptDesignChanges()) {
            throw new DesignChangedException();
        }
        if (placeholder.validator != null) {
            try {
                placeholder.validator.validate(model);
            }
            catch (IOException e) {
                throw new IOException(String.format("The placeholder {{%s}} is not supported on this model because %s", placeholder.placeholderName, e.getMessage()));
            }
        }
        if (MLTask.MLTaskType.PREDICTION.equals((Object)mlTask.taskType) && !(model instanceof ClassicalPredictionModelDetails) && !(model instanceof TimeseriesForecastingModelDetails) || MLTask.MLTaskType.CLUSTERING.equals((Object)mlTask.taskType) && !(model instanceof ClusteringModelDetails)) {
            throw new IOException("The task of type {{" + String.valueOf((Object)mlTask.taskType) + "}} is not compatible with model of type " + String.valueOf(model.getClass()) + ".");
        }
        if (!placeholder.supportPartition(mlTask, fmi)) {
            throw new IOException("The partition policy of the placeholder {{" + placeholder.placeholderName + "}} is not compatible with this ML task");
        }
        if (placeholder.isParametrized && (paramPlaceholder.parameterValue == null || paramPlaceholder.parameterValue.isEmpty())) {
            throw new IOException("Parametrized result placeholder " + placeholder.placeholderName + " is missing a parameter. The parameter should be provided in your document like so: {{" + placeholder.placeholderName + "/your-parameter}}.");
        }
    }

    private static boolean acceptDesignChanges() {
        Params params = ApplicationConfigurator.getParams();
        return params.getBoolParam("dku.exports.docgen.acceptDesignChanges", false);
    }

    public static int countActiveAlgorithm(MLTask mlTask) {
        if (mlTask instanceof ClusteringMLTask) {
            ClusteringMLTask cmlTask = (ClusteringMLTask)mlTask;
            if (cmlTask.modeling != null) {
                return PlaceholderUtil.countActiveClusteringAlgorithm(cmlTask.modeling);
            }
        } else if (mlTask instanceof PredictionMLTask.ClassicalPredictionMLTask) {
            PredictionMLTask.ClassicalPredictionMLTask pmlTask = (PredictionMLTask.ClassicalPredictionMLTask)mlTask;
            if (pmlTask.modeling != null) {
                return PlaceholderUtil.countActivePredictionAlgorithm(pmlTask.modeling);
            }
        } else if (mlTask instanceof PredictionMLTask.TimeseriesForecastingMLTask) {
            PredictionMLTask.TimeseriesForecastingMLTask tsTask = (PredictionMLTask.TimeseriesForecastingMLTask)mlTask;
            if (tsTask.modeling != null) {
                return PlaceholderUtil.countActiveTimeseriesAlgorithm(tsTask.modeling);
            }
        } else {
            throw new IllegalArgumentException("Unsupported Prediction Task: " + mlTask.getClass().getSimpleName());
        }
        return 0;
    }

    private static int countActiveClusteringAlgorithm(ClusteringModelingParams params) {
        int counter = 0;
        if (params.db_scan_clustering.enabled) {
            ++counter;
        }
        if (params.hdb_scan_clustering.enabled) {
            ++counter;
        }
        if (params.spectral_clustering.enabled) {
            ++counter;
        }
        if (params.ward_clustering.enabled) {
            ++counter;
        }
        if (params.kmeans_clustering.enabled) {
            ++counter;
        }
        if (params.mini_batch_kmeans_clustering.enabled) {
            ++counter;
        }
        if (params.gmm_clustering.enabled) {
            ++counter;
        }
        if (params.mllib_kmeans_clustering.enabled) {
            ++counter;
        }
        if (params.mllib_gaussian_mixture_clustering.enabled) {
            ++counter;
        }
        if (params.h2o_kmeans.enabled) {
            ++counter;
        }
        if (params.two_step.enabled) {
            ++counter;
        }
        if (params.isolation_forest.enabled) {
            ++counter;
        }
        return counter + PlaceholderUtil.countActiveCustomClusteringAlgorithm(params);
    }

    private static int countActiveCustomClusteringAlgorithm(ClusteringModelingParams params) {
        int counter = 0;
        for (ClusteringModelingParams.ClusteringCustomPythonParams customPythonParams : params.custom_python) {
            if (!customPythonParams.enabled) continue;
            ++counter;
        }
        for (PredictionModelingParams.MLLibCustomGridParams customMLLib : params.custom_mllib) {
            if (!customMLLib.enabled) continue;
            ++counter;
        }
        return counter;
    }

    private static int countActivePredictionAlgorithm(PredictionModelingParams params) {
        int counter = 0;
        if (params.random_forest_classification.enabled) {
            ++counter;
        }
        if (params.lightgbm_classification.enabled) {
            ++counter;
        }
        if (params.xgboost.enabled) {
            ++counter;
        }
        if (params.decision_tree_classification.enabled) {
            ++counter;
        }
        if (params.lars_params.enabled) {
            ++counter;
        }
        if (params.keras.enabled) {
            ++counter;
        }
        if (params.svc_classifier.enabled) {
            ++counter;
        }
        if (params.gbt_classification.enabled) {
            ++counter;
        }
        if (params.knn.enabled) {
            ++counter;
        }
        if (params.sgd_classifier.enabled) {
            ++counter;
        }
        if (params.extra_trees.enabled) {
            ++counter;
        }
        if (params.neural_network.enabled) {
            ++counter;
        }
        if (params.deep_neural_network_classification.enabled) {
            ++counter;
        }
        if (params.tabicl_classification.enabled) {
            ++counter;
        }
        return counter + PlaceholderUtil.countActiveRegressionAlgorithm(params) + PlaceholderUtil.countActiveSparklingPredictionAlgorithm(params) + PlaceholderUtil.countActiveCustomPredictionAlgorithm(params) + PlaceholderUtil.countActiveMlLibPredictionAlgorithm(params);
    }

    private static int countActiveTimeseriesAlgorithm(PredictionModelingParams params) {
        int counter = 0;
        if (params.trivial_identity_timeseries.enabled) {
            ++counter;
        }
        if (params.seasonal_naive_timeseries.enabled) {
            ++counter;
        }
        if (params.autoarima_timeseries.enabled) {
            ++counter;
        }
        if (params.arima_timeseries.enabled) {
            ++counter;
        }
        if (params.croston_timeseries.enabled) {
            ++counter;
        }
        if (params.ets_timeseries.enabled) {
            ++counter;
        }
        if (params.nhits_timeseries.enabled) {
            ++counter;
        }
        if (params.seasonal_loess_timeseries.enabled) {
            ++counter;
        }
        if (params.tft_timeseries.enabled) {
            ++counter;
        }
        if (params.prophet_timeseries.enabled) {
            ++counter;
        }
        if (params.gluonts_npts_timeseries.enabled) {
            ++counter;
        }
        if (params.gluonts_torch_simple_feed_forward_timeseries.enabled) {
            ++counter;
        }
        if (params.gluonts_torch_deepar_timeseries.enabled) {
            ++counter;
        }
        if (params.gluonts_simple_feed_forward_timeseries.enabled) {
            ++counter;
        }
        if (params.gluonts_deepar_timeseries.enabled) {
            ++counter;
        }
        if (params.gluonts_transformer_timeseries.enabled) {
            ++counter;
        }
        if (params.gluonts_mqcnn_timeseries.enabled) {
            ++counter;
        }
        return counter;
    }

    private static int countActiveRegressionAlgorithm(PredictionModelingParams params) {
        int counter = 0;
        if (params.logistic_regression.enabled) {
            ++counter;
        }
        if (params.random_forest_regression.enabled) {
            ++counter;
        }
        if (params.lightgbm_regression.enabled) {
            ++counter;
        }
        if (params.ridge_regression.enabled) {
            ++counter;
        }
        if (params.decision_tree_regression.enabled) {
            ++counter;
        }
        if (params.lasso_regression.enabled) {
            ++counter;
        }
        if (params.vertica_logistic_regression.enabled) {
            ++counter;
        }
        if (params.vertica_linear_regression.enabled) {
            ++counter;
        }
        if (params.gbt_regression.enabled) {
            ++counter;
        }
        if (params.leastsquare_regression.enabled) {
            ++counter;
        }
        if (params.svm_regression.enabled) {
            ++counter;
        }
        if (params.sgd_regression.enabled) {
            ++counter;
        }
        if (params.deep_neural_network_regression.enabled) {
            ++counter;
        }
        return counter;
    }

    private static int countActiveSparklingPredictionAlgorithm(PredictionModelingParams params) {
        int counter = 0;
        if (params.glm_sparkling.enabled) {
            ++counter;
        }
        if (params.gbm_sparkling.enabled) {
            ++counter;
        }
        if (params.deep_learning_sparkling.enabled) {
            ++counter;
        }
        if (params.rf_sparkling.enabled) {
            ++counter;
        }
        if (params.nb_sparkling.enabled) {
            ++counter;
        }
        return counter;
    }

    private static int countActiveMlLibPredictionAlgorithm(PredictionModelingParams params) {
        int counter = 0;
        if (params.mllib_linreg.enabled) {
            ++counter;
        }
        if (params.mllib_logit.enabled) {
            ++counter;
        }
        if (params.mllib_rf.enabled) {
            ++counter;
        }
        if (params.mllib_naive_bayes.enabled) {
            ++counter;
        }
        if (params.mllib_dt.enabled) {
            ++counter;
        }
        if (params.mllib_gbt.enabled) {
            ++counter;
        }
        return counter;
    }

    private static int countActiveCustomPredictionAlgorithm(PredictionModelingParams params) {
        int counter = 0;
        for (PredictionModelingParams.CustomPythonPluginParams algo : params.plugin_python.values()) {
            if (!algo.enabled) continue;
            ++counter;
        }
        for (PredictionModelingParams.CustomPythonParams customPythonParams : params.custom_python) {
            if (!customPythonParams.enabled) continue;
            ++counter;
        }
        for (PredictionModelingParams.MLLibCustomGridParams customMLLib : params.custom_mllib) {
            if (!customMLLib.enabled) continue;
            ++counter;
        }
        return counter;
    }
}

