/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;

public class MLPaths {
    public static File sessionFolder(MLTaskLoc taskLoc, String sessionId) {
        Preconditions.checkNotNull((Object)taskLoc);
        Preconditions.checkNotNull((Object)sessionId);
        return DKUFileUtils.getWithinFollowLink((File)taskLoc.getSessionsFolder(), (String[])new String[]{sessionId});
    }

    public static File preprocessingFolder(MLTaskLoc taskLoc, String sessionId, String preprocessingId) {
        Preconditions.checkNotNull((Object)taskLoc);
        Preconditions.checkNotNull((Object)sessionId);
        Preconditions.checkNotNull((Object)preprocessingId);
        return DKUFileUtils.getWithinFollowLink((File)taskLoc.getSessionsFolder(), (String[])new String[]{sessionId, preprocessingId});
    }

    public static File modelFolder(MLTaskLoc taskLoc, String sessionId, String preprocessingId, String modelId) {
        Preconditions.checkNotNull((Object)taskLoc);
        Preconditions.checkNotNull((Object)sessionId);
        Preconditions.checkNotNull((Object)preprocessingId);
        Preconditions.checkNotNull((Object)modelId);
        return DKUFileUtils.getWithinFollowLink((File)taskLoc.getSessionsFolder(), (String[])new String[]{sessionId, preprocessingId, modelId});
    }

    public static File savedModelBaseFolder(SavedModel sm) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{sm.projectKey, sm.id});
    }

    public static File savedModelBaseFolder(String smProjectKey, String smId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{smProjectKey, smId});
    }

    public static File savedModelCoreFolder(SavedModel sm) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{sm.projectKey, sm.id, "core"});
    }

    public static File savedModelCoreFolder(String smProjectKey, String smId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{smProjectKey, smId, "core"});
    }

    public static File savedModelVersionsFolder(SavedModel sm) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{sm.projectKey, sm.id, "versions"});
    }

    public static File savedModelVersionFolder(SavedModel sm, String versionId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{sm.projectKey, sm.id, "versions", versionId});
    }

    public static File savedModelVersionFolder(String smProjectKey, String smId, String versionId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{smProjectKey, smId, "versions", versionId});
    }

    public static File savedModelPartVersionFolder(SavedModel sm, String partitionId, String partVersionId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{sm.projectKey, sm.id, "pversions", partitionId, partVersionId});
    }

    public static File savedModelPartVersionFolder(SavedModel sm, String partitionId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{sm.projectKey, sm.id, "pversions", partitionId});
    }

    public static File savedModelPartVersionFolder(String smProjectKey, String smId, String partitionId, String partVersionId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{smProjectKey, smId, "pversions", partitionId, partVersionId});
    }

    public static File savedModelPartVersionBaseFolder(SavedModel sm) {
        return MLPaths.savedModelPartVersionBaseFolder(sm.projectKey, sm.id);
    }

    public static File savedModelPartVersionBaseFolder(String smProjectKey, String smId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"saved_models"), (String[])new String[]{smProjectKey, smId, "pversions"});
    }

    public static File agentConfigFile(String smProjectKey, String smId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"config"), (String[])new String[]{"projects", smProjectKey, "saved_models", smId + ".json"});
    }

    public static File agentSourceCodeFile(String smProjectKey, String smId, String versionId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"config"), (String[])new String[]{"projects", smProjectKey, "saved_models", smId + "_" + versionId + ".py"});
    }

    public static File agentToolFolder(String projectKey, String agentToolId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"agent-tools"), (String[])new String[]{projectKey, agentToolId});
    }

    public static File agentToolConfigFile(String projectKey, String agentToolId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"config"), (String[])new String[]{"projects", projectKey, "agent-tools", agentToolId + ".json"});
    }

    public static File agentToolSourceCodeFile(String projectKey, String agentToolId) {
        return DKUFileUtils.getWithinFollowLink((File)ApplicationConfigurator.getFile((String)"config"), (String[])new String[]{"projects", projectKey, "agent-tools", agentToolId + ".py"});
    }

    public static File getContextDir(FullModelId fmi) {
        if (FullModelId.Type.ANALYSIS == fmi.getType()) {
            return fmi.getTaskLoc().getDataFolder();
        }
        return MLPaths.savedModelBaseFolder(fmi.projectKey, fmi.getSavedModelID());
    }

    public static void createIfNeededSavedModelFolderAndRestrictPermissions(SavedModel sm) throws IOException, InterruptedException {
        MLPaths.createIfNeededFolderAndRestrictPermissions(MLPaths.savedModelBaseFolder(sm.projectKey, sm.id));
    }

    public static void createIfNeededMLTaskFolderAndRestrictPermissions(MLTaskLoc loc) throws IOException, InterruptedException {
        MLPaths.createIfNeededFolderAndRestrictPermissions(loc.getDataFolder());
    }

    public static void createIfNeededFolderAndRestrictPermissions(File folder) throws IOException, InterruptedException {
        if (folder.exists()) {
            return;
        }
        DKUFileUtils.mkdirs((File)folder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(folder);
    }

    public static void restrictPermissionsAnalysisFolder(File analysisFolder) throws IOException, InterruptedException {
        if (analysisFolder != null && analysisFolder.isDirectory()) {
            for (File mlTaskFolder : analysisFolder.listFiles()) {
                if (!mlTaskFolder.isDirectory()) continue;
                FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(mlTaskFolder);
            }
        }
    }
}

