/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.flow;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.clustering.ClusteringResultsReader;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusterRecipeCreator;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusterRecipeSchemaComputer;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringClusterRecipePayloadParams;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringClusterRecipeRunner;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringScoringRecipeCreator;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringScoringRecipePayloadParams;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringScoringRecipeRunner;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringScoringRecipeSchemaComputer;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringTrainingRecipeRunner;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.MLRecipeDataLineage;
import com.dataiku.dip.recipes.MetaWithFixedCodeEnv;
import com.dataiku.dip.recipes.MetaWithModelCodeEnv;
import com.dataiku.dip.recipes.ParamsWithFixedCodeEnv;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.shaker.ShakerRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.util.Map;

public class ClusteringRecipesMeta {
    public static final ClusteringTrainingRecipeMeta TRAINING_META = new ClusteringTrainingRecipeMeta();
    public static final ClusteringScoringRecipeMeta SCORING_META = new ClusteringScoringRecipeMeta();
    public static final ClusterRecipeMeta CLUSTER_META = new ClusterRecipeMeta();

    public static class ClusteringTrainingRecipeMeta
    extends RecipeMeta
    implements MetaWithFixedCodeEnv {
        @Override
        public Class<? extends RecipeParams> paramsClass() {
            return ContainerRecipeParams.class;
        }

        @Override
        public String getType() {
            return "clustering_training";
        }

        @Override
        public RecipeRunner buildRunner(JobActivity activity) {
            return new ClusteringTrainingRecipeRunner(activity);
        }

        @Override
        public RecipeStatusComputer buildStatusComputer(SerializedRecipe sr, String payload) {
            return new MLFlowUtils.ClusteringTrainingRecipeStatusComputer(sr, payload);
        }

        @Override
        public RecipeDesc getRecipeDesc() {
            RecipeDesc desc = RecipeDesc.newSisoDesc("clustering training", null);
            RecipeDesc.IORoleDef model = desc.outputRoles.get(0).withEditable(false, false);
            model.acceptsDataset = false;
            model.acceptsMLModel = true;
            desc.copiable = false;
            return desc;
        }

        @Override
        public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
            return new RecipeMeta.RecipeCategoryFlags().withML();
        }

        @Override
        public boolean hasJsonPayload() {
            return true;
        }

        @Override
        public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
            ClusteringTrainingRecipePayloadParams params = (ClusteringTrainingRecipePayloadParams)JSON.parse((String)payload, ClusteringTrainingRecipePayloadParams.class);
            return params.sparkParams.sparkConf;
        }

        @Override
        public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
            ClusteringTrainingRecipePayloadParams params = (ClusteringTrainingRecipePayloadParams)JSON.parse((String)payload, ClusteringTrainingRecipePayloadParams.class);
            params.sparkParams.sparkConf = config;
            return JSON.json((Object)params);
        }

        @Override
        public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
            ClusteringTrainingRecipePayloadParams params = (ClusteringTrainingRecipePayloadParams)JSON.parse((String)payload, ClusteringTrainingRecipePayloadParams.class);
            params.sparkParams.sparkExecutionEngine = executionEngine;
            return JSON.json((Object)params);
        }

        @Override
        public CodeEnvModel.EnvLang getEnvLang() {
            return CodeEnvModel.EnvLang.PYTHON;
        }

        @Override
        public Class<? extends ParamsWithFixedCodeEnv> getCodeEnvBearingParamsClass() {
            return ClusteringTrainingRecipePayloadParams.class;
        }
    }

    public static class ClusteringScoringRecipeMeta
    extends RecipeMeta
    implements MetaWithModelCodeEnv,
    MLRecipeDataLineage {
        @Override
        public Class<? extends RecipeParams> paramsClass() {
            return ContainerRecipeParams.class;
        }

        @Override
        public String getType() {
            return "clustering_scoring";
        }

        @Override
        public RecipeRunner buildRunner(JobActivity activity) {
            return new ClusteringScoringRecipeRunner(activity);
        }

        @Override
        public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
            return RecipeMeta.OutputSchemaComputability.RELIABLE_DYNAMIC;
        }

        @Override
        public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
            return new ClusteringScoringRecipeSchemaComputer(authCtx, activity);
        }

        @Override
        public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
            return new MLFlowUtils.ClusteringScoringRecipeStatusComputer(recipe, payload);
        }

        @Override
        public RecipeDesc getRecipeDesc() {
            RecipeDesc desc = RecipeDesc.newSisoDesc("clustering scoring", null);
            RecipeDesc.IORoleDef model = RecipeDesc.IORoleDef.newUnaryRequiredMLModel("model", "Model");
            desc.inputRoles.add(model);
            return desc;
        }

        @Override
        public RecipeCreator buildCreator(AuthCtx authCtx) {
            return new ClusteringScoringRecipeCreator(authCtx, this);
        }

        @Override
        public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
            return new RecipeMeta.RecipeCategoryFlags().withML();
        }

        @Override
        public boolean hasJsonPayload() {
            return true;
        }

        @Override
        public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
            ClusteringScoringRecipePayloadParams params = (ClusteringScoringRecipePayloadParams)JSON.parse((String)payload, ClusteringScoringRecipePayloadParams.class);
            return params.sparkParams.sparkConf;
        }

        @Override
        public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
            ClusteringScoringRecipePayloadParams params = (ClusteringScoringRecipePayloadParams)JSON.parse((String)payload, ClusteringScoringRecipePayloadParams.class);
            params.sparkParams.sparkConf = config;
            return JSON.json((Object)params);
        }

        @Override
        public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
            ClusteringScoringRecipePayloadParams params = (ClusteringScoringRecipePayloadParams)JSON.parse((String)payload, ClusteringScoringRecipePayloadParams.class);
            params.sparkParams.sparkExecutionEngine = executionEngine;
            return JSON.json((Object)params);
        }

        @Override
        public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) {
            ResolvedPreprocessingParams preprocessingParams;
            ClusteringModelDetails details;
            if (predecessors.datasetsByFullName.isEmpty() || successors.datasetsByFullName.isEmpty() || predecessors.savedModels.isEmpty()) {
                return new RecipeLineage();
            }
            this.checkInputArguments(predecessors, "Clustering");
            Preconditions.checkArgument((successors.datasetsByFullName.size() == 1 ? 1 : 0) != 0, (Object)"Clustering recipe can have only one output dataset");
            SerializedDataset inputDataset = predecessors.datasetsByFullName.values().stream().findFirst().get();
            SerializedDataset outputDataset = successors.datasetsByFullName.values().stream().findFirst().get();
            SavedModel savedModel = predecessors.savedModels.get(0);
            FullModelId fmid = new FullModelId(savedModel.projectKey, savedModel.id, savedModel.activeVersion);
            try {
                details = ClusteringResultsReader.makeDetails(fmid);
                preprocessingParams = fmid.getResolvedPreprocessingParams();
            }
            catch (Exception e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Clustering Recipe: Failed to fetch model params and details", (Throwable)e);
            }
            return this.getRecipeLineage(inputDataset, outputDataset, details, preprocessingParams);
        }

        public RecipeLineage getRecipeLineage(SerializedDataset inputDataset, SerializedDataset outputDataset, ClusteringModelDetails details, ResolvedPreprocessingParams preprocessingParams) {
            String inputDatasetName = inputDataset.getFullName();
            String outputDatasetName = outputDataset.getFullName();
            DatasetPairLineage datasetPairLineage = new DatasetPairLineage(inputDatasetName, inputDataset.getSchema(), outputDatasetName, outputDataset.getSchema());
            datasetPairLineage.initializeDirectColumnRelations();
            RecipeLineage recipeLineage = new RecipeLineage(inputDatasetName, outputDatasetName, datasetPairLineage);
            ShakerRecipeMeta shakerMeta = new ShakerRecipeMeta();
            try {
                recipeLineage = shakerMeta.getRecipeLineageFromSteps(details.trainedWithScript.steps, recipeLineage);
            }
            catch (Exception e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Clustering Recipe: Failed to compute script lineage", (Throwable)e);
            }
            Schema scoringOutputColumns = new Schema();
            scoringOutputColumns.addColumn("cluster_labels", Type.STRING);
            details.modeling.algorithm.meta.additionalScoringColumns().forEach(arg_0 -> ((Schema)scoringOutputColumns).addColumn(arg_0));
            DatasetPairLineage finalDatasetPairLineage = recipeLineage.getDatasetPairLineage(inputDatasetName, outputDatasetName);
            for (Map.Entry<String, FeaturePreprocessingParams> entry : preprocessingParams.per_feature.entrySet()) {
                String featureName = entry.getKey();
                FeaturePreprocessingParams featurePreprocessingParams = entry.getValue();
                if (!this.shouldIncludeInLineage(featurePreprocessingParams, details) || !recipeLineage.getDatasetPairLineage(inputDatasetName, outputDatasetName).getOutputColumns().contains(featureName)) continue;
                scoringOutputColumns.columns.forEach(col -> finalDatasetPairLineage.addFactorizedColumnRelations(featureName, col.getName()));
            }
            recipeLineage.keepValidRelations();
            return recipeLineage;
        }
    }

    public static class ClusterRecipeMeta
    extends RecipeMeta
    implements MetaWithFixedCodeEnv,
    MLRecipeDataLineage {
        @Override
        public Class<? extends RecipeParams> paramsClass() {
            return ContainerRecipeParams.class;
        }

        @Override
        public String getType() {
            return "clustering_cluster";
        }

        @Override
        public RecipeRunner buildRunner(JobActivity activity) {
            return new ClusteringClusterRecipeRunner(activity);
        }

        @Override
        public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
            return RecipeMeta.OutputSchemaComputability.RELIABLE_DYNAMIC;
        }

        @Override
        public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
            return new ClusterRecipeSchemaComputer(authCtx, activity);
        }

        @Override
        public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
            return MLFlowUtils.buildClusterRecipeStatusComputer(recipe, payload);
        }

        @Override
        public RecipeDesc getRecipeDesc() {
            return RecipeDesc.newSisoDesc("cluster", null);
        }

        @Override
        public RecipeCreator buildCreator(AuthCtx authCtx) {
            return new ClusterRecipeCreator(authCtx, this);
        }

        @Override
        public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
            return new RecipeMeta.RecipeCategoryFlags().withML();
        }

        @Override
        public boolean hasJsonPayload() {
            return true;
        }

        @Override
        public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
            ClusteringClusterRecipePayloadParams params = (ClusteringClusterRecipePayloadParams)JSON.parse((String)payload, ClusteringClusterRecipePayloadParams.class);
            return params.sparkParams.sparkConf;
        }

        @Override
        public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
            ClusteringClusterRecipePayloadParams params = (ClusteringClusterRecipePayloadParams)JSON.parse((String)payload, ClusteringClusterRecipePayloadParams.class);
            params.sparkParams.sparkConf = config;
            return JSON.json((Object)params);
        }

        @Override
        public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
            ClusteringClusterRecipePayloadParams params = (ClusteringClusterRecipePayloadParams)JSON.parse((String)payload, ClusteringClusterRecipePayloadParams.class);
            params.sparkParams.sparkExecutionEngine = executionEngine;
            return JSON.json((Object)params);
        }

        @Override
        public CodeEnvModel.EnvLang getEnvLang() {
            return CodeEnvModel.EnvLang.PYTHON;
        }

        @Override
        public Class<? extends ParamsWithFixedCodeEnv> getCodeEnvBearingParamsClass() {
            return ClusteringClusterRecipePayloadParams.class;
        }

        @Override
        public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) {
            if (predecessors.datasetsByFullName.isEmpty() || successors.datasetsByFullName.isEmpty()) {
                return new RecipeLineage();
            }
            Preconditions.checkArgument((successors.datasetsByFullName.size() == 1 ? 1 : 0) != 0, (Object)"Clustering cluster recipe can have only one output dataset");
            Preconditions.checkArgument((predecessors.datasetsByFullName.size() == 1 ? 1 : 0) != 0, (Object)"Clustering cluster recipe can have only one input dataset");
            ClusteringClusterRecipePayloadParams params = (ClusteringClusterRecipePayloadParams)JSON.parse((String)payload, ClusteringClusterRecipePayloadParams.class);
            SerializedDataset inputDataset = predecessors.datasetsByFullName.values().stream().findFirst().get();
            SerializedDataset outputDataset = successors.datasetsByFullName.values().stream().findFirst().get();
            String inputDatasetName = inputDataset.getFullName();
            String outputDatasetName = outputDataset.getFullName();
            DatasetPairLineage datasetPairLineage = new DatasetPairLineage(inputDatasetName, inputDataset.getSchema(), outputDatasetName, outputDataset.getSchema());
            datasetPairLineage.initializeDirectColumnRelations();
            RecipeLineage recipeLineage = new RecipeLineage(inputDatasetName, outputDatasetName, datasetPairLineage);
            ShakerRecipeMeta shakerMeta = new ShakerRecipeMeta();
            try {
                recipeLineage = shakerMeta.getRecipeLineageFromSteps(params.script.steps, recipeLineage);
            }
            catch (Exception e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Clustering cluster Recipe: Failed to compute script lineage", (Throwable)e);
            }
            Schema scoringOutputColumns = new Schema();
            scoringOutputColumns.addColumn("cluster_labels", Type.STRING);
            params.modeling.algorithm.meta.additionalScoringColumns().forEach(arg_0 -> ((Schema)scoringOutputColumns).addColumn(arg_0));
            DatasetPairLineage finalDatasetPairLineage = recipeLineage.getDatasetPairLineage(inputDatasetName, outputDatasetName);
            for (Map.Entry entry : params.preprocessing.per_feature.entrySet()) {
                String featureName = (String)entry.getKey();
                FeaturePreprocessingParams featurePreprocessingParams = (FeaturePreprocessingParams)entry.getValue();
                if (!this.shouldIncludeInLineage(featurePreprocessingParams, new ClusteringModelDetails()) || !recipeLineage.getDatasetPairLineage(inputDatasetName, outputDatasetName).getOutputColumns().contains(featureName)) continue;
                scoringOutputColumns.columns.forEach(col -> finalDatasetPairLineage.addFactorizedColumnRelations(featureName, col.getName()));
            }
            recipeLineage.keepValidRelations();
            return recipeLineage;
        }
    }
}

