/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.businessapps;

import com.dataiku.dip.businessapps.BusinessAppCodes;
import com.dataiku.dip.businessapps.BusinessAppsDAO;
import com.dataiku.dip.businessapps.model.BusinessApp;
import com.dataiku.dip.businessapps.model.BusinessAppSettings;
import com.dataiku.dip.businessapps.model.CreateOrUpgradeInstanceParams;
import com.dataiku.dip.businessapps.model.CreateOrUpgradeInstanceResult;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.ProjectCodeEnvsSelection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dashboards.insights.runnable.DSSRunnableInsightParams;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.InsightParams;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.projects.importexport.ProjectImporter;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.trust.FingerprintService;
import com.dataiku.dip.security.trust.TrustedCodeService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackendInfra;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessAppsCreateInstanceService {
    @Autowired
    private BusinessAppsDAO businessAppsDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private WebAppsService webAppService;
    @Autowired
    private TrustedCodeService trustedCodeService;
    @Autowired
    private FingerprintService fingerprintService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.businessapps.instances.create");

    public FutureResponse<CreateOrUpgradeInstanceResult> createInstance(DSSAuthCtx authCtx, CreateOrUpgradeInstanceParams params) throws Exception {
        CreateBusinessAppInstanceFutureThread ft = new CreateBusinessAppInstanceFutureThread(authCtx, params);
        return this.futureService.runFuture(ft, 50L, new TypeToken<FutureResponse<CreateOrUpgradeInstanceResult>>(){});
    }

    private static FuturePayload buildFuturePayload(String appId, String projectKey) {
        FuturePayload fp = new FuturePayload();
        fp.action = "create_instance";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(appId, appId, appId, "INSTANCE", "BUSINESS_APP"));
        fp.withExtra("instanceProjectKey", (Object)projectKey);
        fp.displayName = "Creating Business Application instance";
        return fp;
    }

    private static SerializedProject.PermissionItem createProjectAdminPermission(String login) {
        SerializedProject.PermissionItem pi = new SerializedProject.PermissionItem();
        pi.user = login;
        pi.admin = true;
        return pi;
    }

    private class CreateBusinessAppInstanceFutureThread
    extends FutureThread<CreateOrUpgradeInstanceResult> {
        private final CreateOrUpgradeInstanceResult result;
        private final CreateOrUpgradeInstanceParams params;
        private final FuturePayload futurePayload;

        public CreateBusinessAppInstanceFutureThread(DSSAuthCtx authCtx, CreateOrUpgradeInstanceParams params) {
            super(authCtx);
            this.result = new CreateOrUpgradeInstanceResult();
            this.params = params;
            this.futurePayload = BusinessAppsCreateInstanceService.buildFuturePayload(params.businessAppId, params.projectKey);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public CreateOrUpgradeInstanceResult getResult() {
            return this.result;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() {
            block6: {
                try {
                    BusinessApp businessApp = BusinessAppsCreateInstanceService.this.businessAppsDAO.getMandatory(this.params.businessAppId, BusinessAppsDAO.ReadOption.READ_DESCRIPTOR, BusinessAppsDAO.ReadOption.READ_SETTINGS, BusinessAppsDAO.ReadOption.READ_CODEENV);
                    File archive = BusinessAppsCreateInstanceService.this.businessAppsDAO.getArchive(businessApp.desc.id);
                    String projectKey = this.computeProjectKey();
                    String runAsUser = this.getRunAsUser(businessApp.settings, this.params.runAsUser);
                    this.processImport(businessApp, archive, projectKey, runAsUser);
                    if (!StringUtils.isNotBlank((String)businessApp.desc.webAppId)) break block6;
                    try {
                        this.trustWebAppBackend(businessApp, projectKey, runAsUser);
                    }
                    catch (Exception e) {
                        this.result.withWarning(BusinessAppCodes.WARN_BUSINESS_APP_UNABLE_TO_TRUST, "Unable to trust the backend for everybody.");
                        logger.warn((Object)"Unable to trust webapp backend", (Throwable)e);
                    }
                    try {
                        this.startWebAppBackend(businessApp, projectKey);
                    }
                    catch (Exception e) {
                        this.result.withWarning(BusinessAppCodes.WARN_BUSINESS_APP_UNABLE_TO_START_WEBAPP, "Unable to automatically start the backend. You might need to manually start it to use the application.");
                        logger.warn((Object)"Unable to start webapp backend", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to create Business Application instance: ", (Throwable)e);
                    this.result.withError(BusinessAppCodes.ERR_BUSINESS_APP_CREATE_INSTANCE, e.getMessage());
                }
            }
        }

        private String getRunAsUser(BusinessAppSettings settings, String login) throws IOException {
            String runAsUser;
            String currentUser = this.owner.getIdentifier();
            String string = runAsUser = StringUtils.isNotBlank((String)login) && settings.allowRunAsUserOverride ? login : settings.defaultRunAsUser;
            if (StringUtils.isBlank((String)runAsUser) || "%%INSTANCE_OWNER%%".equals(runAsUser) || currentUser.equals(runAsUser)) {
                return currentUser;
            }
            try (Transaction ignored = BusinessAppsCreateInstanceService.this.transactionService.beginRead();){
                if (BusinessAppsCreateInstanceService.this.usersDAO.getOrNullUnsafe(runAsUser) == null) {
                    String errorMsg = settings.allowRunAsUserOverride ? "User '%s' does not exist" : "Default user '%s' does not exist. Update the settings of the Business Application or ask your DSS administrator to do it.";
                    throw new IllegalArgumentException(String.format(errorMsg, runAsUser));
                }
            }
            return runAsUser;
        }

        private String computeProjectKey() throws IOException {
            StringTransmogrifier st2 = new StringTransmogrifier();
            try (Transaction ignored = BusinessAppsCreateInstanceService.this.transactionService.beginRead();){
                for (String s : BusinessAppsCreateInstanceService.this.projectsService.listProjectKeys()) {
                    st2.addAlreadyTransmogrified(s);
                }
            }
            String projectKey = StringUtils.isBlank((String)this.params.projectKey) ? this.params.businessAppId : this.params.projectKey;
            return st2.transmogrify(projectKey);
        }

        private void processImport(final BusinessApp businessApp, File archive, String targetProjectKey, final String runAsUser) throws Exception {
            ProjectImporter.ProjectImportSettings importSettings = new ProjectImporter.ProjectImportSettings();
            importSettings.targetProjectKey = targetProjectKey;
            importSettings.importType = "BUSINESS_APP";
            importSettings.targetProjectFolderId = null;
            importSettings.remapping = (ProjectRemappingSettings)JSON.deepCopy((Object)businessApp.settings.remapping);
            importSettings.remapping.connections = importSettings.remapping.connections.stream().filter(mapping -> StringUtils.isNotBlank((String)mapping.target)).toList();
            ProjectImporter pi = new ProjectImporter(this.owner, archive, importSettings, true){

                @Override
                protected void preSaveHook(SerializedProject sp) throws IOException {
                    super.preSaveHook(sp);
                    sp.name = StringUtils.isBlank((String)CreateBusinessAppInstanceFutureThread.this.params.projectName) ? businessApp.desc.name : CreateBusinessAppInstanceFutureThread.this.params.projectName;
                    sp.shortDesc = CreateBusinessAppInstanceFutureThread.this.params.shortDesc;
                    sp.projectType = SerializedProject.ProjectType.BUSINESS_APP;
                    sp.businessAppId = businessApp.desc.id;
                    sp.businessAppVersion = businessApp.desc.version;
                    sp.businessAppWebAppId = businessApp.desc.webAppId;
                    if (businessApp.settings != null) {
                        if (businessApp.settings.container != null) {
                            sp.settings.container = new ContainerExecSelection(businessApp.settings.container);
                        }
                        if (businessApp.settings.containerForVisualRecipesWorkloads != null) {
                            sp.settings.containerForVisualRecipesWorkloads = new ContainerExecSelection(businessApp.settings.containerForVisualRecipesWorkloads);
                        }
                    }
                    if (StringUtils.isNotBlank((String)businessApp.desc.codeEnvName)) {
                        if (sp.settings.codeEnvs == null) {
                            sp.settings.codeEnvs = new ProjectCodeEnvsSelection();
                        }
                        if (businessApp.codeEnvLang == CodeEnvModel.EnvLang.PYTHON || businessApp.codeEnvLang == null) {
                            sp.settings.codeEnvs.python.mode = CodeEnvSelection.EnvMode.EXPLICIT_ENV;
                            sp.settings.codeEnvs.python.envName = businessApp.desc.codeEnvName;
                        } else if (businessApp.codeEnvLang == CodeEnvModel.EnvLang.R) {
                            sp.settings.codeEnvs.r.mode = CodeEnvSelection.EnvMode.EXPLICIT_ENV;
                            sp.settings.codeEnvs.r.envName = businessApp.desc.codeEnvName;
                        }
                    }
                    if (!runAsUser.equals(CreateBusinessAppInstanceFutureThread.this.owner.getIdentifier())) {
                        sp.permissions.add(BusinessAppsCreateInstanceService.createProjectAdminPermission(runAsUser));
                    }
                }

                @Override
                protected void adjustRunAsUsers() throws IOException {
                    for (TaggableObjectsService.TaggableObject item : this.scenariosDAO.list(this.targetProjectKey)) {
                        item.runAsUser = runAsUser;
                        this.scenariosDAO.save(this.targetProjectKey, item.getId(), (Scenario)item);
                    }
                    for (TaggableObjectsService.TaggableObject item : this.webAppsDAO.list(this.targetProjectKey)) {
                        ((WebApp)item).params.runAs = runAsUser;
                        if (StringUtils.equals((String)((WebApp)item).id, (String)businessApp.desc.webAppId) && businessApp.settings != null && businessApp.settings.container != null) {
                            if (((WebApp)item).params.infra == null) {
                                ((WebApp)item).params.infra = new WebAppBackendInfra();
                            }
                            ((WebApp)item).params.infra.containerSelection = new ContainerExecSelection(businessApp.settings.container);
                        }
                        this.webAppsDAO.save((WebApp)item);
                    }
                    for (Insight insight : this.insightsDAO.list(this.targetProjectKey)) {
                        InsightParams insightParams = insight.params;
                        if (!(insightParams instanceof DSSRunnableInsightParams)) continue;
                        DSSRunnableInsightParams runnableInsightParams = (DSSRunnableInsightParams)insightParams;
                        runnableInsightParams.runAsUser = runAsUser;
                        this.insightsDAO.save(insight);
                    }
                }
            };
            ProjectImporter.ProjectImportResult importResult = pi.importProject(this.owner);
            this.result.messages.addAll(importResult.messages.stream().filter(m -> m.severity != InfoMessage.Severity.SUCCESS).toList());
            this.result.summarize();
            this.result.projectKey = targetProjectKey;
            this.result.businessAppWebAppId = businessApp.desc.webAppId;
        }

        private void trustWebAppBackend(BusinessApp app, String projectKey, String runAsLogin) throws IOException, DKUSecurityException, SQLException {
            String fingerprint;
            try (Transaction ignored = BusinessAppsCreateInstanceService.this.transactionService.beginRead();){
                WebApp webApp = BusinessAppsCreateInstanceService.this.webAppService.getMandatoryUnsafe(projectKey, app.desc.webAppId);
                UsersDAO.User user = BusinessAppsCreateInstanceService.this.usersDAO.getMandatoryUnsafe(runAsLogin);
                fingerprint = BusinessAppsCreateInstanceService.this.fingerprintService.computeWebAppFingerprint(webApp, DSSAuthCtx.forUserLogin(user));
            }
            BusinessAppsCreateInstanceService.this.trustedCodeService.trustBusinessApplicationWebApp_NT(this.owner, projectKey, app.desc.webAppId, fingerprint);
        }

        private void startWebAppBackend(BusinessApp app, String projectKey) throws IOException {
            WebApp webApp;
            try (Transaction ignored = BusinessAppsCreateInstanceService.this.transactionService.beginRead();){
                webApp = BusinessAppsCreateInstanceService.this.webAppService.getMandatoryUnsafe(projectKey, app.desc.webAppId);
            }
            if (webApp != null && webApp.params.isBackendEnabled() && !webApp.params.isAutoStartBackend()) {
                try {
                    if (!BusinessAppsCreateInstanceService.this.futureService.waitForFinalResponse(BusinessAppsCreateInstanceService.this.webAppService.restartBackend_NT((AuthCtx)this.owner, (WebApp)webApp)).hasResult) {
                        throw new RuntimeException("Failed to start backend of the new instance");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.errorV((Throwable)e, "Interrupted while waiting for web app backend for instance '%s' of Business Application '%s' to start", new Object[]{projectKey, app.desc.id});
                    throw new RuntimeException("Backend start operation aborted");
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Failed to start web app backend for instance '%s' of Business Application '%s'", new Object[]{projectKey, app.desc.id});
                    throw new RuntimeException("Failed to start backend of the new instance", e);
                }
            }
        }
    }
}

