/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.llm.LLMSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.code.ProjectCodeEnvsSelection;
import com.dataiku.dip.codestudio.CodeStudioRegistry;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetMeta;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.plugins.model.CustomCodeRecipeDesc;
import com.dataiku.dip.recipes.MetaWithFixedCodeEnv;
import com.dataiku.dip.recipes.MetaWithModelCodeEnv;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnvContainerPayload;
import com.dataiku.dip.recipes.ParamsWithFixedCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.SelectableCodeEnvContainer;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeMeta;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportsDAO;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioMeta;
import com.dataiku.dip.scheduler.scenarios.ScenarioRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.webapps.plugins.CustomWebAppMeta;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeEnvUsagesService {
    private static final String PROJECT_NOT_ACCESSIBLE_REF = "PROJECT_NOT_ACCESSIBLE_";
    private static final String OBJECT_NOT_ACCESSIBLE_REF = "OBJECT_NOT_ACCESSIBLE";
    public static final String GLOBAL_NO_PROJECT = "__DKU_ANY_PROJECT__";
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private ReportsDAO reportsDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private PredictionSMMgmtService predictionSMMgmtService;
    @Autowired
    private ClusteringSMMgmtService clusteringSMMgmtService;
    @Autowired
    private LLMSMMgmtService llmSMMgmtService;
    @Autowired
    private MLBaseService mLBaseService;
    @Autowired
    private LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private CodeStudioTemplatesDAO codeStudioTemplatesDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.code.envs.usages");

    public List<CodeEnvModel.CodeEnvUsage> listUsagesAnonymize_NT(AuthCtx authCtx, CodeEnvModel.UsedCodeEnvRef env, String ... projectKeys) throws IOException {
        Set projectsHavingPrivileges;
        List<CodeEnvModel.CodeEnvUsage> codeEnvUsages = this.listUsages(env, projectKeys);
        try (Transaction t = this.transactionService.beginRead();){
            projectsHavingPrivileges = codeEnvUsages.stream().map(c2 -> c2.projectKey).distinct().filter(p -> {
                try {
                    if (GLOBAL_NO_PROJECT.equals(p)) {
                        return authCtx.isAdmin();
                    }
                    return this.permissionsService.hasProjectPrivilege(authCtx, (String)p, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Couldn't get project privilege for project '%s'", new Object[]{p});
                    return false;
                }
            }).collect(Collectors.toSet());
        }
        return codeEnvUsages.stream().map(c2 -> {
            if (projectsHavingPrivileges.contains(c2.projectKey)) {
                return c2;
            }
            c2.projectKey = PROJECT_NOT_ACCESSIBLE_REF + c2.projectKey.hashCode();
            c2.objectId = OBJECT_NOT_ACCESSIBLE_REF;
            c2.notAccessible();
            return c2;
        }).collect(Collectors.toList());
    }

    public List<CodeEnvModel.CodeEnvUsage> listUsages(CodeEnvModel.UsedCodeEnvRef env, String ... projectKeys) throws IOException {
        if (projectKeys == null || projectKeys.length == 0) {
            ArrayList allProjectKeys = Lists.newArrayList(this.projectsService.listKeys());
            allProjectKeys.add(GLOBAL_NO_PROJECT);
            return this.listUsages(env, allProjectKeys);
        }
        return this.listUsages(env, Arrays.asList(projectKeys));
    }

    public List<CodeEnvModel.CodeEnvUsage> listUsages(CodeEnvModel.UsedCodeEnvRef env, List<String> projectKeys) throws IOException {
        assert (projectKeys != null);
        ArrayList usages = Lists.newArrayList();
        for (String projectKey : projectKeys) {
            usages.addAll(this.listUsages(env, projectKey));
        }
        return usages;
    }

    public List<CodeEnvModel.CodeEnvUsage> listUsages(CodeEnvModel.UsedCodeEnvRef env, String projectKey) throws IOException {
        Transaction t;
        List savedModelList;
        List<AnalysisCoreParams> analysisCoreParamsList;
        assert (StringUtils.isNotBlank((String)projectKey));
        ArrayList usages = Lists.newArrayList();
        if (GLOBAL_NO_PROJECT.equals(projectKey)) {
            try (Transaction t2 = this.transactionService.retrieveOrBeginRead();){
                for (CodeStudioTemplate template : this.codeStudioTemplatesDAO.listUnsafe()) {
                    try {
                        usages.addAll(CodeStudioRegistry.getMeta(template).collectUsages(template));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to check usages in Code Studio template . Skipping.", (Throwable)e);
                    }
                }
            }
        }
        try (Transaction t3 = this.transactionService.retrieveOrBeginRead();){
            usages.addAll(this.listUsages(this.projectsService.getMandatoryUnsafe(projectKey)));
            try {
                for (JupyterUtils.JupyterNotebookListEntry listEntry : this.jupyterService.listUnsafe(null, projectKey)) {
                    usages.addAll(this.listUsages(listEntry));
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check usages in notebooks . Skipping.", (Throwable)e);
            }
            try {
                for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
                    usages.addAll(this.listUsages(sr));
                }
            }
            catch (Throwable e) {
                logger.warn((Object)"Failed to check usages in recipes . Skipping.", e);
            }
            try {
                for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
                    usages.addAll(this.listUsages(sd));
                }
            }
            catch (Throwable e) {
                logger.warn((Object)"Failed to check usages in datasets . Skipping.", e);
            }
            try {
                for (Scenario scenario : this.scenariosDAO.listUnsafe(projectKey)) {
                    usages.addAll(this.listUsages(scenario));
                }
            }
            catch (Throwable e) {
                logger.warn((Object)"Failed to check usages in scenarios . Skipping.", e);
            }
            try {
                for (WebApp webApp : this.webAppsDAO.listUnsafe(projectKey)) {
                    usages.addAll(this.listUsages(webApp));
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check usages in webapps . Skipping.", (Throwable)e);
            }
            try {
                for (Report report : this.reportsDAO.listUnsafe(projectKey)) {
                    usages.addAll(this.listUsages(report));
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check usages in reports . Skipping.", (Throwable)e);
            }
            try {
                for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.listUnsafe(projectKey)) {
                    usages.addAll(this.listUsages(rk));
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check usages in retrievable knowledges . Skipping.", (Throwable)e);
            }
            try {
                for (AgentTool tool : this.agentToolsDAO.list(projectKey)) {
                    usages.addAll(this.listUsages(tool));
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check usages in agent tools . Skipping.", (Throwable)e);
            }
            try {
                for (LambdaService service : this.lambdaServicesDAO.listUnsafe(projectKey)) {
                    usages.addAll(this.listUsages(service));
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check usages in reports . Skipping.", (Throwable)e);
            }
            analysisCoreParamsList = this.analysisCRUDService.listCoreUnsafe(projectKey, null);
            savedModelList = this.savedModelsDAO.listUnsafe(projectKey);
        }
        for (AnalysisCoreParams acp : analysisCoreParamsList) {
            try {
                t = this.transactionService.retrieveOrBeginRead();
                try {
                    usages.addAll(this.listUsages(acp));
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check usages in analyses . Skipping.", (Throwable)e);
            }
        }
        for (SavedModel sm : savedModelList) {
            try {
                t = this.transactionService.retrieveOrBeginRead();
                try {
                    usages.addAll(this.listUsages(sm));
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check usages in saved models. Skipping", (Throwable)e);
            }
        }
        if (env != null) {
            logger.info((Object)"Filtering usages to a single env");
            ArrayList filteredUsages = Lists.newArrayList();
            for (CodeEnvModel.CodeEnvUsage usage : usages) {
                if (usage.envLang != env.envLang || !StringUtils.equals((String)usage.envName, (String)env.envName)) continue;
                filteredUsages.add(usage);
            }
            return filteredUsages;
        }
        return usages;
    }

    /*
     * WARNING - void declaration
     */
    public List<CodeEnvModel.CodeEnvUsage> listUsages(TaggableObjectsService.TaggableObject object) throws IOException {
        String projectKey = object.getProjectKey();
        ArrayList usages = Lists.newArrayList();
        if (object instanceof SerializedProject) {
            String string;
            SerializedProject sp = (SerializedProject)object;
            ProjectCodeEnvsSelection projectEnvSettings = sp.settings.codeEnvs;
            String pythonDefault = new CodeEnvSelector().getProjectDefault(CodeEnvModel.EnvLang.PYTHON, projectEnvSettings);
            if (pythonDefault != null) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, pythonDefault, CodeEnvModel.EnvUsage.PROJECT, projectKey, null));
            }
            if ((string = new CodeEnvSelector().getProjectDefault(CodeEnvModel.EnvLang.R, projectEnvSettings)) != null) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.R, string, CodeEnvModel.EnvUsage.PROJECT, projectKey, null));
            }
        } else if (object instanceof JupyterUtils.JupyterNotebookListEntry) {
            JupyterUtils.JupyterNotebookListEntry listEntry = (JupyterUtils.JupyterNotebookListEntry)object;
            RelFile rf = this.jupyterService.getNotebookFile(projectKey, listEntry.name);
            TransactionRef t = TransactionContext.retrieveRead();
            JsonObject jsonObject = (JsonObject)t.readObjectUnsafe(rf, JsonObject.class);
            JupyterCodeEnvUtils.NotebookCodeEnvInfo kernelInfo = JupyterCodeEnvUtils.getCodeEnvInfoFromNotebook(jsonObject);
            if (kernelInfo != null && kernelInfo.envLang != null) {
                usages.add(new CodeEnvModel.CodeEnvUsage(kernelInfo.envLang, kernelInfo.envName, CodeEnvModel.EnvUsage.NOTEBOOK, projectKey, listEntry.name));
            }
        } else if (object instanceof AnalysisCoreParams) {
            usages.addAll(this.listAnalysesUsages((AnalysisCoreParams)object));
        } else if (object instanceof SavedModel) {
            usages.addAll(this.listSavedModelUsages((SavedModel)object));
        } else if (object instanceof SerializedRecipe) {
            SerializedRecipe sr = (SerializedRecipe)object;
            RecipeMeta recipeMeta = RecipeRegistry.getMeta(sr.type);
            if (recipeMeta.getCategoryFlags().isPlugin) {
                void var8_32;
                CustomCodeRecipeMeta customRecipeMeta = (CustomCodeRecipeMeta)recipeMeta;
                Object var8_29 = null;
                if (customRecipeMeta.getPluginDesc().desc.kind == CustomCodeRecipeDesc.CustomRecipeLanguage.PYTHON) {
                    CodeEnvModel.EnvLang envLang = CodeEnvModel.EnvLang.PYTHON;
                } else if (customRecipeMeta.getPluginDesc().desc.kind == CustomCodeRecipeDesc.CustomRecipeLanguage.R) {
                    CodeEnvModel.EnvLang envLang = CodeEnvModel.EnvLang.R;
                }
                if (var8_32 != null) {
                    LoadedCustomCodeRecipeDesc recipeDesc = customRecipeMeta.getPluginDesc();
                    String envName = new CodeEnvSelector().getCodeEnvNameForPlugin(recipeDesc.ownerPluginId);
                    if (envName != null) {
                        usages.add(new CodeEnvModel.CodeEnvUsage((CodeEnvModel.EnvLang)var8_32, envName, CodeEnvModel.EnvUsage.RECIPE, projectKey, sr.getId()));
                    }
                }
            } else {
                for (ParamsWithSelectableCodeEnv paramsWithSelectableCodeEnv : this.listParamsWithSelectableCodeEnv(object)) {
                    usages.addAll(paramsWithSelectableCodeEnv.collectCodeEnvUsage(object));
                }
                for (ParamsWithFixedCodeEnv paramsWithFixedCodeEnv : this.listParamsWithFixedCodeEnv(object)) {
                    usages.addAll(paramsWithFixedCodeEnv.collectCodeEnvUsage(object));
                }
                usages.addAll(this.listUsagesWithModelCodeEnv((SerializedRecipe)object));
                for (ParamsWithSelectableCodeEnv paramsWithSelectableCodeEnv : this.listPayloadParamsWithSelectableCodeEnv(sr)) {
                    usages.addAll(paramsWithSelectableCodeEnv.collectCodeEnvUsage(object));
                }
            }
        } else if (object instanceof SerializedDataset) {
            SerializedDataset sd = (SerializedDataset)object;
            DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(sd.type);
            if (meta instanceof CustomPythonDatasetMeta) {
                String pluginId = ((CustomPythonDatasetMeta)meta).getDesc().getOwnerPluginId();
                String string = new CodeEnvSelector().getCodeEnvNameForPlugin(pluginId);
                if (string != null) {
                    usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, string, CodeEnvModel.EnvUsage.DATASET, projectKey, sd.getId()));
                }
            } else {
                for (ParamsWithSelectableCodeEnv paramsWithSelectableCodeEnv : this.listParamsWithSelectableCodeEnv(object)) {
                    usages.addAll(paramsWithSelectableCodeEnv.collectCodeEnvUsage(object));
                }
            }
        } else if (object instanceof Scenario) {
            for (ParamsWithSelectableCodeEnv params : this.listParamsWithSelectableCodeEnv(object)) {
                usages.addAll(params.collectCodeEnvUsage(object));
            }
        } else if (object instanceof WebApp) {
            CustomWebAppMeta customWebAppMeta;
            String pluginId;
            for (ParamsWithSelectableCodeEnv params : this.listParamsWithSelectableCodeEnv(object)) {
                usages.addAll(params.collectCodeEnvUsage(object));
            }
            WebAppMeta webAppMeta = WebAppRegistry.getMeta(((WebApp)object).type);
            if (webAppMeta instanceof CustomWebAppMeta && (pluginId = (customWebAppMeta = (CustomWebAppMeta)webAppMeta).getOwnerPluginId()) != null) {
                String string = new CodeEnvSelector().getCodeEnvNameForPlugin(pluginId);
                CodeEnvModel.EnvLang envLang = customWebAppMeta.getEnvLang();
                if (string != null && envLang != null) {
                    usages.add(new CodeEnvModel.CodeEnvUsage(envLang, string, CodeEnvModel.EnvUsage.WEBAPP, object.getProjectKey(), object.getId()));
                }
            }
        } else if (object instanceof Report) {
            for (ParamsWithSelectableCodeEnv params : this.listParamsWithSelectableCodeEnv(object)) {
                usages.addAll(params.collectCodeEnvUsage(object));
            }
        } else if (object instanceof LambdaService) {
            for (ParamsWithSelectableCodeEnv params : this.listParamsWithSelectableCodeEnv(object)) {
                usages.addAll(params.collectCodeEnvUsage(object));
            }
        } else if (object instanceof RetrievableKnowledge) {
            usages.addAll(((RetrievableKnowledge)object).collectCodeEnvUsage(object));
        } else if (object instanceof AgentTool) {
            AgentTool at = (AgentTool)object;
            usages.addAll(at.collectCodeEnvUsage(object));
        }
        return usages;
    }

    private List<CodeEnvModel.CodeEnvUsage> listAnalysesUsages(AnalysisCoreParams acp) throws IOException {
        ArrayList<CodeEnvModel.CodeEnvUsage> usages = new ArrayList<CodeEnvModel.CodeEnvUsage>();
        for (MLTask mlTask : this.analysisCRUDService.listRawMLTasks(acp.projectKey, acp.id)) {
            usages.addAll(mlTask.collectCodeEnvUsage(acp));
            MLTaskLoc loc = new MLTaskLoc(acp.projectKey, acp.id, mlTask.id);
            for (FullModelId fmi : this.mLBaseService.listCompletedModelIds(loc)) {
                usages.addAll(fmi.collectCodeEnvUsage(CodeEnvModel.EnvUsage.MODEL));
            }
        }
        return usages;
    }

    public List<FullModelId> listFmisInSavedModel(SavedModel sm) {
        switch (sm.getType()) {
            case PREDICTION: {
                return this.predictionSMMgmtService.listUsableVersions(sm);
            }
            case CLUSTERING: {
                return this.clusteringSMMgmtService.listUsableVersions(sm);
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                return this.llmSMMgmtService.listUsableVersions(sm);
            }
        }
        return Collections.emptyList();
    }

    private List<CodeEnvModel.CodeEnvUsage> listSavedModelUsages(SavedModel sm) throws IOException {
        ArrayList<CodeEnvModel.CodeEnvUsage> usages = new ArrayList<CodeEnvModel.CodeEnvUsage>();
        List<FullModelId> fmis = this.listFmisInSavedModel(sm);
        for (FullModelId fmi : fmis) {
            usages.addAll(fmi.collectCodeEnvUsage(CodeEnvModel.EnvUsage.SAVED_MODEL));
        }
        return usages;
    }

    private List<CodeEnvModel.CodeEnvUsage> listUsagesWithModelCodeEnv(SerializedRecipe sr) throws IOException {
        List<SerializedRecipe.RecipeInput> modelInputs;
        ArrayList<CodeEnvModel.CodeEnvUsage> usages = new ArrayList<CodeEnvModel.CodeEnvUsage>();
        RecipeMeta recipeMeta = RecipeRegistry.getMeta(sr.type);
        if (recipeMeta instanceof MetaWithModelCodeEnv && !(modelInputs = sr.getInputsForRole("model")).isEmpty()) {
            SavedModel inputModel = (SavedModel)this.savedModelsDAO.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(sr.projectKey, modelInputs.get((int)0).ref));
            FullModelId fmi = new FullModelId(inputModel.projectKey, inputModel.id, inputModel.activeVersion);
            usages.addAll(fmi.collectCodeEnvUsage(CodeEnvModel.EnvUsage.RECIPE));
        }
        return usages;
    }

    public List<ParamsWithFixedCodeEnv> listParamsWithFixedCodeEnv(TaggableObjectsService.TaggableObject object) throws IOException {
        ArrayList usages = Lists.newArrayList();
        if (object instanceof SerializedRecipe) {
            String payload;
            SerializedRecipe sr = (SerializedRecipe)object;
            RecipeMeta recipeMeta = RecipeRegistry.getMeta(sr.type);
            if (recipeMeta instanceof MetaWithFixedCodeEnv && StringUtils.isNotBlank((String)(payload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name)))) {
                ParamsWithFixedCodeEnv params = (ParamsWithFixedCodeEnv)JSON.parse((String)payload, ((MetaWithFixedCodeEnv)((Object)recipeMeta)).getCodeEnvBearingParamsClass());
                usages.add(params);
            }
        }
        return usages;
    }

    public List<SelectableCodeEnvContainer> listParamsWithSelectableCodeEnvContainer(TaggableObjectsService.TaggableObject object) throws IOException {
        ArrayList usages = Lists.newArrayList();
        if (object instanceof SerializedRecipe) {
            String payload;
            SerializedRecipe sr = (SerializedRecipe)object;
            RecipeMeta recipeMeta = RecipeRegistry.getMeta(sr.type);
            if (recipeMeta instanceof MetaWithSelectableCodeEnvContainerPayload && StringUtils.isNotBlank((String)(payload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name)))) {
                SelectableCodeEnvContainer params = (SelectableCodeEnvContainer)JSON.parse((String)payload, ((MetaWithSelectableCodeEnvContainerPayload)((Object)recipeMeta)).getCodeEnvBearingParamsClass());
                usages.add(params);
            }
        }
        return usages;
    }

    public List<ParamsWithSelectableCodeEnv> listParamsWithSelectableCodeEnv(TaggableObjectsService.TaggableObject object) throws IOException {
        ArrayList usages = Lists.newArrayList();
        if (object instanceof SerializedRecipe) {
            SerializedRecipe sr = (SerializedRecipe)object;
            RecipeMeta recipeMeta = RecipeRegistry.getMeta(sr.type);
            if (recipeMeta instanceof MetaWithSelectableCodeEnv) {
                usages.add((ParamsWithSelectableCodeEnv)((Object)sr.params));
            }
            if (SelectableCodeEnvContainer.class.isAssignableFrom(recipeMeta.paramsClass())) {
                usages.addAll(((SelectableCodeEnvContainer)((Object)sr.params)).collectCodeEnvUsers());
            }
        } else if (object instanceof SerializedDataset) {
            SerializedDataset sd = (SerializedDataset)object;
            usages.addAll(sd.collectCodeEnvUsers());
        } else if (object instanceof Scenario) {
            Scenario scenario = (Scenario)object;
            ScenarioMeta scenarioMeta = ScenarioRegistry.getMeta(scenario.getType());
            if (scenarioMeta instanceof MetaWithSelectableCodeEnv) {
                usages.add((ParamsWithSelectableCodeEnv)((Object)scenario.getParams()));
            }
            usages.addAll(scenario.collectCodeEnvUsers());
        } else if (object instanceof WebApp) {
            WebApp webApp = (WebApp)object;
            WebAppMeta webAppMeta = WebAppRegistry.getMeta(webApp.type);
            if (webAppMeta instanceof MetaWithSelectableCodeEnv) {
                usages.add((ParamsWithSelectableCodeEnv)((Object)webApp.params));
            }
        } else if (object instanceof Report) {
            Report report = (Report)object;
            if (report instanceof MetaWithSelectableCodeEnv) {
                usages.add(report.params);
            }
        } else if (object instanceof LambdaService) {
            LambdaService service = (LambdaService)object;
            usages.addAll(service.collectCodeEnvUsers());
        } else if (object instanceof RetrievableKnowledge) {
            RetrievableKnowledge rk = (RetrievableKnowledge)object;
            usages.add(rk);
        } else if (object instanceof AgentTool) {
            AgentTool at = (AgentTool)object;
            usages.add(at);
        }
        return usages;
    }

    public List<ParamsWithSelectableCodeEnv> listPayloadParamsWithSelectableCodeEnv(SerializedRecipe sr) throws IOException {
        String payload;
        ArrayList usages = Lists.newArrayList();
        RecipeMeta recipeMeta = RecipeRegistry.getMeta(sr.type);
        if (recipeMeta instanceof MetaWithSelectableCodeEnvContainerPayload && StringUtils.isNotBlank((String)(payload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name)))) {
            SelectableCodeEnvContainer paramsContainer = (SelectableCodeEnvContainer)JSON.parse((String)payload, ((MetaWithSelectableCodeEnvContainerPayload)((Object)recipeMeta)).getCodeEnvBearingParamsClass());
            usages.addAll(paramsContainer.collectCodeEnvUsers());
        }
        return usages;
    }
}

