/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AlloyDBConnection;
import com.dataiku.dip.connections.AnthropicConnection;
import com.dataiku.dip.connections.AthenaConnection;
import com.dataiku.dip.connections.AzureAIFoundryConnection;
import com.dataiku.dip.connections.AzureAISearchConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.AzureLLMConnection;
import com.dataiku.dip.connections.AzureMLConnection;
import com.dataiku.dip.connections.AzureOpenAIConnection;
import com.dataiku.dip.connections.BedrockConnection;
import com.dataiku.dip.connections.BigQueryConnection;
import com.dataiku.dip.connections.CassandraConnection;
import com.dataiku.dip.connections.CohereConnection;
import com.dataiku.dip.connections.CustomLLMConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.DatabricksLLMConnection;
import com.dataiku.dip.connections.DatabricksLakebaseConnection;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.connections.DenodoConnection;
import com.dataiku.dip.connections.DynamoDBConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.connections.FTPConnection;
import com.dataiku.dip.connections.FabricWarehouseConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.GreenplumConnection;
import com.dataiku.dip.connections.H2Connection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.HuggingFaceInferenceAPIConnection;
import com.dataiku.dip.connections.HuggingFaceLocalConnection;
import com.dataiku.dip.connections.IcebergConnection;
import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.connections.JdbcConnection;
import com.dataiku.dip.connections.KDBPlusConnection;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.connections.MistralAIConnection;
import com.dataiku.dip.connections.MongoDBConnection;
import com.dataiku.dip.connections.MosaicMLConnection;
import com.dataiku.dip.connections.MySQLConnection;
import com.dataiku.dip.connections.NetezzaConnection;
import com.dataiku.dip.connections.NvidiaNimConnection;
import com.dataiku.dip.connections.OpenAIConnection;
import com.dataiku.dip.connections.OracleConnection;
import com.dataiku.dip.connections.PineconeConnection;
import com.dataiku.dip.connections.PostgreSQLConnection;
import com.dataiku.dip.connections.RedshiftConnection;
import com.dataiku.dip.connections.RemoteMCPConnection;
import com.dataiku.dip.connections.SAPHANAConnection;
import com.dataiku.dip.connections.SQLServerConnection;
import com.dataiku.dip.connections.SQSConnection;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.connections.SageMakerConnection;
import com.dataiku.dip.connections.SageMakerGenericLLMConnection;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.connections.SnowflakeCortexLLMConnection;
import com.dataiku.dip.connections.StabilityAIConnection;
import com.dataiku.dip.connections.SynapseConnection;
import com.dataiku.dip.connections.TeradataConnection;
import com.dataiku.dip.connections.TreasureDataConnection;
import com.dataiku.dip.connections.TrinoConnection;
import com.dataiku.dip.connections.TwitterConnection;
import com.dataiku.dip.connections.VertexAILLMConnection;
import com.dataiku.dip.connections.VertexAIModelDeploymentConnection;
import com.dataiku.dip.connections.VerticaConnection;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public enum DkuConnectionDeserializer implements JSON.Adapter<DSSConnection>
{
    INSTANCE;

    private static Map<String, Class<? extends DSSConnection>> connectionsMap;
    static DKULogger logger;

    public static void registerType(String type, Class<? extends DSSConnection> connectionClass) {
        connectionsMap.put(type.toUpperCase(), connectionClass);
    }

    public DSSConnection deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.has("type") || jsonObj.get("type") instanceof JsonNull || StringUtils.isBlank((String)jsonObj.get("type").getAsString())) {
            throw ErrorContext.iae((String)"Cannot deserialize connection: 'type' is required");
        }
        String type = jsonObj.get("type").getAsString().toUpperCase();
        Class<? extends DSSConnection> connectionClass = connectionsMap.get(type);
        if (connectionClass == null) {
            logger.error((Object)("Connection type not found: " + type));
            logger.error((Object)("Existing types: " + String.valueOf(connectionsMap.keySet())));
            logger.error((Object)("Received object: " + JSON.prettyLog((Object)jsonObj)));
            return null;
        }
        if (AbstractSQLConnection.class.isAssignableFrom(connectionClass)) {
            DkuConnectionDeserializer.migrateCommentSynchronizationParameters(jsonObj, type);
        }
        try {
            DSSConnection connection = (DSSConnection)jsonDeserializationContext.deserialize((JsonElement)jsonObj, connectionClass);
            connection.type = connection.getType();
            return connection;
        }
        catch (Exception e) {
            logger.error((Object)("FAILED TO DESERIALIZE CONNECTION: " + JSON.prettyLog((Object)jsonObj)), (Throwable)e);
            return null;
        }
    }

    public JsonElement serialize(DSSConnection arg0, Type arg1, JsonSerializationContext arg2) {
        return arg2.serialize((Object)arg0);
    }

    private static void migrateCommentSynchronizationParameters(JsonObject jsonObj, String connectionType) {
        JsonObject namingRule;
        JsonObject params = jsonObj.getAsJsonObject("params");
        JsonObject jsonObject = namingRule = params != null ? params.getAsJsonObject("namingRule") : null;
        if (namingRule != null && namingRule.get("writeDatasetDescriptionAsSQLComment") == null) {
            AbstractSQLConnection.SqlCommentSynchronizationStatus status;
            JsonElement oldWriteDescriptionsParam = namingRule.get("writeDescriptionsAsSQLComment");
            if (oldWriteDescriptionsParam == null) {
                boolean supportsWriteSQLCommentInCreateTableStatement = Set.of("SNOWFLAKE", "BIGQUERY", "DATABRICKS", "MYSQL").contains(connectionType);
                params.addProperty("writeDatasetDescriptionAsSQLComment", Boolean.valueOf(supportsWriteSQLCommentInCreateTableStatement));
                params.addProperty("writeColumnDescriptionsAsSQLComment", Boolean.valueOf(supportsWriteSQLCommentInCreateTableStatement));
                status = AbstractSQLConnection.SqlCommentSynchronizationStatus.INHERIT;
            } else {
                status = oldWriteDescriptionsParam.getAsBoolean() ? AbstractSQLConnection.SqlCommentSynchronizationStatus.ENABLED : AbstractSQLConnection.SqlCommentSynchronizationStatus.DISABLED;
            }
            namingRule.addProperty("writeDatasetDescriptionAsSQLComment", status.toString());
            namingRule.addProperty("writeColumnDescriptionsAsSQLComment", status.toString());
        }
    }

    static {
        connectionsMap = new HashMap<String, Class<? extends DSSConnection>>();
        DkuConnectionDeserializer.registerType("Azure", AzureConnection.class);
        DkuConnectionDeserializer.registerType("Cassandra", CassandraConnection.class);
        DkuConnectionDeserializer.registerType("EC2", EC2Connection.class);
        DkuConnectionDeserializer.registerType("ElasticSearch", ElasticSearchConnection.class);
        DkuConnectionDeserializer.registerType("DynamoDB", DynamoDBConnection.class);
        DkuConnectionDeserializer.registerType("Filesystem", FsConnection.class);
        DkuConnectionDeserializer.registerType("FTP", FTPConnection.class);
        DkuConnectionDeserializer.registerType("HDFS", HDFSConnection.class);
        DkuConnectionDeserializer.registerType("MongoDB", MongoDBConnection.class);
        DkuConnectionDeserializer.registerType("SSH", SSHConnection.class);
        DkuConnectionDeserializer.registerType("Twitter", TwitterConnection.class);
        DkuConnectionDeserializer.registerType("GCS", GCSConnection.class);
        DkuConnectionDeserializer.registerType("SharePointOnline", SharePointOnlineConnection.class);
        DkuConnectionDeserializer.registerType("iceberg", IcebergConnection.class);
        DkuConnectionDeserializer.registerType("Greenplum", GreenplumConnection.class);
        DkuConnectionDeserializer.registerType("Databricks", DatabricksConnection.class);
        DkuConnectionDeserializer.registerType("DatabricksLakebase", DatabricksLakebaseConnection.class);
        DkuConnectionDeserializer.registerType("DatabricksVolume", DatabricksVolumeConnection.class);
        DkuConnectionDeserializer.registerType("H2", H2Connection.class);
        DkuConnectionDeserializer.registerType("hiveserver2", HiveConnection.class);
        DkuConnectionDeserializer.registerType("impala", ImpalaConnection.class);
        DkuConnectionDeserializer.registerType("JDBC", JdbcConnection.class);
        DkuConnectionDeserializer.registerType("MySQL", MySQLConnection.class);
        DkuConnectionDeserializer.registerType("Oracle", OracleConnection.class);
        DkuConnectionDeserializer.registerType("PostgreSQL", PostgreSQLConnection.class);
        DkuConnectionDeserializer.registerType("AlloyDB", AlloyDBConnection.class);
        DkuConnectionDeserializer.registerType("Redshift", RedshiftConnection.class);
        DkuConnectionDeserializer.registerType("SQLServer", SQLServerConnection.class);
        DkuConnectionDeserializer.registerType("FabricWarehouse", FabricWarehouseConnection.class);
        DkuConnectionDeserializer.registerType("Synapse", SynapseConnection.class);
        DkuConnectionDeserializer.registerType("Teradata", TeradataConnection.class);
        DkuConnectionDeserializer.registerType("Vertica", VerticaConnection.class);
        DkuConnectionDeserializer.registerType("Netezza", NetezzaConnection.class);
        DkuConnectionDeserializer.registerType("BigQuery", BigQueryConnection.class);
        DkuConnectionDeserializer.registerType("SAPHANA", SAPHANAConnection.class);
        DkuConnectionDeserializer.registerType("Trino", TrinoConnection.class);
        DkuConnectionDeserializer.registerType("Denodo", DenodoConnection.class);
        DkuConnectionDeserializer.registerType("TreasureData", TreasureDataConnection.class);
        DkuConnectionDeserializer.registerType("KDBPlus", KDBPlusConnection.class);
        DkuConnectionDeserializer.registerType("Kafka", KafkaConnection.class);
        DkuConnectionDeserializer.registerType("Snowflake", SnowflakeConnection.class);
        DkuConnectionDeserializer.registerType("Athena", AthenaConnection.class);
        DkuConnectionDeserializer.registerType("SQS", SQSConnection.class);
        DkuConnectionDeserializer.registerType("SageMaker", SageMakerConnection.class);
        DkuConnectionDeserializer.registerType("AzureML", AzureMLConnection.class);
        DkuConnectionDeserializer.registerType("VertexAIModelDeployment", VertexAIModelDeploymentConnection.class);
        DkuConnectionDeserializer.registerType("DatabricksModelDeployment", DatabricksModelDeploymentConnection.class);
        DkuConnectionDeserializer.registerType("OpenAI", OpenAIConnection.class);
        DkuConnectionDeserializer.registerType("AzureOpenAI", AzureOpenAIConnection.class);
        DkuConnectionDeserializer.registerType("AzureAIFoundry", AzureAIFoundryConnection.class);
        DkuConnectionDeserializer.registerType("VertexAILLM", VertexAILLMConnection.class);
        DkuConnectionDeserializer.registerType("Cohere", CohereConnection.class);
        DkuConnectionDeserializer.registerType("MistralAI", MistralAIConnection.class);
        DkuConnectionDeserializer.registerType("HuggingFaceInferenceAPI", HuggingFaceInferenceAPIConnection.class);
        DkuConnectionDeserializer.registerType("HuggingFaceLocal", HuggingFaceLocalConnection.class);
        DkuConnectionDeserializer.registerType("Anthropic", AnthropicConnection.class);
        DkuConnectionDeserializer.registerType("Bedrock", BedrockConnection.class);
        DkuConnectionDeserializer.registerType("MosaicML", MosaicMLConnection.class);
        DkuConnectionDeserializer.registerType("DatabricksLLM", DatabricksLLMConnection.class);
        DkuConnectionDeserializer.registerType("SnowflakeCortex", SnowflakeCortexLLMConnection.class);
        DkuConnectionDeserializer.registerType("StabilityAI", StabilityAIConnection.class);
        DkuConnectionDeserializer.registerType("CustomLLM", CustomLLMConnection.class);
        DkuConnectionDeserializer.registerType("Pinecone", PineconeConnection.class);
        DkuConnectionDeserializer.registerType("AzureAISearch", AzureAISearchConnection.class);
        DkuConnectionDeserializer.registerType("NVIDIA-NIM", NvidiaNimConnection.class);
        DkuConnectionDeserializer.registerType("RemoteMCP", RemoteMCPConnection.class);
        DkuConnectionDeserializer.registerType("SageMaker-GenericLLM", SageMakerGenericLLMConnection.class);
        DkuConnectionDeserializer.registerType("AzureLLM", AzureLLMConnection.class);
        logger = DKULogger.getLogger((String)"dku.connections.deserializer");
    }
}

