/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SSHConnection
extends DSSConnection
implements ConnectionWithEncryptedFields,
FSProviderizableConnection {
    public Params params = new Params();
    public static final String connectionType = "SSH";

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.host = vc.expand(this.params.host);
        this.params.user = vc.expand(this.params.user);
        this.params.password = vc.expand(this.params.password);
        this.params.passphrase = vc.expand(this.params.passphrase);
        this.params.chroot = vc.expand(this.params.chroot);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void checkConfiguration() throws CodedException, DKUSecurityException {
        if (StringUtils.isBlank((String)this.params.host)) {
            throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_SSH_INVALID_CONFIG, "Host not specified");
        }
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.params.passphrase = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.passphrase);
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.passphrase = cryptoService.decryptIfEncrypted(this.params.passphrase);
    }

    @Override
    public List<String> getProviderTypes() {
        return Lists.newArrayList((Object[])new String[]{"SFTP", "SCP"});
    }

    @Override
    public boolean allowManagedFolders() {
        return this.allowManagedFolders;
    }

    @Override
    protected List<AbstractSQLConnection.CustomDatabaseProperty> getDkuPropertiesInternal() {
        return this.params.dkuProperties;
    }

    @Override
    public boolean isFSLike() {
        return true;
    }

    @Override
    public boolean isFS() {
        return true;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableSSHCredentials.class));
        SerializableSSHCredentials creds = new SerializableSSHCredentials();
        creds.user = this.params.user;
        creds.usePublicKey = this.params.usePublicKey;
        creds.passphrase = this.params.passphrase;
        creds.password = this.params.password;
        return clazz.cast(creds);
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        throw new NotImplementedException();
    }

    public static class Params
    extends DSSConnection.DkuConnectionParams {
        public String host;
        public String user;
        public boolean usePublicKey;
        public String password;
        public String passphrase;
        public int port = 22;
        public String chroot;
        public FSProviderizableConnection.FilesBasedDatasetNamingRule namingRule = new FSProviderizableConnection.FilesBasedDatasetNamingRule();
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    }

    public static class SerializableSSHCredentials {
        public String user;
        public boolean usePublicKey;
        public String password;
        public String passphrase;
    }
}

