/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelection;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.ContainerOverrideMask;
import com.dataiku.dip.containers.exec.ContainerExecCodes;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.KubectlHelper;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.AutoSmartLogTailRedirect;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KubernetesNamespacesService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ClustersDAO clustersDAO;
    @Autowired
    private FutureService futureService;
    private static final Map<String, KubernetesNamespaceCache> namespaceCacheByClusterID = new HashMap<String, KubernetesNamespaceCache>();
    private static final Map<String, Object> k8sNamespaceLocks = new HashMap<String, Object>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.k8s.namespaces");

    private static synchronized Object getK8sNamespaceLock(String namespace) {
        if (!k8sNamespaceLocks.containsKey(namespace)) {
            k8sNamespaceLocks.put(namespace, new Object());
        }
        return k8sNamespaceLocks.get(namespace);
    }

    public static String getNamespace(AuthCtx authCtx, String projectKey, ContainerExecUtils.KubernetesAwareContainerConfig config) {
        String managedNamespace;
        String requestedKubernetesNamespace = config.getRequestedKubernetesNamespace();
        if (StringUtils.contains((String)requestedKubernetesNamespace, (String)"${")) {
            VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
            VariablesContext vc = vs.getForProjectAndUser(authCtx, projectKey);
            managedNamespace = vc.expand(requestedKubernetesNamespace);
        } else {
            managedNamespace = requestedKubernetesNamespace;
        }
        if (StringUtils.isBlank((String)managedNamespace)) {
            return null;
        }
        if (config.ensureNamespaceCompliance) {
            Object compliantNamespaceName = managedNamespace.replaceAll("[^A-Za-z0-9]", "-").toLowerCase(Locale.ENGLISH);
            if (!StringUtils.equals((String)managedNamespace, (String)compliantNamespaceName) || ((String)compliantNamespaceName).length() > 63) {
                int prefixLength = Math.min(56, ((String)compliantNamespaceName).length());
                compliantNamespaceName = ((String)compliantNamespaceName).substring(0, prefixLength) + "-" + Math.abs(managedNamespace.hashCode() % 1000000);
            }
            managedNamespace = compliantNamespaceName;
        }
        return managedNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOrCreateNamespace(AuthCtx authCtx, String projectKey, ContainerExecUtils.KubernetesAwareContainerConfig config) throws IOException, InterruptedException {
        String managedNamespace = KubernetesNamespacesService.getNamespace(authCtx, projectKey, config);
        if (StringUtils.isBlank((String)managedNamespace)) {
            return null;
        }
        if (config.createNamespace) {
            Object object = KubernetesNamespacesService.getK8sNamespaceLock(managedNamespace);
            synchronized (object) {
                KubernetesNamespaceCache clusterNamespaceCache = namespaceCacheByClusterID.computeIfAbsent(config.overridenFromK8SClusterId, x -> new KubernetesNamespaceCache());
                if (clusterNamespaceCache.isNamespaceCached(managedNamespace)) {
                    return managedNamespace;
                }
                logger.debug((Object)("Checking if namespace " + managedNamespace + " needs to be created"));
                String existingNamespace = KubectlHelper.executeKubectlToJSONString(config, "get", "namespace", managedNamespace, "--ignore-not-found");
                if (StringUtils.isBlank((String)existingNamespace)) {
                    logger.info((Object)"  > creating");
                    KubectlHelper.executeKubectlToVoid(config, "create", "namespace", managedNamespace);
                    try {
                        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
                        KubernetesNamespacesService.applyNamespacePolicies(config, config.overridenFromK8SClusterId, managedNamespace, gs.k8sPoliciesSettings);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to apply policies to namespace", (Throwable)e);
                    }
                }
                clusterNamespaceCache.cacheNamespace(managedNamespace);
                logger.debug((Object)("Existence of namespace " + managedNamespace + " has been cached"));
            }
        }
        return managedNamespace;
    }

    private static void applyNamespacePolicies(ContainerExecUtils.KubernetesAwareContainerConfig config, String clusterId, String namespace, GeneralSettingsDAO.KubernetesPoliciesSettings policies) throws IOException, InterruptedException {
        for (GeneralSettingsDAO.KubernetesPolicy policy : policies.policies) {
            boolean appliesToCluster;
            boolean appliesToNamespace;
            logger.infoV("Considering applying policy=%s to cluster=%s ns=%s", new Object[]{JSON.log((Object)policy), clusterId, namespace});
            if (policy.namespacePattern == null) {
                appliesToNamespace = true;
            } else {
                Pattern p = Pattern.compile(policy.namespacePattern);
                appliesToNamespace = p.matcher(namespace).matches();
            }
            if (!appliesToNamespace) {
                logger.info((Object)" --> Namespace does not match, ignoring");
                continue;
            }
            if (clusterId == null || "__builtin__".equals(clusterId)) {
                appliesToCluster = policy.applyToDefaultCluster;
            } else {
                Pattern p = Pattern.compile(policy.dynamicClustersPattern);
                appliesToCluster = p.matcher(clusterId).matches();
            }
            if (!appliesToCluster) {
                logger.info((Object)" --> Cluster does not match, ignoring");
                continue;
            }
            for (GeneralSettingsDAO.KubernetesPolicyItem item : policy.items) {
                logger.info((Object)("Applying policy item:" + JSON.log((Object)item)));
                AutoDelete ad = DSSTempUtils.getTempFile((String)"kubernetes-policies", (String)"policy", (String)"yaml");
                try {
                    DKUFileUtils.writeFileUTF8((File)ad, (String)item.yaml);
                    KubectlHelper.executeKubectlToVoid(config, "apply", "--namespace", namespace, "-f", ad.getAbsolutePath());
                }
                finally {
                    if (ad == null) continue;
                    ad.close();
                }
            }
        }
    }

    public FutureResponse<InfoMessage.InfoMessages> applyAllPolicies(AuthCtx authCtx) throws Exception {
        return this.futureService.runFuture(new ApplyPoliciesThread(authCtx), 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    public static void clearNamespaceCache() {
        namespaceCacheByClusterID.clear();
    }

    public static class KubernetesNamespaceCache {
        private static final String KUBERNETES_NAMESPACE_CACHE_EXPIRATION_MS = "dku.k8s.namespaceCacheExpirationMS";
        private static final long expirationDuration = Long.parseLong(DKUApp.getProperty((String)"dku.k8s.namespaceCacheExpirationMS", (String)"60000"));
        private Map<String, Long> namespaces = new HashMap<String, Long>();

        public void cacheNamespace(String namespace) {
            long expirationTime = System.currentTimeMillis() + expirationDuration;
            this.namespaces.put(namespace, expirationTime);
        }

        public boolean isNamespaceCached(String namespace) {
            if (!this.namespaces.containsKey(namespace)) {
                return false;
            }
            long namespaceExpirationDate = this.namespaces.get(namespace);
            if (this.isNamespaceExpired(namespaceExpirationDate)) {
                this.namespaces.remove(namespace);
                return false;
            }
            return true;
        }

        private boolean isNamespaceExpired(long namespaceExpirationTime) {
            return System.currentTimeMillis() > namespaceExpirationTime;
        }
    }

    private class ApplyPoliciesThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        private SmartLogTail logTail;

        public ApplyPoliciesThread(AuthCtx owner) {
            super(owner);
            this.logTail = new SmartLogTail();
        }

        private List<String> listNamespaces(ContainerExecUtils.KubernetesAwareContainerConfig k8sConfig) throws IOException, InterruptedException {
            JsonObject obj = KubectlHelper.executeKubectlToJSON(k8sConfig, "get", "namespaces", "-o", "json");
            JsonArray items = JsonUtils.getOrEmptyArr(obj, "items");
            ArrayList<String> ret = new ArrayList<String>();
            for (JsonElement elt : items) {
                String nsName = JsonUtils.getOrNullStr((JsonObject)elt, "metadata", "name");
                if (nsName == null || "kube-system".equals(nsName)) continue;
                ret.add(nsName);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            DKULogger.startCurrentCall();
            try (AutoSmartLogTailRedirect asltr = new AutoSmartLogTailRedirect(this.logTail);){
                ArrayList<String> clusters = new ArrayList<String>();
                GeneralSettingsDAO.GeneralSettings gs = null;
                try (Transaction t = KubernetesNamespacesService.this.transactionService.beginRead();){
                    gs = KubernetesNamespacesService.this.generalSettingsDAO.getUnsafe();
                    for (Cluster c2 : KubernetesNamespacesService.this.clustersDAO.listUnsafe()) {
                        if (c2.architecture != Cluster.ClusterArchitecture.KUBERNETES || c2.state != Cluster.ClusterState.RUNNING) continue;
                        clusters.add(c2.id);
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Failed to list clusters", (Throwable)e);
                }
                clusters.add(null);
                for (String cluster : clusters) {
                    logger.info((Object)("Applying K8S policies on cluster= " + cluster));
                    ClusterSelection cs2 = new ClusterSelection();
                    if (cluster == null) {
                        cs2.clusterMode = ClusterSelection.ClusterMode.INHERIT;
                    } else {
                        cs2.clusterId = cluster;
                        cs2.clusterMode = ClusterSelection.ClusterMode.EXPLICIT_CLUSTER;
                    }
                    ClusterSettings clusterSettings = null;
                    if (cs2.clusterMode == ClusterSelection.ClusterMode.EXPLICIT_CLUSTER) {
                        clusterSettings = new ClusterSelector().selectForCluster(DSSAuthCtx.fakeAdminForTests("n/a"), cs2.clusterId, cs2.clusterId);
                    } else {
                        clusterSettings = new ClusterSelector().selectGlobal();
                        cluster = "__builtin__";
                    }
                    ContainerExecRuntimeConfig inlineConfig = new ContainerExecRuntimeConfig();
                    inlineConfig.type = ContainerExecRuntimeConfig.Container.KUBERNETES;
                    ContainerExecRuntimeConfig configOverrides = clusterSettings.getContainerSettings().executionConfigsGenericOverrides;
                    ContainerExecRuntimeConfig k8sConfig = ContainerOverrideMask.getOverriden(inlineConfig, configOverrides);
                    boolean anyAppliesToCluster = false;
                    if (cluster == null || "__builtin__".equals(cluster)) {
                        for (GeneralSettingsDAO.KubernetesPolicy policy : gs.k8sPoliciesSettings.policies) {
                            anyAppliesToCluster |= policy.applyToDefaultCluster;
                        }
                        k8sConfig.noImplicitK8sClusterAndNoDefaultClusterId = !gs.useImplicitK8sCluster;
                    } else {
                        for (GeneralSettingsDAO.KubernetesPolicy policy : gs.k8sPoliciesSettings.policies) {
                            Pattern p = Pattern.compile(policy.dynamicClustersPattern);
                            anyAppliesToCluster |= p.matcher(cluster).matches();
                        }
                    }
                    if (!anyAppliesToCluster) {
                        logger.info((Object)(" --> No policy applies to cluster " + cluster + ", not listing namespaces"));
                        break;
                    }
                    try {
                        logger.info((Object)("Listing namespaces in " + cluster));
                        List<String> namespaces = this.listNamespaces(k8sConfig);
                        logger.info((Object)("Namespaces: " + JSON.log(namespaces)));
                        for (String namespace : namespaces) {
                            KubernetesNamespacesService.applyNamespacePolicies(k8sConfig, cluster, namespace, gs.k8sPoliciesSettings);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to apply policies to cluster " + cluster), (Throwable)e);
                    }
                }
            }
            finally {
                DKULogger.endCurrentCall();
            }
            return new InfoMessage.InfoMessages().withInfo((InfoMessage.MessageCode)ContainerExecCodes.INFO_APPLY_K8S_POLICIES_OK, "OK");
        }

        public FuturePayload getPayload() {
            return null;
        }

        public SmartLogTail getLog() {
            return this.logTail;
        }
    }
}

