/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.dao.GitInfoDAO;
import com.dataiku.dip.git.GitInfo;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedGitInfoDAO
implements GitInfoDAO {
    private RelFile getGitInfoRelFile(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey));
        return new RelFile(new String[]{"projects", projectKey, ".dss-meta", "git-info.json"});
    }

    @Override
    public GitInfo getOrNull(String projectKey, boolean unsafe) throws IOException {
        RelFile gitInfoRelFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(gitInfoRelFile = this.getGitInfoRelFile(projectKey))) {
            return null;
        }
        GitInfo gitInfo = unsafe ? (GitInfo)t.readObjectUnsafe(gitInfoRelFile, GitInfo.class) : (GitInfo)t.readObject(gitInfoRelFile, GitInfo.class);
        gitInfo.projectKey = projectKey;
        return gitInfo;
    }

    @Override
    public void setup(GitInfo gitInfo) throws IOException {
        RelFile gitInfoRelFile;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.exists(gitInfoRelFile = this.getGitInfoRelFile(gitInfo.projectKey))) {
            if (gitInfo.originProjectKey != null) {
                t.writeObject(gitInfoRelFile, (Object)gitInfo);
            }
        } else if (gitInfo.originProjectKey == null) {
            this.remove(t, gitInfoRelFile);
        } else {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)gitInfo.branch));
            GitInfo currentGitInfo = (GitInfo)t.readObject(gitInfoRelFile, GitInfo.class);
            if (!gitInfo.branch.equals(currentGitInfo.branch)) {
                currentGitInfo.branch = gitInfo.branch;
                t.writeObject(gitInfoRelFile, (Object)currentGitInfo);
            }
        }
    }

    private void remove(RWTransactionRef t, RelFile gitInfoRelFile) throws IOException {
        if (!t.deleteFile(gitInfoRelFile)) {
            throw new IOException("Failed to delete " + String.valueOf(gitInfoRelFile));
        }
    }

    @Override
    public void remove(String projectKey) throws IOException {
        this.remove(TransactionContext.retrieveWrite(), this.getGitInfoRelFile(projectKey));
    }
}

