/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.ColumnForComputation;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.VariableType;
import com.dataiku.dip.datasets.Type;

public class FeatureContainer {
    public final String inputColumn;
    public final String groupByColumnName;
    public final AutoFeatureGenerationRecipePayloadParams.Feature featureToApply;
    public final String alias;
    public final VariableType variableType;
    public final Type schemaType;
    public final Type inputColumnType;
    public String description;

    public FeatureContainer(ColumnForComputation columnForComputation, AutoFeatureGenerationRecipePayloadParams.Feature featureToApply, String alias, String description) {
        this(columnForComputation, null, featureToApply, alias, description);
    }

    public FeatureContainer(ColumnForComputation columnForComputation, String groupByColumnName, AutoFeatureGenerationRecipePayloadParams.Feature featureToApply, String alias, String description) {
        this.inputColumn = columnForComputation == null ? null : columnForComputation.name;
        this.inputColumnType = columnForComputation == null ? Type.STRING : columnForComputation.schemaType;
        this.groupByColumnName = groupByColumnName;
        this.featureToApply = featureToApply;
        this.alias = alias;
        this.schemaType = featureToApply.getSchemaTypeForFeature(columnForComputation == null ? null : columnForComputation.schemaType);
        this.variableType = featureToApply.returnsNumericalValue ? VariableType.NUMERIC : VariableType.CATEGORY;
        this.description = description;
    }

    public FeatureContainer(ColumnForComputation columnForComputation, String alias, String description) {
        this.inputColumn = columnForComputation.name;
        this.inputColumnType = columnForComputation.schemaType;
        this.groupByColumnName = null;
        this.alias = alias;
        this.schemaType = columnForComputation.schemaType;
        this.variableType = columnForComputation.variableType;
        this.featureToApply = null;
        this.description = description;
    }

    public ColumnForComputation convertToColumn() {
        return new ColumnForComputation(this.alias, this.variableType, this.schemaType, this.description);
    }
}

