/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.join;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ConditionsMode;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class JoinRecipeSchemaComputer
extends JoinLikeRecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private VisualSQLRecipesBaseService visualRecipesService;
    @Autowired
    private TransactionService transactionService;
    private JoinRecipeHelper helper = new JoinRecipeHelper();
    private JoinRecipePayloadParams params;
    private JoinRecipeStatusComputer statusComputer;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.join.schema");

    public JoinRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.params = this.helper.loadParams(payload, this.recipe);
        this.statusComputer = new JoinRecipeStatusComputer(this.recipe, payload);
        SpringUtils.getInstance().autowire((Object)this.statusComputer);
    }

    public JoinRecipeHelper getHelper() {
        return this.helper;
    }

    public void setParams(JoinRecipePayloadParams params) {
        this.params = params;
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            JoinOutputRole validatedRole = JoinOutputRole.fromString(role);
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            if (!this.hasOutput(validatedRole)) {
                ArrayList arrayList = Lists.newArrayList();
                return arrayList;
            }
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema(validatedRole)});
            return arrayList;
        }
    }

    public boolean hasOutput(JoinOutputRole role) {
        return !this.recipe.getOutputsForRole(role.name).isEmpty();
    }

    public String getOutputFullName(JoinOutputRole role) {
        SerializedRecipe.RecipeOutput recipeOutput = this.recipe.getSingleOutput(role.name);
        AnyLoc loc = recipeOutput.getLoc(this.recipe.getProjectKey());
        return loc.getFullName();
    }

    private void fastSanityCheck() throws CodedException {
        if (this.statusComputer != null) {
            JoinRecipeStatusComputer.JoinRecipeStatus status = new JoinRecipeStatusComputer.JoinRecipeStatus();
            status.params = this.params;
            this.statusComputer.basicJoinsCheck(status, this.helper.datasetsMap);
            this.statusComputer.checkLargeOutput(status, this.helper);
            InfoMessage.InfoMessages statusMessages = status.gatherAllMessages();
            if (statusMessages.anyFatal()) {
                throw statusMessages.firstFatal().asCodedException();
            }
        }
    }

    public Schema getMainSchemaWithoutComputedColumns() throws Exception {
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
        boolean mustLowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        SQLDialect dialect = this.visualRecipesService.getDialect(this.authCtx, this.activity, selectedEngine);
        boolean caseInsensitive = mustLowerCaseColumnsNames || dialect != null && dialect.hasCaseInsensitiveColumns();
        boolean builtinEngine = selectedEngine != null && "DSS".equals(selectedEngine.type);
        this.helper.initInputDatasets(this.activity, this.params, builtinEngine, dialect, caseInsensitive);
        this.helper.initAliases(this.params, mustLowerCaseColumnsNames);
        this.fastSanityCheck();
        return this.getMainSchemaFromSelectedColumns(mustLowerCaseColumnsNames);
    }

    public VisualSQLRecipesBaseService.SQLBasedEngineStatus getEngine() throws Exception {
        return this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
    }

    public String computeColumnAlias(ColumnDesc columnDesc, String prefix, VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine) {
        TransactionContext.assertAttachedTransaction();
        boolean mustLowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        return JoinRecipeHelper.computeColumnAlias(columnDesc, prefix, mustLowerCaseColumnsNames);
    }

    private Schema getMainSchemaFromSelectedColumns(boolean lowerCase) {
        HashSet<String> usedColumnNames = new HashSet<String>();
        Schema outputSchema = new Schema();
        for (ColumnDesc cd : this.params.getSelectedColumns()) {
            JoinRecipePayloadParams.InputDesc inputDesc = (JoinRecipePayloadParams.InputDesc)this.params.virtualInputs.get(cd.table);
            Dataset dataset = this.helper.datasetsMap.get(inputDesc.name);
            if (dataset == null) {
                throw ErrorContext.iaef((String)"Dataset not found in inputs: \"%s\"", (Object)inputDesc.name, (Object[])new Object[0]);
            }
            if (usedColumnNames.contains(lowerCase ? cd.alias.toLowerCase() : cd.alias)) {
                throw ErrorContext.iaef((String)"Output schema contains duplicate column name %s\"%s\"", (Object)(lowerCase ? "(lower case) " : ""), (Object[])new Object[]{cd.alias});
            }
            if (!this.params.areInputColumnsSelectable(cd.table)) continue;
            usedColumnNames.add(lowerCase ? cd.alias.toLowerCase() : cd.alias);
            if (cd.name == null || cd.name.isEmpty()) continue;
            SchemaColumn col = ExpressionUtils.getSchemaColumn(cd.name, dataset.getSchema(), inputDesc.computedColumns);
            outputSchema.addColumn(SchemaColumn.copyWithNewName((String)cd.alias, (SchemaColumn)col));
        }
        return outputSchema;
    }

    private Schema getMainSchema() throws Exception {
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
        boolean mustLowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        Schema schema = this.getMainSchemaWithoutComputedColumns();
        if (this.params.computedColumns != null) {
            ComputedColumnUtils.addToSchema(schema, this.params.computedColumns);
        }
        if (mustLowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schema);
        }
        return schema;
    }

    private Schema getUnmatchedOutputSchema(boolean leftUnmatched) throws Exception {
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
        boolean mustLowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        SQLDialect dialect = this.visualRecipesService.getDialect(this.authCtx, this.activity, selectedEngine);
        boolean caseInsensitive = mustLowerCaseColumnsNames || dialect != null && dialect.hasCaseInsensitiveColumns();
        boolean builtinEngine = selectedEngine != null && "DSS".equals(selectedEngine.type);
        this.helper.initInputDatasets(this.activity, this.params, builtinEngine, dialect, caseInsensitive);
        this.helper.initAliases(this.params, mustLowerCaseColumnsNames);
        this.fastSanityCheck();
        JoinRecipePayloadParams.InputDesc inputDesc = (JoinRecipePayloadParams.InputDesc)this.params.virtualInputs.get(leftUnmatched ? ((JoinRecipePayloadParams.JoinDesc)this.params.joins.get((int)0)).table1 : ((JoinRecipePayloadParams.JoinDesc)this.params.joins.get((int)0)).table2);
        Dataset dataset = this.helper.datasetsMap.get(inputDesc.name);
        Schema outputSchema = new Schema();
        outputSchema.addColumns((Iterable)dataset.getSchema().columns);
        if (inputDesc.computedColumns != null) {
            ComputedColumnUtils.addToSchema(outputSchema, inputDesc.computedColumns);
        }
        if (mustLowerCaseColumnsNames) {
            SchemaUtils.lowerCase(outputSchema);
        }
        return outputSchema;
    }

    public Schema getSchema(JoinOutputRole role) throws Exception {
        return switch (role) {
            default -> throw new IncompatibleClassChangeError();
            case JoinOutputRole.MAIN -> this.getMainSchema();
            case JoinOutputRole.UNMATCHED_ROWS_LEFT -> this.getUnmatchedOutputSchema(true);
            case JoinOutputRole.UNMATCHED_ROWS_RIGHT -> this.getUnmatchedOutputSchema(false);
        };
    }

    @Override
    public boolean canUpdateRecipe() {
        return true;
    }

    @Override
    public RecipeSchemaService.RecipeSchemaAutoupdateResult updateRecipe_NT(JsonObject optionsObj) throws Exception {
        logger.info((Object)("update recipe options=" + JSON.log((Object)optionsObj)));
        JoinRecipeUpdateOptions options = optionsObj == null ? new JoinRecipeUpdateOptions() : (JoinRecipeUpdateOptions)JSON.parse((JsonElement)optionsObj, JoinRecipeUpdateOptions.class);
        RecipeSchemaService.RecipeSchemaAutoupdateResult ret = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        ArrayList inputSchemas = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            List<SerializedRecipe.RecipeInput> recipeInputs = this.recipe.getInputsForRole("main");
            for (JoinRecipePayloadParams.InputDesc inputDesc : this.params.virtualInputs) {
                SerializedRecipe.RecipeInput input = recipeInputs.get(inputDesc.index);
                AnyLoc inputLoc = input.getLoc(this.recipe.projectKey);
                Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
                Schema inputSchema = inputDataset.getSchema();
                for (ComputedColumn cc : inputDesc.getComputedColumns()) {
                    inputSchema.addColumn(cc.name, Type.forName((String)cc.type));
                }
                inputSchemas.add(inputSchema);
            }
        }
        if (options.removeMissingJoinConditions) {
            for (JoinRecipePayloadParams.JoinDesc join : this.params.joins) {
                if (join.conditionsMode == ConditionsMode.CUSTOM) continue;
                Schema schema1 = (Schema)inputSchemas.get(join.table1);
                Schema schema2 = (Schema)inputSchemas.get(join.table2);
                ArrayList conditionsToRemove = Lists.newArrayList();
                for (JoinRecipePayloadParams.MatchingCondition condition : join.on) {
                    if (schema1.getColumn(condition.column1.name) == null) {
                        conditionsToRemove.add(condition);
                        ret.recipeChanges.add(String.format("Removed join condition using %s", condition.column1.name));
                        continue;
                    }
                    if (schema2.getColumn(condition.column2.name) != null) continue;
                    conditionsToRemove.add(condition);
                    ret.recipeChanges.add(String.format("Removed join condition using %s", condition.column2.name));
                }
                join.on.removeAll(conditionsToRemove);
            }
        }
        if (options.removeMissingJoinValues) {
            ArrayList columnsToRemove = Lists.newArrayList();
            for (int i = 0; i < this.params.virtualInputs.size(); ++i) {
                JoinRecipePayloadParams.InputDesc inputDesc = (JoinRecipePayloadParams.InputDesc)this.params.virtualInputs.get(i);
                if (inputDesc.outputColumnsSelectionMode == JoinInputDescBase.OutputColumnsSelectionMode.AUTO_NON_CONFLICTING || inputDesc.outputColumnsSelectionMode == JoinInputDescBase.OutputColumnsSelectionMode.ALL) continue;
                Schema schema = (Schema)inputSchemas.get(i);
                for (ColumnDesc column : this.params.selectedColumns) {
                    if (column.table != i || schema.getColumn(column.name) != null) continue;
                    columnsToRemove.add(column);
                    ret.recipeChanges.add(String.format("Removed selected column %s", column.name));
                }
            }
            this.params.selectedColumns.removeAll(columnsToRemove);
        }
        if (!options.newSelectedColumns.isEmpty()) {
            this.updateSelectedColumns(options, ret, inputSchemas, this.params);
        }
        if (!ret.recipeChanges.isEmpty()) {
            ret.updatedRecipe = this.recipe;
            ret.updatedPayload = JSON.pretty((Object)this.params);
        }
        return ret;
    }

    public static class JoinRecipeUpdateOptions {
        public boolean removeMissingJoinConditions = false;
        public boolean removeMissingJoinValues = true;
        public Map<Type, List<ColumnDesc>> newSelectedColumns = Maps.newHashMap();
    }
}

