/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.AutoFastPathConnector;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.dataflow.exec.sync.CloudFileListingSupport;
import com.dataiku.dip.dataflow.exec.sync.DatabricksSupport;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class CloudToDatabricks<T extends BlobLikeDatasetHandler<?>>
extends SISORecipeExecutor
implements AutoFastPathConnector {
    public static final Pattern DATE_ERROR = Pattern.compile("^(?=.*\\bThe value\\b)(?=.*'([0-9]+\\/[0-9]+\\/[0-9]+)')(?=.*\\bcannot be cast\\b).*$", 40);
    private static final int MAX_SPECIFIED_FILES_PER_COPY = 1000;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.cloudtodatabricks");

    @Override
    public List<FlowRunnable> getRunnables() {
        return Collections.emptyList();
    }

    protected void prepareOutputTable(SQLConnectionProvider.SQLConnectionWrapper connection, SQLConnectionProvider.SQLConnectionData connData) throws Exception {
        SQLDialect dialect = connData.getDialect();
        try {
            logger.info((Object)("Setup Databricks output partition : " + this.outputPartition.id()));
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            dialect.dropIfNeededAndCreateTableOrPartition(this.authCtx, connData, connection, this.outputDS, this.outputPartition, this.writeMode, messages);
            if (!messages.isEmpty()) {
                this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Databricks table setup failed", (Throwable)e);
            throw e;
        }
    }

    private boolean shouldCast(SchemaColumn sc) {
        return sc.getType().isTemporal();
    }

    protected String generateColumnNames(Dataset ds, SQLDialect dialect, boolean isCsv) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Set inputColumnNames = this.inputDS.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        for (SchemaColumn col : ds.getSchema().getColumns()) {
            boolean shouldCast;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            String quotedColumnName = dialect.quoteIdentifier(col.getName());
            boolean bl = isCsv ? col.getType() != Type.STRING : (shouldCast = this.shouldCast(col));
            if (inputColumnNames.contains(col.getName())) {
                Object csvColumnName;
                Object object = csvColumnName = isCsv ? "_c" + i++ : col.getName();
                if (shouldCast) {
                    csvColumnName = String.format("CAST(%s as %s)", csvColumnName, dialect.getSQLType((SchemaColumn)col, (Dataset)ds).sqlDecl);
                }
                sb.append((String)csvColumnName).append(" AS ").append(quotedColumnName);
                continue;
            }
            DimensionValue dv = (DimensionValue)this.outputPartition.getDimensionValues().get(col.getName());
            if (dv == null) {
                throw new IllegalStateException("Missing partition value: " + col.getName() + " in partition: " + String.valueOf(this.outputPartition));
            }
            String value = col.getType().isTemporal() ? ExpressionUtils.getStringForDimensionValue((DimensionValue)this.outputPartition.getDimensionValues().get(col.getName()), col.getType()) : FastpathUtils.getPartitionValue(col.getName(), this.outputPartition);
            String columnExpr = String.format("CAST(%s as %s)", dialect.quoteString(value), dialect.getSQLType((SchemaColumn)col, (Dataset)ds).sqlDecl);
            sb.append(columnExpr).append(" AS ").append(quotedColumnName);
        }
        return sb.toString();
    }

    protected static CloudBlobSupport.CopyMode getCopyMode(Dataset inputDS) throws IOException, DKUSecurityException {
        return CloudToDatabricks.getCopyMode_internal(inputDS, false);
    }

    protected static CloudBlobSupport.CopyMode getCopyModeNoHadoop(Dataset inputDS) throws IOException, DKUSecurityException {
        return CloudToDatabricks.getCopyMode_internal(inputDS, true);
    }

    private static CloudBlobSupport.CopyMode getCopyMode_internal(Dataset inputDS, boolean noHadoop) throws IOException, DKUSecurityException {
        switch (inputDS.getFormatType()) {
            case "csv": {
                return CloudBlobSupport.getCsvToDatabricks(inputDS, false);
            }
            case "parquet": {
                if (noHadoop) {
                    throw new CloudBlobSupport.CloudBlobToSQLImpossibleException("Input file format not supported: " + inputDS.getFormatType());
                }
                return CloudBlobSupport.getParquetToDatabricks(inputDS);
            }
            case "orcfile": {
                if (noHadoop) {
                    throw new CloudBlobSupport.CloudBlobToSQLImpossibleException("Input file format not supported: " + inputDS.getFormatType());
                }
                return CloudBlobSupport.getOrcToDatabricks(inputDS);
            }
            case "avro": {
                return CloudBlobSupport.getAvroToDatabricks(inputDS);
            }
        }
        throw new CloudBlobSupport.CloudBlobToSQLImpossibleException("Input file format not supported: " + inputDS.getFormatType());
    }

    protected String generateInsertFromTempTableStatement(Dataset outputDS, String destinationTableFullName, String temporaryTableFullName, Schema temporaryTableSchema, SQLDialect dialect, int skipRows) {
        Set inputColumnNames = this.inputDS.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        ArrayList<Object> selectClauseFields = new ArrayList<Object>();
        for (SchemaColumn col : outputDS.getSchema().columns) {
            String quotedColumnName = dialect.quoteIdentifier(col.getName());
            if (this.outputPartition != null && this.outputPartition.getDimensionValues().containsKey(col.getName())) {
                String dimensionValue;
                if (col.getType().isTemporal()) {
                    dimensionValue = ExpressionUtils.getStringForDimensionValue((DimensionValue)this.outputPartition.getDimensionValues().get(col.getName()), col.getType());
                    selectClauseFields.add(dialect.quoteString(dimensionValue) + " AS " + quotedColumnName);
                    continue;
                }
                dimensionValue = FastpathUtils.getPartitionValue(col.getName(), this.outputPartition);
                selectClauseFields.add(dialect.quoteString(dimensionValue) + " AS " + quotedColumnName);
                continue;
            }
            if (inputColumnNames.contains(col.getName())) {
                SchemaColumn temporaryTableColumn = temporaryTableSchema.getColumn(col.getName());
                if (temporaryTableColumn == null) {
                    throw new IllegalStateException("Missing column: " + col.getName() + " in input dataset");
                }
                if (col.getType() == Type.DATEONLY && temporaryTableColumn.getType() == Type.STRING) {
                    String caseToSupportBothDateOnlyFormats = String.format("CASE WHEN CONTAINS(%1$s, '/') THEN TO_DATE(%1$s, 'yyyy/MM/dd') ELSE %1$s END AS %1$s", quotedColumnName);
                    selectClauseFields.add(caseToSupportBothDateOnlyFormats);
                    continue;
                }
                selectClauseFields.add(quotedColumnName);
                continue;
            }
            throw new IllegalStateException("Missing column: " + col.getName() + " in input dataset");
        }
        String selectClause = Joiner.on((String)", ").join(selectClauseFields);
        String selectSQL = skipRows > 0 ? String.format("SELECT %s FROM (SELECT monotonically_increasing_id() AS dku_fake_id_for_skip_rows, %s FROM %s) WHERE dku_fake_id_for_skip_rows >= %s", selectClause, selectClause, temporaryTableFullName, skipRows) : String.format("SELECT %s FROM %s", selectClause, temporaryTableFullName);
        return String.format("INSERT INTO %s %s", destinationTableFullName, selectSQL);
    }

    abstract DisplayableSQLChunk getCredentials(T var1, SQLConnectionProvider.SQLConnectionData var2) throws DKUSecurityException, IOException;

    private void executeCopyStatementFromCloud(Statement stmt, Dataset outputDS, SQLUtils.SQLTable outputTable, String inputRootPath, String specifiedFilePaths, CloudBlobSupport.CopyMode mode, T blobDShandler, boolean append, SQLConnectionProvider.SQLConnectionWrapper connWrapper) throws DKUSecurityException, IOException, SQLException {
        DisplayableSQLChunk credentials = this.getCredentials(blobDShandler, connWrapper.getConnectionData());
        SQLDialect dialect = connWrapper.getDialect();
        String outputTableFullName = dialect.getQuotedTableFullName(outputTable);
        boolean isCSV = mode.type == CloudBlobSupport.CopyModeType.CSV;
        Object files = StringUtils.isNotBlank((String)specifiedFilePaths) ? " FILES = (" + specifiedFilePaths + ")" : "";
        boolean hasParquetDateColumn = mode.type == CloudBlobSupport.CopyModeType.PARQUET && this.inputDS.getSchema().columns.stream().filter(sc -> this.shouldCast((SchemaColumn)sc)).findAny().isPresent();
        boolean useSelect = isCSV || hasParquetDateColumn;
        String from = useSelect ? "( SELECT %s FROM '%s' %s )" : " %s '%s' %s ";
        String forceCopy = append ? ", 'force' = 'true'" : "";
        String copyQueryPattern = "COPY INTO %s FROM " + from + " FILEFORMAT = %s  %s  %s  COPY_OPTIONS ('mergeSchema' = 'true' %s)";
        String columnNames = useSelect ? this.generateColumnNames(outputDS, dialect, isCSV) : "";
        String format = DatabricksSupport.generateFormat(mode);
        Object formatOptions = DatabricksSupport.generateFormatOption(mode);
        if (StringUtils.isNotBlank((String)formatOptions)) {
            formatOptions = "FORMAT_OPTIONS ( " + (String)formatOptions + " )";
        }
        String cmd = String.format(copyQueryPattern, outputTableFullName, columnNames, inputRootPath, credentials.sql, format, files, formatOptions, forceCopy);
        String displayCmd = String.format(copyQueryPattern, outputTableFullName, columnNames, inputRootPath, credentials.displayedSql, format, files, formatOptions, forceCopy);
        try {
            SQLUtils.execute(connWrapper, stmt, cmd, displayCmd, true, true);
        }
        catch (SQLException exc) {
            if (isCSV && exc.getMessage() != null && exc.getMessage().contains("[UNRESOLVED_COLUMN.WITHOUT_SUGGESTION]") && exc.getMessage().contains("_c0")) {
                logger.info((Object)"Skipping error in COPY INTO statement as it looks like empty CSV files");
            }
            SQLException sqlExc = FastpathUtils.checkDateFormatError(exc, DATE_ERROR, "Databricks");
            throw sqlExc != null ? sqlExc : exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadWithTempTable(CloudFileListingSupport.InputFSPaths inputFSPaths, T blobDShandler, CloudBlobSupport.CopyMode mode, Statement stmt, Dataset outputDS, SQLUtils.SQLTable destinationTable, SQLConnectionProvider.SQLConnectionWrapper connWrapper, boolean appendInsteadOfOverwrite) throws IOException, DKUSecurityException, SQLException {
        Dataset temporaryDS = (Dataset)JSON.deepCopy((Object)outputDS);
        if (mode.type == CloudBlobSupport.CopyModeType.CSV) {
            FastpathUtils.adjustTemporaryTableSchemaForCsvInput(temporaryDS.getSchema());
        }
        DatabricksConnection connection = (DatabricksConnection)connWrapper.getConnectionData().getConnection();
        String temporaryTableName = "temp_load_" + SecretKeyGenerator.generate((int)10);
        AbstractSQLDatasetHandler.AbstractSQLConfig config = temporaryDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        config.table = temporaryTableName;
        config.catalog = DatabricksSupport.getCatalog(destinationTable, connection, "main");
        config.schema = DatabricksSupport.getSchema(destinationTable, connection, "default");
        SQLDialect dialect = connWrapper.getDialect();
        String creationSQL = dialect.getCreateTableStatementSQL(connWrapper.getConnectionData().getConnection(), temporaryDS, new InfoMessage.InfoMessages(), false);
        logger.info((Object)("Create temp table with: \n" + creationSQL));
        stmt.execute(creationSQL);
        SQLUtils.SQLTable tempTable = new SQLUtils.SQLTable(config.catalog, config.schema, temporaryTableName);
        try {
            logger.info((Object)"Loading into temporary table ...");
            this.copyInputFSPaths(inputFSPaths, blobDShandler, mode, stmt, connWrapper, temporaryDS, tempTable, false);
            logger.info((Object)"Temporary table loaded.");
            String insertIntoSQL = this.generateInsertFromTempTableStatement(outputDS, dialect.getQuotedTableFullName(destinationTable), dialect.getQuotedTableFullName(tempTable), temporaryDS.getSchema(), dialect, mode.ignoreHeader);
            logger.info((Object)("Transfer to target table with:\n" + insertIntoSQL));
            stmt.execute(insertIntoSQL);
        }
        catch (Throwable throwable) {
            if (!ApplicationConfigurator.getParams().getBoolParam("dip.databricks.fastpath.keepTempTable", false)) {
                String dropSQL = String.format("DROP TABLE %s", dialect.getQuotedTableFullName(tempTable));
                logger.info((Object)("Drop temp table with: \n" + dropSQL));
                try {
                    stmt.execute(dropSQL);
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to drop temporary table", (Throwable)e);
                }
            }
            throw throwable;
        }
        if (!ApplicationConfigurator.getParams().getBoolParam("dip.databricks.fastpath.keepTempTable", false)) {
            String dropSQL = String.format("DROP TABLE %s", dialect.getQuotedTableFullName(tempTable));
            logger.info((Object)("Drop temp table with: \n" + dropSQL));
            try {
                stmt.execute(dropSQL);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to drop temporary table", (Throwable)e);
            }
        }
    }

    private void copyInputFSPaths(CloudFileListingSupport.InputFSPaths inputFSPaths, T blobDShandler, CloudBlobSupport.CopyMode mode, Statement stmt, SQLConnectionProvider.SQLConnectionWrapper connWrapper, Dataset outputDS, SQLUtils.SQLTable outputTable, boolean appendInsteadOfOverwrite) throws DKUSecurityException, IOException, SQLException {
        if (inputFSPaths.useChunkedFilePaths) {
            for (List<String> filePaths : inputFSPaths.chunkedFilePaths) {
                this.executeCopyStatementFromCloud(stmt, outputDS, outputTable, inputFSPaths.rootPath, CloudFileListingSupport.createSpecifiedFilesList(filePaths), mode, blobDShandler, appendInsteadOfOverwrite, connWrapper);
            }
        } else {
            this.executeCopyStatementFromCloud(stmt, outputDS, outputTable, inputFSPaths.rootPath, "", mode, blobDShandler, appendInsteadOfOverwrite, connWrapper);
        }
    }

    abstract void setUpCredentials(T var1, SQLConnectionProvider.SQLConnectionData var2, Statement var3) throws SQLException, DKUSecurityException, IOException;

    abstract String getRoot(T var1) throws CodedException, IOException, DKUSecurityException;

    protected void executeCopy(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper connWrapper, T blobHandler, CloudBlobSupport.CopyMode mode, Dataset outputDS, SQLUtils.SQLTable outputTable, boolean appendInsteadOfOverwrite) throws Exception {
        String rootPath = this.getRoot(blobHandler);
        CloudFileListingSupport.InputFSPaths inputFSPaths = CloudFileListingSupport.createInputFSPaths(blobHandler, rootPath, this.inputDS, this.inputPartitions, this.authCtx, 1000);
        try (Statement stmt = connWrapper.createStatement();){
            this.setUpCredentials(blobHandler, connData, stmt);
            this.executeCopyStatement(inputFSPaths, blobHandler, mode, appendInsteadOfOverwrite, stmt, outputDS, outputTable, connWrapper);
        }
    }

    private boolean needsTempTableForCsvInputDataset(int ignoreHeader) {
        return ignoreHeader > 0 || FastpathUtils.inputDatasetHasDateOnlyColumn(this.inputDS);
    }

    protected void executeCopyStatement(CloudFileListingSupport.InputFSPaths inputFSPaths, T blobHandler, CloudBlobSupport.CopyMode mode, boolean appendInsteadOfOverwrite, Statement stmt, Dataset outputDS, SQLUtils.SQLTable destinationTable, SQLConnectionProvider.SQLConnectionWrapper connWrapper) throws IOException, DKUSecurityException, SQLException {
        if (outputDS.getPartitioningSchema().isPartitioned()) {
            this.loadWithTempTable(inputFSPaths, blobHandler, mode, stmt, outputDS, destinationTable, connWrapper, appendInsteadOfOverwrite);
        } else if (mode.type == CloudBlobSupport.CopyModeType.CSV && this.needsTempTableForCsvInputDataset(mode.ignoreHeader)) {
            this.loadWithTempTable(inputFSPaths, blobHandler, mode, stmt, outputDS, destinationTable, connWrapper, appendInsteadOfOverwrite);
        } else {
            this.copyInputFSPaths(inputFSPaths, blobHandler, mode, stmt, connWrapper, outputDS, destinationTable, appendInsteadOfOverwrite);
        }
    }

    @Override
    public void initForAutoFastPath(AuthCtx authCtx, WarningsContext warnContext, Dataset cloudDataset, Partition cloudPartition, Dataset dataset, Output.WriteMode writeMode) throws Exception {
        this.outputDS = dataset;
        this.inputDS = cloudDataset;
        this.contextProjectKey = dataset.getProjectKey();
        this.inputPartitions = Lists.newArrayList((Object[])new Partition[]{cloudPartition});
        this.outputPartition = cloudPartition;
        this.writeMode = writeMode;
        this.authCtx = authCtx;
        this.warnContext = warnContext;
        this.clearOutputPartitionsIfNeeded();
    }

    public static class DisplayableSQLChunk {
        public String sql;
        public String displayedSql;

        public DisplayableSQLChunk(String sql) {
            this.sql = sql;
            this.displayedSql = sql;
        }

        public DisplayableSQLChunk(String sql, String displayedSql) {
            this.sql = sql;
            this.displayedSql = displayedSql;
        }
    }
}

