/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.topn;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.exec.topn.AbstractTopNRecipeExecutor;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.server.recipes.TopNRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTopNRecipeSQLlikeExecutor
extends AbstractTopNRecipeExecutor {
    @Autowired
    protected TopNRecipeService service;
    private AbortableRecipeRunner currentRunner = null;
    private boolean abortNotified;

    public AbstractTopNRecipeSQLlikeExecutor(JobActivity activity, TopNRecipePayloadParams params) {
        super(activity, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        Map<String, String> outputs = this.getOutputs();
        List<AbortableRecipeRunner> runners = this.getRunners(outputs);
        for (AbortableRecipeRunner runner : runners) {
            AbstractTopNRecipeSQLlikeExecutor abstractTopNRecipeSQLlikeExecutor = this;
            synchronized (abstractTopNRecipeSQLlikeExecutor) {
                if (this.abortNotified) {
                    logger.info((Object)"abort notified, skipping next runners");
                    return;
                }
                this.currentRunner = runner;
            }
            if (runner instanceof Initializable) {
                ((Initializable)((Object)runner)).init();
            }
            runner.run();
        }
    }

    private Map<String, String> getOutputs() throws IOException {
        HashMap outputs = Maps.newHashMap();
        outputs.put(this.service.getDatasetFromRole(this.recipe.getModel(), "main").getFullName(), "main");
        if (this.service.hasRejectsOutput(this.recipe.getModel())) {
            outputs.put(this.service.getDatasetFromRole(this.recipe.getModel(), "rejects").getFullName(), "rejects");
        }
        return outputs;
    }

    protected abstract List<AbortableRecipeRunner> getRunners(Map<String, String> var1) throws Exception;

    protected String generateSQL(SQLDialect dialect, String role) throws Exception {
        return this.service.generateSQL(this.activity, this.recipe, dialect, this.inputDS, this.params, role, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        AbortableRecipeRunner runner;
        AbstractTopNRecipeSQLlikeExecutor abstractTopNRecipeSQLlikeExecutor = this;
        synchronized (abstractTopNRecipeSQLlikeExecutor) {
            if (this.abortNotified) {
                logger.info((Object)"abort already notified");
                return;
            }
            this.abortNotified = true;
            runner = this.currentRunner;
        }
        if (runner != null) {
            runner.notifyBeforeAborting();
        }
    }
}

