/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.topn;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeSchemaComputer;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.WithMessages;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TopNRecipeCreator
extends GenericRecipeCreator {
    @Autowired
    DatasetsDAO datasetsDAO;
    @Autowired
    private FlowZonesService flowZonesService;
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.topn");

    public TopNRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data) throws IOException {
        Dataset outputDataset = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(recipe.getSingleOutput("main").getLoc(recipe.getProjectKey())));
        return this.makeInitialPayload(recipe, outputDataset);
    }

    protected String makeInitialPayload(SerializedRecipe recipe, Dataset outputDataset) throws IOException {
        TopNRecipePayloadParams params = new TopNRecipePayloadParams();
        Dataset inputDataset = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(recipe.getSingleInput("main").getLoc(recipe.getProjectKey())));
        Schema inputSchema = inputDataset.getSchema();
        if (inputSchema != null) {
            HashSet excludedFromInput = Sets.newHashSet();
            if (outputDataset.getPartitioningSchema() != null && outputDataset.getPartitioningSchema().isPartitioned() && DatasetInspector.arePartitioningColumnsForbiddenInSchema(outputDataset)) {
                excludedFromInput.addAll(outputDataset.getPartitioningSchema().getDimensionNames());
            }
            if (excludedFromInput.isEmpty()) {
                params.retrievedColumnsSelectionMode = TopNRecipePayloadParams.RetrievedColumnsSelectionMode.ALL;
            } else {
                params.retrievedColumnsSelectionMode = TopNRecipePayloadParams.RetrievedColumnsSelectionMode.EXPLICIT;
                for (SchemaColumn col : inputSchema.columns) {
                    if (excludedFromInput.contains(col.getName())) continue;
                    params.retrievedColumns.add(col.getName());
                }
            }
        }
        RecipeCreationUtils.setupAllEnginesCreationParams(this.authCtx, recipe.projectKey, params.engineParams);
        RecipeCreationUtils.switchToHiveserverForHiveDataset(inputDataset, params.engineParams);
        params.engineParams.lowerCaseSchemaIfEngineRequiresIt = true;
        return JSON.json((Object)params);
    }

    private void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        FlowRecipe fr = new FlowRecipe(recipe);
        JobActivity activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(fr));
        TopNRecipeSchemaComputer schemaComputer = (TopNRecipeSchemaComputer)this.meta.buildSchemaComputer(this.authCtx, activity);
        schemaComputer.setPayload(payload);
        outputDataset.setSchema(schemaComputer.getSchema());
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        assert (StringUtils.isNotBlank((String)recipe.projectKey));
        assert (this.meta.getType().equals(recipe.type));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)recipe.name), (Object)"Recipe has no name");
        List<SerializedRecipe.RecipeOutput> outputs = recipe.getOutputsForRole("main");
        Preconditions.checkArgument((outputs.size() == 1 ? 1 : 0) != 0, (Object)(this.meta.getType() + " recipes require one output"));
        RecipeCreator.CreationResult ret = new RecipeCreator.CreationResult();
        String outputDatasetName = outputs.get((int)0).ref;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            String payload;
            SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings settings = (SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings)JSON.parse((JsonElement)creationData, SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings.class);
            recipe.name = this.recipeSaveService.transmogrifyName(recipe.projectKey, recipe.name);
            recipe.params = this.makeInitialParams(recipe, creationData);
            if (StringUtils.isBlank((String)settings.zone)) {
                settings.zone = this.flowZonesService.retrieveInputZone(recipe);
            }
            if (settings.outputDatasetSettings != null && StringUtils.isBlank((String)settings.outputDatasetSettings.zone)) {
                settings.outputDatasetSettings.zone = settings.zone;
            }
            this.flowZonesService.attachObjectToZone(settings.zone, recipe.getProjectKey(), recipe);
            if (settings.createOutputDataset) {
                Dataset outputDataset = this.mdcService.prepare(this.authCtx, recipe.projectKey, outputDatasetName, settings.outputDatasetSettings);
                SerializedDataset sds = outputDataset.serialize();
                this.flowZonesService.attachObjectToZone(settings.outputDatasetSettings.zone, sds.getProjectKey(), sds);
                logger.info((Object)("Creating dataset " + JSON.prettyLog((Object)sds)));
                DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildFromRecipe(recipe);
                WithMessages<SerializedDataset> createdDataset = this.datasetSaveService.create(recipe.projectKey, sds, dsCtx, this.authCtx);
                ret.messages.mergeFrom(createdDataset.messages);
                outputDataset = Dataset.fromSerialized((SerializedDataset)createdDataset.value);
                payload = this.makeInitialPayload(recipe, outputDataset);
                try {
                    this.setOutputSchema(recipe, payload, outputDataset);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to set the output schema!", (Throwable)e);
                }
                WithMessages<SerializedDataset> savedDataset = this.datasetSaveService.saveWithoutEvents(recipe.projectKey, outputDataset.getName(), sds, this.authCtx);
                ret.messages.mergeFrom(savedDataset.messages);
            } else {
                payload = this.makeInitialPayload(recipe, creationData);
            }
            new PDepsFixuper().fixupInPlace(recipe);
            this.checkOutputOwnership_T(recipe);
            this.recipeSaveService.create(recipe.projectKey, recipe, payload);
            this.updateOriginRecipes(recipe, creationData);
            t.commitV("Created %s recipe: %s", new Object[]{recipe.type, recipe.getFullId()});
            RecipeCreator.CreationResult creationResult = ret.withId(recipe.name);
            return creationResult;
        }
    }

    @Override
    public RecipeCreator.CreationResult copy_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload source, JsonObject copyData) throws Exception {
        assert (StringUtils.isNotBlank((String)projectKey));
        assert (this.meta.getType().equals(source.recipe.type));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)source.recipe.name), (Object)"Recipe has no name");
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            SerializedRecipe copy = this.copyCore((String)projectKey, (SerializedRecipe)source.recipe, (String)source.payload, (JsonObject)copyData).recipe;
            TopNRecipePayloadParams params = (TopNRecipePayloadParams)JSON.parse((String)source.payload, TopNRecipePayloadParams.class);
            String payload = JSON.pretty((Object)params);
            this.recipeSaveService.create(projectKey, copy, payload);
            t.commitV("Created %s recipe %s", new Object[]{copy.type, copy.name});
            RecipeCreator.CreationResult creationResult = new RecipeCreator.CreationResult().withId(copy.name);
            return creationResult;
        }
    }
}

